/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.modeshape.webdav.AbstractWebDAVTest;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.DoCopy;
import org.modeshape.webdav.methods.DoDelete;
import org.modeshape.webdav.methods.DoMove;
import org.springframework.mock.web.DelegatingServletInputStream;

public class DoMoveTest
extends AbstractWebDAVTest {
    private static final String OVERWRITE_PATH = "/tmp/tests/destFolder/sourceFolder";

    @Test
    public void testMovingOfFileOrFolderIfReadOnlyIsTrue() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletResponse)this.oneOf(DoMoveTest.this.mockRes)).sendError(403);
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, true);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, true);
        DoMove doMove = new DoMove(resLocks, doDelete, doCopy, true);
        doMove.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testMovingOfaFileIfDestinationNotPresent() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(2.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(2.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.exactly(2).of((Object)DoMoveTest.this.mockReq)).getHeader("Destination");
                this.will(2.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getServerName();
                this.will(2.returnValue((Object)"serverName"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getContextPath();
                this.will(2.returnValue((Object)""));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(2.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getServletPath();
                this.will(2.returnValue((Object)"/servletPath"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(2.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(2.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getHeader("Overwrite");
                this.will(2.returnValue((Object)"F"));
                StoredObject sourceFileSo = DoMoveTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(2.returnValue((Object)sourceFileSo));
                StoredObject destFileSo = null;
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                this.will(2.returnValue(destFileSo));
                ((HttpServletResponse)this.oneOf(DoMoveTest.this.mockRes)).setStatus(201);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(2.returnValue((Object)sourceFileSo));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).createResource(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getResourceContent(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                DelegatingServletInputStream resourceStream = DoMoveTest.this.resourceRequestStream();
                this.will(2.returnValue((Object)resourceStream));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).setResourceContent(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/destFile", (InputStream)resourceStream, null, null);
                this.will(2.returnValue((Object)RESOURCE_LENGTH));
                destFileSo = DoMoveTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                this.will(2.returnValue((Object)destFileSo));
                ((HttpServletResponse)this.oneOf(DoMoveTest.this.mockRes)).setStatus(204);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(2.returnValue((Object)sourceFileSo));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).removeObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        DoMove doMove = new DoMove(resLocks, doDelete, doCopy, false);
        doMove.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testMovingOfaFileIfDestinationIsPresentAndOverwriteFalse() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(3.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(3.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.exactly(2).of((Object)DoMoveTest.this.mockReq)).getHeader("Destination");
                this.will(3.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getServerName();
                this.will(3.returnValue((Object)"server_name"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getContextPath();
                this.will(3.returnValue((Object)""));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(3.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getServletPath();
                this.will(3.returnValue((Object)"servlet_path"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(3.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(3.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getHeader("Overwrite");
                this.will(3.returnValue((Object)"F"));
                StoredObject sourceFileSo = DoMoveTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(3.returnValue((Object)sourceFileSo));
                StoredObject destFileSo = DoMoveTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                this.will(3.returnValue((Object)destFileSo));
                ((HttpServletResponse)this.oneOf(DoMoveTest.this.mockRes)).sendError(412);
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        DoMove doMove = new DoMove(resLocks, doDelete, doCopy, false);
        doMove.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testMovingOfaFileIfDestinationIsPresentAndOverwriteTrue() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(4.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(4.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.exactly(2).of((Object)DoMoveTest.this.mockReq)).getHeader("Destination");
                this.will(4.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getServerName();
                this.will(4.returnValue((Object)"server_name"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getContextPath();
                this.will(4.returnValue((Object)""));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(4.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getServletPath();
                this.will(4.returnValue((Object)"servlet_path"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(4.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(4.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getHeader("Overwrite");
                this.will(4.returnValue((Object)"T"));
                StoredObject sourceFileSo = DoMoveTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(4.returnValue((Object)sourceFileSo));
                StoredObject destFileSo = DoMoveTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                this.will(4.returnValue((Object)destFileSo));
                ((HttpServletResponse)this.oneOf(DoMoveTest.this.mockRes)).setStatus(204);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                this.will(4.returnValue((Object)destFileSo));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).removeObject(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(4.returnValue((Object)sourceFileSo));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).createResource(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getResourceContent(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                DelegatingServletInputStream resourceStream = DoMoveTest.this.resourceRequestStream();
                this.will(4.returnValue((Object)resourceStream));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).setResourceContent(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/destFile", (InputStream)resourceStream, null, null);
                this.will(4.returnValue((Object)RESOURCE_LENGTH));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                this.will(4.returnValue((Object)destFileSo));
                ((HttpServletResponse)this.oneOf(DoMoveTest.this.mockRes)).setStatus(204);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(4.returnValue((Object)sourceFileSo));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).removeObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        DoMove doMove = new DoMove(resLocks, doDelete, doCopy, false);
        doMove.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testMovingOfaFileIfSourceNotPresent() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(5.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(5.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.exactly(2).of((Object)DoMoveTest.this.mockReq)).getHeader("Destination");
                this.will(5.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getServerName();
                this.will(5.returnValue((Object)"server_name"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getContextPath();
                this.will(5.returnValue((Object)""));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(5.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getServletPath();
                this.will(5.returnValue((Object)"servlet_path"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(5.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(5.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getHeader("Overwrite");
                this.will(5.returnValue((Object)"F"));
                Object sourceFileSo = null;
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(5.returnValue(sourceFileSo));
                ((HttpServletResponse)this.oneOf(DoMoveTest.this.mockRes)).sendError(404);
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        DoMove doMove = new DoMove(resLocks, doDelete, doCopy, false);
        doMove.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testMovingIfSourcePathEqualsDestinationPath() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(6.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(6.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.exactly(2).of((Object)DoMoveTest.this.mockReq)).getHeader("Destination");
                this.will(6.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getServerName();
                this.will(6.returnValue((Object)"server_name"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getContextPath();
                this.will(6.returnValue((Object)""));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(6.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getServletPath();
                this.will(6.returnValue((Object)"servlet_path"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(6.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(6.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletResponse)this.oneOf(DoMoveTest.this.mockRes)).sendError(403);
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        DoMove doMove = new DoMove(resLocks, doDelete, doCopy, false);
        doMove.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testMovingOfaCollectionIfDestinationIsNotPresent() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(7.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(7.returnValue((Object)"/tmp/tests/sourceFolder"));
                ((HttpServletRequest)this.exactly(2).of((Object)DoMoveTest.this.mockReq)).getHeader("Destination");
                this.will(7.returnValue((Object)"/tmp/tests/destFolder"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getServerName();
                this.will(7.returnValue((Object)"server_name"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getContextPath();
                this.will(7.returnValue((Object)""));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(7.returnValue((Object)"/tmp/tests/destFolder"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getServletPath();
                this.will(7.returnValue((Object)"servlet_path"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(7.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(7.returnValue((Object)"/tmp/tests/sourceFolder"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getHeader("Overwrite");
                this.will(7.returnValue((Object)"F"));
                StoredObject sourceCollectionSo = DoMoveTest.this.initFolderStoredObject();
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder");
                this.will(7.returnValue((Object)sourceCollectionSo));
                Object destCollectionSo = null;
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder");
                this.will(7.returnValue(destCollectionSo));
                ((HttpServletResponse)this.oneOf(DoMoveTest.this.mockRes)).setStatus(201);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder");
                this.will(7.returnValue((Object)sourceCollectionSo));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).createFolder(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder");
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getHeader("Depth");
                this.will(7.returnValue(null));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getChildrenNames(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder");
                this.will(7.returnValue((Object)new String[]{"sourceFile"}));
                StoredObject sourceFileSo = DoMoveTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(7.returnValue((Object)sourceFileSo));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).createResource(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/sourceFile");
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getResourceContent(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                DelegatingServletInputStream resourceStream = DoMoveTest.this.resourceRequestStream();
                this.will(7.returnValue((Object)resourceStream));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).setResourceContent(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/sourceFile", (InputStream)resourceStream, null, null);
                this.will(7.returnValue((Object)RESOURCE_LENGTH));
                StoredObject movedSo = DoMoveTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/sourceFile");
                this.will(7.returnValue((Object)movedSo));
                ((HttpServletResponse)this.oneOf(DoMoveTest.this.mockRes)).setStatus(204);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder");
                this.will(7.returnValue((Object)sourceCollectionSo));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getChildrenNames(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder");
                this.will(7.returnValue((Object)new String[]{"sourceFile"}));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(7.returnValue((Object)sourceFileSo));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).removeObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).removeObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder");
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        DoMove doMove = new DoMove(resLocks, doDelete, doCopy, false);
        doMove.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testMovingOfaCollectionIfDestinationIsPresentAndOverwriteFalse() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(8.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(8.returnValue((Object)"/tmp/tests/sourceFolder"));
                ((HttpServletRequest)this.exactly(2).of((Object)DoMoveTest.this.mockReq)).getHeader("Destination");
                this.will(8.returnValue((Object)"/tmp/tests/destFolder"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getServerName();
                this.will(8.returnValue((Object)"server_name"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getContextPath();
                this.will(8.returnValue((Object)""));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(8.returnValue((Object)"/tmp/tests/destFolder"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getServletPath();
                this.will(8.returnValue((Object)"servlet_path"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(8.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(8.returnValue((Object)"/tmp/tests/sourceFolder"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getHeader("Overwrite");
                this.will(8.returnValue((Object)"F"));
                StoredObject sourceCollectionSo = DoMoveTest.this.initFolderStoredObject();
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder");
                this.will(8.returnValue((Object)sourceCollectionSo));
                StoredObject destCollectionSo = DoMoveTest.this.initFolderStoredObject();
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder");
                this.will(8.returnValue((Object)destCollectionSo));
                ((HttpServletResponse)this.oneOf(DoMoveTest.this.mockRes)).sendError(412);
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        DoMove doMove = new DoMove(resLocks, doDelete, doCopy, false);
        doMove.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testMovingOfaCollectionIfDestinationIsPresentAndOverwriteTrue() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(9.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(9.returnValue((Object)"/tmp/tests/sourceFolder"));
                ((HttpServletRequest)this.exactly(2).of((Object)DoMoveTest.this.mockReq)).getHeader("Destination");
                this.will(9.returnValue((Object)DoMoveTest.OVERWRITE_PATH));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getServerName();
                this.will(9.returnValue((Object)"server_name"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getContextPath();
                this.will(9.returnValue((Object)""));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(9.returnValue((Object)DoMoveTest.OVERWRITE_PATH));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getServletPath();
                this.will(9.returnValue((Object)"servlet_path"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(9.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getPathInfo();
                this.will(9.returnValue((Object)"/tmp/tests/sourceFolder"));
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getHeader("Overwrite");
                this.will(9.returnValue((Object)"T"));
                StoredObject sourceCollectionSo = DoMoveTest.this.initFolderStoredObject();
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder");
                this.will(9.returnValue((Object)sourceCollectionSo));
                StoredObject destCollectionSo = DoMoveTest.this.initFolderStoredObject();
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, DoMoveTest.OVERWRITE_PATH);
                this.will(9.returnValue((Object)destCollectionSo));
                ((HttpServletResponse)this.oneOf(DoMoveTest.this.mockRes)).setStatus(204);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, DoMoveTest.OVERWRITE_PATH);
                this.will(9.returnValue((Object)destCollectionSo));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getChildrenNames(DoMoveTest.this.mockTransaction, DoMoveTest.OVERWRITE_PATH);
                this.will(9.returnValue((Object)new String[]{"destFile"}));
                StoredObject destFileSo = DoMoveTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/sourceFolder/destFile");
                this.will(9.returnValue((Object)destFileSo));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).removeObject(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/sourceFolder/destFile");
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).removeObject(DoMoveTest.this.mockTransaction, DoMoveTest.OVERWRITE_PATH);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder");
                this.will(9.returnValue((Object)sourceCollectionSo));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).createFolder(DoMoveTest.this.mockTransaction, DoMoveTest.OVERWRITE_PATH);
                ((HttpServletRequest)this.oneOf(DoMoveTest.this.mockReq)).getHeader("Depth");
                this.will(9.returnValue(null));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getChildrenNames(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder");
                this.will(9.returnValue((Object)new String[]{"sourceFile"}));
                StoredObject sourceFileSo = DoMoveTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(9.returnValue((Object)sourceFileSo));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).createResource(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/sourceFolder/sourceFile");
                DelegatingServletInputStream resourceStream = DoMoveTest.this.resourceRequestStream();
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getResourceContent(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(9.returnValue((Object)resourceStream));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).setResourceContent(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/sourceFolder/sourceFile", (InputStream)resourceStream, null, null);
                StoredObject movedSo = DoMoveTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/destFolder/sourceFolder/sourceFile");
                this.will(9.returnValue((Object)movedSo));
                ((HttpServletResponse)this.oneOf(DoMoveTest.this.mockRes)).setStatus(204);
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder");
                this.will(9.returnValue((Object)sourceCollectionSo));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getChildrenNames(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder");
                this.will(9.returnValue((Object)new String[]{"sourceFile"}));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).getStoredObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(9.returnValue((Object)sourceFileSo));
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).removeObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                ((IWebdavStore)this.oneOf(DoMoveTest.this.mockStore)).removeObject(DoMoveTest.this.mockTransaction, "/tmp/tests/sourceFolder");
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        DoMove doMove = new DoMove(resLocks, doDelete, doCopy, false);
        doMove.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }
}

