/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jmock.Mockery;
import org.junit.After;
import org.junit.Before;
import org.modeshape.common.util.FileUtil;
import org.modeshape.webdav.IMimeTyper;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.locking.IResourceLocks;
import org.modeshape.webdav.locking.LockedObject;
import org.modeshape.webdav.locking.ResourceLocks;
import org.springframework.mock.web.DelegatingServletInputStream;

public abstract class AbstractWebDAVTest {
    protected static final boolean READ_ONLY = true;
    protected static final int TEMP_TIMEOUT = 10;
    protected static final boolean TEMPORARY = true;
    protected static final byte[] RESOURCE_CONTENT = new byte[]{60, 104, 101, 108, 108, 111, 47, 62};
    protected static final long RESOURCE_LENGTH = RESOURCE_CONTENT.length;
    private static final String EXCLUSIVE_LOCK_REQUEST = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:lockinfo xmlns:D='DAV:'><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype><D:owner><D:href>I'am the Lock Owner</D:href></D:owner></D:lockinfo>";
    private static final String SHARED_LOCK_REQUEST = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:lockinfo xmlns:D='DAV:'><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype><D:owner><D:href>I'am the Lock Owner</D:href></D:owner></D:lockinfo>";
    protected static final String TMP_FOLDER = "/tmp/tests";
    protected static final String SOURCE_COLLECTION_PATH = "/tmp/tests/sourceFolder";
    protected static final String DEST_COLLECTION_PATH = "/tmp/tests/destFolder";
    protected static final String SOURCE_FILE_PATH = "/tmp/tests/sourceFolder/sourceFile";
    protected static final String DEST_FILE_PATH = "/tmp/tests/destFolder/destFile";
    protected static final String OWNER = "owner";
    protected static final String INCLUDE_REQUEST_URI_ATTRIBUTE = "javax.servlet.include.request_uri";
    private static final String OUTPUT_ROOT_FOLDER = "target/modeshape-webdav";
    protected Mockery mockery;
    protected IWebdavStore mockStore;
    protected HttpServletRequest mockReq;
    protected HttpServletResponse mockRes;
    protected ITransaction mockTransaction;
    protected IMimeTyper mockMimeTyper;
    protected IResourceLocks mockResourceLocks;

    protected PrintWriter getPrintWriter() throws IOException {
        File outputRootFolder = new File(OUTPUT_ROOT_FOLDER);
        if (!outputRootFolder.exists() || !outputRootFolder.isDirectory()) {
            outputRootFolder.mkdir();
        }
        File outputFile = new File("target/modeshape-webdav/webdav_output_" + System.currentTimeMillis() + ".xml");
        outputFile.createNewFile();
        return new PrintWriter(outputFile);
    }

    protected DelegatingServletInputStream exclusiveLockRequestStream() {
        return new DelegatingServletInputStream((InputStream)new ByteArrayInputStream(EXCLUSIVE_LOCK_REQUEST.getBytes()));
    }

    protected DelegatingServletInputStream sharedLockRequestStream() {
        return new DelegatingServletInputStream((InputStream)new ByteArrayInputStream(SHARED_LOCK_REQUEST.getBytes()));
    }

    protected DelegatingServletInputStream resourceRequestStream() {
        return new DelegatingServletInputStream((InputStream)new ByteArrayInputStream(RESOURCE_CONTENT));
    }

    @Before
    public void setupMocks() {
        this.mockery = new Mockery();
        this.mockStore = (IWebdavStore)this.mockery.mock(IWebdavStore.class);
        this.mockReq = (HttpServletRequest)this.mockery.mock(HttpServletRequest.class);
        this.mockRes = (HttpServletResponse)this.mockery.mock(HttpServletResponse.class);
        this.mockTransaction = (ITransaction)this.mockery.mock(ITransaction.class);
        this.mockMimeTyper = (IMimeTyper)this.mockery.mock(IMimeTyper.class);
        this.mockResourceLocks = (IResourceLocks)this.mockery.mock(IResourceLocks.class);
    }

    @After
    public void tearDownAfterClass() {
        FileUtil.delete((String)OUTPUT_ROOT_FOLDER);
    }

    public StoredObject initFolderStoredObject() {
        return this.initStoredObject(true, null);
    }

    public StoredObject initFileStoredObject(byte[] resourceContent) {
        return this.initStoredObject(false, resourceContent);
    }

    private StoredObject initStoredObject(boolean isFolder, byte[] resourceContent) {
        StoredObject so = new StoredObject();
        so.setFolder(isFolder);
        so.setCreationDate(new Date());
        so.setLastModified(new Date());
        if (!isFolder) {
            so.setResourceLength((long)resourceContent.length);
        } else {
            so.setResourceLength(0L);
        }
        return so;
    }

    public StoredObject initLockNullStoredObject() {
        StoredObject so = new StoredObject();
        so.setNullResource(true);
        so.setFolder(false);
        so.setCreationDate(null);
        so.setLastModified(null);
        so.setResourceLength(0L);
        return so;
    }

    public LockedObject initLockNullLockedObject(ResourceLocks resLocks, String path) {
        LockedObject lo = new LockedObject(resLocks, path, false);
        lo.setExclusive(true);
        return lo;
    }
}

