/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav;

import java.security.Principal;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.webdav.AbstractWebDAVTest;
import org.modeshape.webdav.MockPrincipal;
import org.modeshape.webdav.WebdavServlet;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.mock.web.MockServletContext;

public class WebdavServletTest
extends AbstractWebDAVTest {
    private ServletConfig servletConfig;
    private ServletContext servletContext;
    private MockServletConfig mockServletConfig;
    private MockServletContext mockServletContext;
    private MockHttpSession mockHttpSession;
    private MockPrincipal mockPrincipal;
    private String dftIndexFile = "/index.html";
    private String insteadOf404 = "/insteadOf404";

    @Before
    public void setUp() throws Exception {
        this.setupMocks();
        this.servletConfig = (ServletConfig)this.mockery.mock(ServletConfig.class);
        this.servletContext = (ServletContext)this.mockery.mock(ServletContext.class);
        this.mockServletConfig = new MockServletConfig((ServletContext)this.mockServletContext);
        this.mockHttpSession = new MockHttpSession((ServletContext)this.mockServletContext);
        this.mockServletContext = new MockServletContext();
        this.mockPrincipal = new MockPrincipal("Admin", new String[]{"Admin", "Manager"});
    }

    @Test
    public void testInit() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){});
        WebdavServlet servlet = new WebdavServlet();
        servlet.init(this.mockStore, this.dftIndexFile, this.insteadOf404, 1, true);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testInitGenericServlet() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ServletConfig)this.allowing(WebdavServletTest.this.servletConfig)).getServletContext();
                this.will(2.returnValue((Object)WebdavServletTest.this.mockServletContext));
                ((ServletConfig)this.allowing(WebdavServletTest.this.servletConfig)).getServletName();
                this.will(2.returnValue((Object)"webdav-servlet"));
                ((ServletContext)this.allowing(WebdavServletTest.this.servletContext)).log("webdav-servlet: init");
                ((ServletConfig)this.oneOf(WebdavServletTest.this.servletConfig)).getInitParameter("ResourceHandlerImplementation");
                this.will(2.returnValue((Object)""));
                ((ServletConfig)this.oneOf(WebdavServletTest.this.servletConfig)).getInitParameter("rootpath");
                this.will(2.returnValue((Object)"./target/tmpTestData/"));
                ((ServletConfig)this.exactly(2).of((Object)WebdavServletTest.this.servletConfig)).getInitParameter("lazyFolderCreationOnPut");
                this.will(2.returnValue((Object)"1"));
                ((ServletConfig)this.oneOf(WebdavServletTest.this.servletConfig)).getInitParameter("default-index-file");
                this.will(2.returnValue((Object)"index.html"));
                ((ServletConfig)this.oneOf(WebdavServletTest.this.servletConfig)).getInitParameter("instead-of-404");
                this.will(2.returnValue((Object)""));
                ((ServletConfig)this.exactly(2).of((Object)WebdavServletTest.this.servletConfig)).getInitParameter("no-content-length-headers");
                this.will(2.returnValue((Object)"0"));
            }
        });
        WebdavServlet servlet = new WebdavServlet();
        servlet.init(this.servletConfig);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testService() throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest((ServletContext)this.mockServletContext);
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.mockServletConfig.addInitParameter("ResourceHandlerImplementation", "");
        this.mockServletConfig.addInitParameter("rootpath", "./target/tmpTestData");
        this.mockServletConfig.addInitParameter("lazyFolderCreationOnPut", "1");
        this.mockServletConfig.addInitParameter("default-index-file", this.dftIndexFile);
        this.mockServletConfig.addInitParameter("instead-of-404", this.insteadOf404);
        this.mockServletConfig.addInitParameter("no-content-length-headers", "0");
        mockRequest.setMethod("PUT");
        mockRequest.setAttribute("javax.servlet.include.request_uri", null);
        mockRequest.setPathInfo("/aPath/toAFile");
        mockRequest.setRequestURI("/aPath/toAFile");
        mockRequest.addHeader("Host", (Object)"www.foo.bar");
        mockRequest.addHeader("Depth", (Object)"0");
        mockRequest.addHeader("Content-Type", (Object)"text/xml");
        mockRequest.addHeader("Content-Length", (Object)"1234");
        mockRequest.addHeader("User-Agent", (Object)"...some Client with WebDAVFS...");
        mockRequest.setSession((HttpSession)this.mockHttpSession);
        this.mockPrincipal = new MockPrincipal("Admin", new String[]{"Admin", "Manager"});
        mockRequest.setUserPrincipal((Principal)this.mockPrincipal);
        mockRequest.addUserRole("Admin");
        mockRequest.addUserRole("Manager");
        mockRequest.setContent(RESOURCE_CONTENT);
        this.mockery.checking((ExpectationBuilder)new Expectations(){});
        WebdavServlet servlet = new WebdavServlet();
        servlet.init((ServletConfig)this.mockServletConfig);
        servlet.service((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        this.mockery.assertIsSatisfied();
    }
}

