/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.webdav.AbstractWebDAVTest;
import org.modeshape.webdav.IMimeTyper;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.DoGet;
import org.modeshape.webdav.methods.TestingOutputStream;
import org.springframework.mock.web.DelegatingServletInputStream;

public class DoGetTest
extends AbstractWebDAVTest {
    @Test
    public void testAccessOfaMissingPageResultsIn404() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoGetTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(1.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoGetTest.this.mockReq)).getPathInfo();
                this.will(1.returnValue((Object)"/index.html"));
                Object indexSo = null;
                ((IWebdavStore)this.exactly(2).of((Object)DoGetTest.this.mockStore)).getStoredObject(DoGetTest.this.mockTransaction, "/index.html");
                this.will(1.returnValue(indexSo));
                ((HttpServletRequest)this.oneOf(DoGetTest.this.mockReq)).getRequestURI();
                this.will(1.returnValue((Object)"/index.html"));
                ((HttpServletResponse)this.oneOf(DoGetTest.this.mockRes)).sendError(404, "/index.html");
                ((HttpServletResponse)this.oneOf(DoGetTest.this.mockRes)).setStatus(404);
            }
        });
        DoGet doGet = new DoGet(this.mockStore, null, null, new ResourceLocks(), this.mockMimeTyper, 0);
        doGet.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testAccessOfaPageResultsInPage() throws Exception {
        final TestingOutputStream testingOutputStream = new TestingOutputStream();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoGetTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(2.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoGetTest.this.mockReq)).getPathInfo();
                this.will(2.returnValue((Object)"/index.html"));
                StoredObject indexSo = DoGetTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoGetTest.this.mockStore)).getStoredObject(DoGetTest.this.mockTransaction, "/index.html");
                this.will(2.returnValue((Object)indexSo));
                ((HttpServletRequest)this.oneOf(DoGetTest.this.mockReq)).getHeader("If-None-Match");
                this.will(2.returnValue(null));
                ((HttpServletResponse)this.oneOf(DoGetTest.this.mockRes)).setDateHeader("last-modified", indexSo.getLastModified().getTime());
                ((HttpServletResponse)this.oneOf(DoGetTest.this.mockRes)).addHeader((String)this.with(2.any(String.class)), (String)this.with(2.any(String.class)));
                ((IMimeTyper)this.oneOf(DoGetTest.this.mockMimeTyper)).getMimeType(DoGetTest.this.mockTransaction, "/index.html");
                this.will(2.returnValue((Object)"text/foo"));
                ((HttpServletResponse)this.oneOf(DoGetTest.this.mockRes)).setContentType("text/foo");
                StoredObject so = DoGetTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoGetTest.this.mockStore)).getStoredObject(DoGetTest.this.mockTransaction, "/index.html");
                this.will(2.returnValue((Object)so));
                ((HttpServletResponse)this.oneOf(DoGetTest.this.mockRes)).getOutputStream();
                this.will(2.returnValue((Object)((Object)testingOutputStream)));
                ((IWebdavStore)this.oneOf(DoGetTest.this.mockStore)).getResourceContent(DoGetTest.this.mockTransaction, "/index.html");
                this.will(2.returnValue((Object)DoGetTest.this.resourceRequestStream()));
            }
        });
        DoGet doGet = new DoGet(this.mockStore, null, null, new ResourceLocks(), this.mockMimeTyper, 0);
        doGet.execute(this.mockTransaction, this.mockReq, this.mockRes);
        Assert.assertEquals((Object)"<hello/>", (Object)testingOutputStream.toString());
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testAccessOfaDirectoryResultsInRudimentaryChildList() throws Exception {
        final TestingOutputStream testingOutputStream = new TestingOutputStream();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoGetTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(3.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoGetTest.this.mockReq)).getPathInfo();
                this.will(3.returnValue((Object)"/foo/"));
                StoredObject fooSo = DoGetTest.this.initFolderStoredObject();
                StoredObject aaa = DoGetTest.this.initFolderStoredObject();
                StoredObject bbb = DoGetTest.this.initFolderStoredObject();
                ((IWebdavStore)this.oneOf(DoGetTest.this.mockStore)).getStoredObject(DoGetTest.this.mockTransaction, "/foo/");
                this.will(3.returnValue((Object)fooSo));
                ((HttpServletRequest)this.oneOf(DoGetTest.this.mockReq)).getHeader("If-None-Match");
                this.will(3.returnValue(null));
                ((IWebdavStore)this.oneOf(DoGetTest.this.mockStore)).getStoredObject(DoGetTest.this.mockTransaction, "/foo/");
                this.will(3.returnValue((Object)fooSo));
                ((HttpServletRequest)this.oneOf(DoGetTest.this.mockReq)).getLocale();
                this.will(3.returnValue((Object)Locale.GERMAN));
                ((HttpServletResponse)this.oneOf(DoGetTest.this.mockRes)).setContentType("text/html");
                ((HttpServletResponse)this.oneOf(DoGetTest.this.mockRes)).setCharacterEncoding("UTF-8");
                ((HttpServletResponse)this.oneOf(DoGetTest.this.mockRes)).getOutputStream();
                this.will(3.returnValue((Object)((Object)testingOutputStream)));
                ((IWebdavStore)this.oneOf(DoGetTest.this.mockStore)).getChildrenNames(DoGetTest.this.mockTransaction, "/foo/");
                this.will(3.returnValue((Object)new String[]{"AAA", "BBB"}));
                ((HttpServletRequest)this.exactly(2).of((Object)DoGetTest.this.mockReq)).getRequestURL();
                this.will(3.returnValue((Object)new StringBuffer("http://localhost")));
                ((IWebdavStore)this.oneOf(DoGetTest.this.mockStore)).getStoredObject(DoGetTest.this.mockTransaction, "/foo//AAA");
                this.will(3.returnValue((Object)aaa));
                ((IWebdavStore)this.oneOf(DoGetTest.this.mockStore)).getStoredObject(DoGetTest.this.mockTransaction, "/foo//BBB");
                this.will(3.returnValue((Object)bbb));
            }
        });
        DoGet doGet = new DoGet(this.mockStore, null, null, new ResourceLocks(), this.mockMimeTyper, 0);
        doGet.execute(this.mockTransaction, this.mockReq, this.mockRes);
        Assert.assertTrue((testingOutputStream.toString().length() > 0 ? 1 : 0) != 0);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testAccessOfaDirectoryResultsInRedirectIfDefaultIndexFilePresent() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoGetTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(4.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoGetTest.this.mockReq)).getPathInfo();
                this.will(4.returnValue((Object)"/foo/"));
                StoredObject fooSo = DoGetTest.this.initFolderStoredObject();
                ((IWebdavStore)this.oneOf(DoGetTest.this.mockStore)).getStoredObject(DoGetTest.this.mockTransaction, "/foo/");
                this.will(4.returnValue((Object)fooSo));
                ((HttpServletRequest)this.oneOf(DoGetTest.this.mockReq)).getRequestURI();
                this.will(4.returnValue((Object)"/foo/"));
                ((HttpServletResponse)this.oneOf(DoGetTest.this.mockRes)).encodeRedirectURL("/foo//indexFile");
                ((HttpServletResponse)this.oneOf(DoGetTest.this.mockRes)).sendRedirect("");
            }
        });
        DoGet doGet = new DoGet(this.mockStore, "/indexFile", null, new ResourceLocks(), this.mockMimeTyper, 0);
        doGet.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testAccessOfaMissingPageResultsInPossibleAlternatveTo404() throws Exception {
        final TestingOutputStream testingOutputStream = new TestingOutputStream();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoGetTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(5.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoGetTest.this.mockReq)).getPathInfo();
                this.will(5.returnValue((Object)"/index.html"));
                Object indexSo = null;
                ((IWebdavStore)this.oneOf(DoGetTest.this.mockStore)).getStoredObject(DoGetTest.this.mockTransaction, "/index.html");
                this.will(5.returnValue(indexSo));
                StoredObject alternativeSo = DoGetTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoGetTest.this.mockStore)).getStoredObject(DoGetTest.this.mockTransaction, "/alternative");
                this.will(5.returnValue((Object)alternativeSo));
                ((HttpServletRequest)this.oneOf(DoGetTest.this.mockReq)).getHeader("If-None-Match");
                this.will(5.returnValue(null));
                ((HttpServletResponse)this.oneOf(DoGetTest.this.mockRes)).setDateHeader("last-modified", alternativeSo.getLastModified().getTime());
                ((HttpServletResponse)this.oneOf(DoGetTest.this.mockRes)).addHeader((String)this.with(5.any(String.class)), (String)this.with(5.any(String.class)));
                ((IMimeTyper)this.oneOf(DoGetTest.this.mockMimeTyper)).getMimeType(DoGetTest.this.mockTransaction, "/alternative");
                this.will(5.returnValue((Object)"text/foo"));
                ((HttpServletResponse)this.oneOf(DoGetTest.this.mockRes)).setContentType("text/foo");
                ((IWebdavStore)this.oneOf(DoGetTest.this.mockStore)).getStoredObject(DoGetTest.this.mockTransaction, "/alternative");
                this.will(5.returnValue((Object)alternativeSo));
                ((HttpServletResponse)this.oneOf(DoGetTest.this.mockRes)).getOutputStream();
                this.will(5.returnValue((Object)((Object)testingOutputStream)));
                ((IWebdavStore)this.oneOf(DoGetTest.this.mockStore)).getResourceContent(DoGetTest.this.mockTransaction, "/alternative");
                DelegatingServletInputStream resourceStream = DoGetTest.this.resourceRequestStream();
                this.will(5.returnValue((Object)resourceStream));
                ((HttpServletResponse)this.oneOf(DoGetTest.this.mockRes)).setStatus(404);
            }
        });
        DoGet doGet = new DoGet(this.mockStore, null, "/alternative", new ResourceLocks(), this.mockMimeTyper, 0);
        doGet.execute(this.mockTransaction, this.mockReq, this.mockRes);
        Assert.assertEquals((Object)"<hello/>", (Object)testingOutputStream.toString());
        this.mockery.assertIsSatisfied();
    }
}

