/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.modeshape.webdav.AbstractWebDAVTest;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.DoProppatch;

public class DoProppatchTest
extends AbstractWebDAVTest {
    @Test
    public void doProppatchIfReadOnly() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletResponse)this.oneOf(DoProppatchTest.this.mockRes)).sendError(403);
            }
        });
        DoProppatch doProppatch = new DoProppatch(this.mockStore, new ResourceLocks(), true);
        doProppatch.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void doProppatchOnNonExistingResource() throws Exception {
        String path = "/notExists";
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoProppatchTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(2.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoProppatchTest.this.mockReq)).getPathInfo();
                this.will(2.returnValue((Object)"/notExists"));
                Object notExistingSo = null;
                ((IWebdavStore)this.oneOf(DoProppatchTest.this.mockStore)).getStoredObject(DoProppatchTest.this.mockTransaction, "/notExists");
                this.will(2.returnValue(notExistingSo));
                ((HttpServletResponse)this.oneOf(DoProppatchTest.this.mockRes)).sendError(404);
            }
        });
        DoProppatch doProppatch = new DoProppatch(this.mockStore, new ResourceLocks(), false);
        doProppatch.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void doProppatchOnRequestWithNoContent() throws Exception {
        String path = "/testFile";
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoProppatchTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(3.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoProppatchTest.this.mockReq)).getPathInfo();
                this.will(3.returnValue((Object)"/testFile"));
                StoredObject testFileSo = DoProppatchTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoProppatchTest.this.mockStore)).getStoredObject(DoProppatchTest.this.mockTransaction, "/testFile");
                this.will(3.returnValue((Object)testFileSo));
                ((HttpServletRequest)this.oneOf(DoProppatchTest.this.mockReq)).getHeader("If");
                this.will(3.returnValue((Object)""));
                ((HttpServletRequest)this.oneOf(DoProppatchTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(3.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoProppatchTest.this.mockReq)).getPathInfo();
                this.will(3.returnValue((Object)"/testFile"));
                ((HttpServletRequest)this.oneOf(DoProppatchTest.this.mockReq)).getContentLength();
                this.will(3.returnValue((Object)0));
                ((HttpServletResponse)this.oneOf(DoProppatchTest.this.mockRes)).sendError(500);
            }
        });
        DoProppatch doProppatch = new DoProppatch(this.mockStore, new ResourceLocks(), false);
        doProppatch.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void doProppatchOnResource() throws Exception {
        String path = "/testFile";
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoProppatchTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(4.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoProppatchTest.this.mockReq)).getPathInfo();
                this.will(4.returnValue((Object)"/testFile"));
                StoredObject testFileSo = DoProppatchTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoProppatchTest.this.mockStore)).getStoredObject(DoProppatchTest.this.mockTransaction, "/testFile");
                this.will(4.returnValue((Object)testFileSo));
                ((HttpServletRequest)this.oneOf(DoProppatchTest.this.mockReq)).getHeader("If");
                this.will(4.returnValue((Object)""));
                ((HttpServletRequest)this.oneOf(DoProppatchTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(4.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoProppatchTest.this.mockReq)).getPathInfo();
                this.will(4.returnValue((Object)"/testFile"));
                ((HttpServletRequest)this.oneOf(DoProppatchTest.this.mockReq)).getContentLength();
                this.will(4.returnValue((Object)RESOURCE_CONTENT.length));
                ((HttpServletRequest)this.oneOf(DoProppatchTest.this.mockReq)).getInputStream();
                this.will(4.returnValue((Object)DoProppatchTest.this.resourceRequestStream()));
                ((HttpServletResponse)this.oneOf(DoProppatchTest.this.mockRes)).setStatus(207);
                ((HttpServletResponse)this.oneOf(DoProppatchTest.this.mockRes)).setContentType("text/xml; charset=UTF-8");
                ((HttpServletResponse)this.oneOf(DoProppatchTest.this.mockRes)).getWriter();
                this.will(4.returnValue((Object)DoProppatchTest.this.getPrintWriter()));
                ((HttpServletRequest)this.oneOf(DoProppatchTest.this.mockReq)).getContextPath();
                this.will(4.returnValue((Object)""));
            }
        });
        DoProppatch doProppatch = new DoProppatch(this.mockStore, new ResourceLocks(), false);
        doProppatch.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }
}

