/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.modeshape.webdav.AbstractWebDAVTest;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.locking.IResourceLocks;
import org.modeshape.webdav.locking.LockedObject;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.DoLock;
import org.modeshape.webdav.methods.DoUnlock;

public class DoUnlockTest
extends AbstractWebDAVTest {
    private static final boolean EXCLUSIVE = true;

    @Test
    public void testDoUnlockIfReadOnly() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletResponse)this.oneOf(DoUnlockTest.this.mockRes)).sendError(403);
            }
        });
        DoUnlock doUnlock = new DoUnlock(this.mockStore, (IResourceLocks)new ResourceLocks(), true);
        doUnlock.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoUnlockaLockedResourceWithRightLockToken() throws Exception {
        String lockPath = "/lockedResource";
        String lockOwner = "theOwner";
        ResourceLocks resLocks = new ResourceLocks();
        resLocks.lock(this.mockTransaction, "/lockedResource", "theOwner", true, 0, 10, false);
        LockedObject lo = resLocks.getLockedObjectByPath(this.mockTransaction, "/lockedResource");
        String loID = lo.getID();
        final String lockToken = "<opaquelocktoken:".concat(loID).concat(">");
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(2.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getPathInfo();
                this.will(2.returnValue((Object)"/lockedResource"));
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getHeader("Lock-Token");
                this.will(2.returnValue((Object)lockToken));
                StoredObject lockedSo = DoUnlockTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoUnlockTest.this.mockStore)).getStoredObject(DoUnlockTest.this.mockTransaction, "/lockedResource");
                this.will(2.returnValue((Object)lockedSo));
                ((HttpServletResponse)this.oneOf(DoUnlockTest.this.mockRes)).setStatus(204);
            }
        });
        DoUnlock doUnlock = new DoUnlock(this.mockStore, (IResourceLocks)resLocks, false);
        doUnlock.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoUnlockaLockedResourceWithWrongLockToken() throws Exception {
        String lockPath = "/lockedResource";
        String lockOwner = "theOwner";
        ResourceLocks resLocks = new ResourceLocks();
        resLocks.lock(this.mockTransaction, "/lockedResource", "theOwner", true, 0, 10, false);
        LockedObject lo = resLocks.getLockedObjectByPath(this.mockTransaction, "/lockedResource");
        String loID = lo.getID();
        final String lockToken = "<opaquelocktoken:".concat(loID).concat("WRONG>");
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(3.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getPathInfo();
                this.will(3.returnValue((Object)"/lockedResource"));
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getHeader("Lock-Token");
                this.will(3.returnValue((Object)lockToken));
                ((HttpServletResponse)this.oneOf(DoUnlockTest.this.mockRes)).sendError(400);
            }
        });
        DoUnlock doUnlock = new DoUnlock(this.mockStore, (IResourceLocks)resLocks, false);
        doUnlock.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoUnlockaNotLockedResource() throws Exception {
        ResourceLocks resLocks = new ResourceLocks();
        String lockPath = "/notLockedResource";
        String lockToken = "<opaquelocktoken:xxxx-xxxx-xxxxWRONG>";
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(4.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getPathInfo();
                this.will(4.returnValue((Object)"/notLockedResource"));
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getHeader("Lock-Token");
                this.will(4.returnValue((Object)"<opaquelocktoken:xxxx-xxxx-xxxxWRONG>"));
                ((HttpServletResponse)this.oneOf(DoUnlockTest.this.mockRes)).sendError(400);
            }
        });
        DoUnlock doUnlock = new DoUnlock(this.mockStore, (IResourceLocks)resLocks, false);
        doUnlock.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoUnlockaLockNullResource() throws Exception {
        String parentPath = "/parentCollection";
        final String nullLoPath = "/parentCollection".concat("/aNullResource");
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(5.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getPathInfo();
                this.will(5.returnValue((Object)nullLoPath));
                LockedObject lockNullResourceLo = null;
                ((IResourceLocks)this.oneOf(DoUnlockTest.this.mockResourceLocks)).getLockedObjectByPath(DoUnlockTest.this.mockTransaction, nullLoPath);
                this.will(5.returnValue(lockNullResourceLo));
                Object parentLo = null;
                ((IResourceLocks)this.oneOf(DoUnlockTest.this.mockResourceLocks)).getLockedObjectByPath(DoUnlockTest.this.mockTransaction, "/parentCollection");
                this.will(5.returnValue(parentLo));
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getHeader("User-Agent");
                this.will(5.returnValue((Object)"Goliath"));
                ((IResourceLocks)this.oneOf(DoUnlockTest.this.mockResourceLocks)).lock((ITransaction)this.with(5.any(ITransaction.class)), (String)this.with(5.any(String.class)), (String)this.with(5.any(String.class)), this.with(5.any(Boolean.TYPE)), this.with(5.any(Integer.TYPE)), this.with(5.any(Integer.TYPE)), this.with(5.any(Boolean.TYPE)));
                this.will(5.returnValue((Object)true));
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getHeader("If");
                this.will(5.returnValue(null));
                StoredObject lockNullResourceSo = null;
                ((IWebdavStore)this.oneOf(DoUnlockTest.this.mockStore)).getStoredObject(DoUnlockTest.this.mockTransaction, nullLoPath);
                this.will(5.returnValue(lockNullResourceSo));
                Object parentSo = null;
                ((IWebdavStore)this.oneOf(DoUnlockTest.this.mockStore)).getStoredObject(DoUnlockTest.this.mockTransaction, "/parentCollection");
                this.will(5.returnValue(parentSo));
                ((IWebdavStore)this.oneOf(DoUnlockTest.this.mockStore)).createFolder(DoUnlockTest.this.mockTransaction, "/parentCollection");
                ((IWebdavStore)this.oneOf(DoUnlockTest.this.mockStore)).getStoredObject(DoUnlockTest.this.mockTransaction, nullLoPath);
                this.will(5.returnValue(lockNullResourceSo));
                ((IWebdavStore)this.oneOf(DoUnlockTest.this.mockStore)).createResource(DoUnlockTest.this.mockTransaction, nullLoPath);
                ((HttpServletResponse)this.oneOf(DoUnlockTest.this.mockRes)).setStatus(201);
                lockNullResourceSo = DoUnlockTest.this.initLockNullStoredObject();
                ((IWebdavStore)this.oneOf(DoUnlockTest.this.mockStore)).getStoredObject(DoUnlockTest.this.mockTransaction, nullLoPath);
                this.will(5.returnValue((Object)lockNullResourceSo));
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getInputStream();
                this.will(5.returnValue((Object)DoUnlockTest.this.exclusiveLockRequestStream()));
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getHeader("Depth");
                this.will(5.returnValue((Object)"0"));
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getHeader("Timeout");
                this.will(5.returnValue((Object)"Infinite"));
                ResourceLocks resLocks = (ResourceLocks)ResourceLocks.class.newInstance();
                ((IResourceLocks)this.oneOf(DoUnlockTest.this.mockResourceLocks)).exclusiveLock(DoUnlockTest.this.mockTransaction, nullLoPath, "I'am the Lock Owner", 0, 604800);
                this.will(5.returnValue((Object)true));
                lockNullResourceLo = DoUnlockTest.this.initLockNullLockedObject(resLocks, nullLoPath);
                ((IResourceLocks)this.oneOf(DoUnlockTest.this.mockResourceLocks)).getLockedObjectByPath(DoUnlockTest.this.mockTransaction, nullLoPath);
                this.will(5.returnValue((Object)lockNullResourceLo));
                ((HttpServletResponse)this.oneOf(DoUnlockTest.this.mockRes)).setStatus(200);
                ((HttpServletResponse)this.oneOf(DoUnlockTest.this.mockRes)).setContentType("text/xml; charset=UTF-8");
                ((HttpServletResponse)this.oneOf(DoUnlockTest.this.mockRes)).getWriter();
                this.will(5.returnValue((Object)DoUnlockTest.this.getPrintWriter()));
                String loId = null;
                if (lockNullResourceLo != null) {
                    loId = lockNullResourceLo.getID();
                }
                String lockToken = "<opaquelocktoken:" + loId + ">";
                ((HttpServletResponse)this.oneOf(DoUnlockTest.this.mockRes)).addHeader("Lock-Token", lockToken);
                ((IResourceLocks)this.oneOf(DoUnlockTest.this.mockResourceLocks)).unlockTemporaryLockedObjects((ITransaction)this.with(5.any(ITransaction.class)), (String)this.with(5.any(String.class)), (String)this.with(5.any(String.class)));
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(5.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getPathInfo();
                this.will(5.returnValue((Object)nullLoPath));
                ((IResourceLocks)this.oneOf(DoUnlockTest.this.mockResourceLocks)).lock((ITransaction)this.with(5.any(ITransaction.class)), (String)this.with(5.any(String.class)), (String)this.with(5.any(String.class)), this.with(5.any(Boolean.TYPE)), this.with(5.any(Integer.TYPE)), this.with(5.any(Integer.TYPE)), this.with(5.any(Boolean.TYPE)));
                this.will(5.returnValue((Object)true));
                ((HttpServletRequest)this.oneOf(DoUnlockTest.this.mockReq)).getHeader("Lock-Token");
                this.will(5.returnValue((Object)lockToken));
                ((IResourceLocks)this.oneOf(DoUnlockTest.this.mockResourceLocks)).getLockedObjectByID(DoUnlockTest.this.mockTransaction, loId);
                this.will(5.returnValue((Object)lockNullResourceLo));
                String[] owners = lockNullResourceLo.getOwner();
                String owner = null;
                if (owners != null) {
                    owner = owners[0];
                }
                ((IResourceLocks)this.oneOf(DoUnlockTest.this.mockResourceLocks)).unlock(DoUnlockTest.this.mockTransaction, loId, owner);
                this.will(5.returnValue((Object)true));
                ((IWebdavStore)this.oneOf(DoUnlockTest.this.mockStore)).getStoredObject(DoUnlockTest.this.mockTransaction, nullLoPath);
                this.will(5.returnValue((Object)lockNullResourceSo));
                ((IWebdavStore)this.oneOf(DoUnlockTest.this.mockStore)).removeObject(DoUnlockTest.this.mockTransaction, nullLoPath);
                ((HttpServletResponse)this.oneOf(DoUnlockTest.this.mockRes)).setStatus(204);
                ((IResourceLocks)this.oneOf(DoUnlockTest.this.mockResourceLocks)).unlockTemporaryLockedObjects((ITransaction)this.with(5.any(ITransaction.class)), (String)this.with(5.any(String.class)), (String)this.with(5.any(String.class)));
            }
        });
        DoLock doLock = new DoLock(this.mockStore, this.mockResourceLocks, false);
        doLock.execute(this.mockTransaction, this.mockReq, this.mockRes);
        DoUnlock doUnlock = new DoUnlock(this.mockStore, this.mockResourceLocks, false);
        doUnlock.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }
}

