/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav;

import java.io.File;
import java.lang.reflect.Constructor;
import javax.servlet.ServletException;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.LocalFileSystemStore;
import org.modeshape.webdav.WebDavServletBean;
import org.modeshape.webdav.exceptions.WebdavException;

public class WebdavServlet
extends WebDavServletBean {
    private static final long serialVersionUID = 1L;
    private static final String ROOTPATH_PARAMETER = "rootpath";

    public void init() throws ServletException {
        String clazzName = this.getServletConfig().getInitParameter("ResourceHandlerImplementation");
        if (clazzName == null || clazzName.equals("")) {
            clazzName = LocalFileSystemStore.class.getName();
        }
        File root = this.getFileRoot();
        IWebdavStore webdavStore = this.constructStore(clazzName, root);
        boolean lazyFolderCreationOnPut = this.getInitParameter("lazyFolderCreationOnPut") != null && this.getInitParameter("lazyFolderCreationOnPut").equals("1");
        String dftIndexFile = this.getInitParameter("default-index-file");
        String insteadOf404 = this.getInitParameter("instead-of-404");
        int noContentLengthHeader = this.getIntInitParameter("no-content-length-headers");
        super.init(webdavStore, dftIndexFile, insteadOf404, noContentLengthHeader, lazyFolderCreationOnPut);
    }

    private int getIntInitParameter(String key) {
        return this.getInitParameter(key) == null ? -1 : Integer.parseInt(this.getInitParameter(key));
    }

    protected IWebdavStore constructStore(String clazzName, File root) {
        IWebdavStore webdavStore;
        try {
            Class<?> clazz = WebdavServlet.class.getClassLoader().loadClass(clazzName);
            Constructor<?> ctor = clazz.getConstructor(File.class);
            webdavStore = (IWebdavStore)ctor.newInstance(root);
        }
        catch (Exception e) {
            throw new RuntimeException("some problem making store component", e);
        }
        return webdavStore;
    }

    private File getFileRoot() {
        String rootPath = this.getInitParameter(ROOTPATH_PARAMETER);
        if (rootPath == null) {
            throw new WebdavException("missing parameter: rootpath");
        }
        if (rootPath.equals("*WAR-FILE-ROOT*")) {
            int ix;
            String file = LocalFileSystemStore.class.getProtectionDomain().getCodeSource().getLocation().getFile().replace('\\', '/');
            if (file.charAt(0) == '/' && System.getProperty("os.name").contains("Windows")) {
                file = file.substring(1, file.length());
            }
            if ((ix = file.indexOf("/WEB-INF/")) != -1) {
                rootPath = file.substring(0, ix).replace('/', File.separatorChar);
            } else {
                throw new WebdavException("Could not determine root of war file. Can't extract from path '" + file + "' for this web container");
            }
        }
        return new File(rootPath);
    }
}

