/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.locking;

import java.util.Enumeration;
import java.util.Hashtable;
import org.modeshape.common.logging.Logger;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.exceptions.LockFailedException;
import org.modeshape.webdav.locking.IResourceLocks;
import org.modeshape.webdav.locking.LockedObject;

public class ResourceLocks
implements IResourceLocks {
    private static Logger LOG = Logger.getLogger(ResourceLocks.class);
    private final int cleanupLimit = 100000;
    protected int cleanupCounter = 0;
    protected Hashtable<String, LockedObject> locks = new Hashtable();
    protected Hashtable<String, LockedObject> locksByID = new Hashtable();
    protected Hashtable<String, LockedObject> tempLocks = new Hashtable();
    protected Hashtable<String, LockedObject> tempLocksByID = new Hashtable();
    protected LockedObject root = new LockedObject(this, "/", true);
    protected LockedObject tempRoot = new LockedObject(this, "/", false);
    private boolean temporary = true;

    @Override
    public synchronized boolean lock(ITransaction transaction, String path, String owner, boolean exclusive, int depth, int timeout, boolean temporary) throws LockFailedException {
        LockedObject lo = null;
        if (temporary) {
            lo = this.generateTempLockedObjects(path);
            lo.type = "read";
        } else {
            lo = this.generateLockedObjects(path);
            lo.type = "write";
        }
        if (lo.checkLocks(exclusive, depth)) {
            lo.exclusive = exclusive;
            lo.lockDepth = depth;
            lo.expiresAt = System.currentTimeMillis() + (long)(timeout * 1000);
            if (lo.parent != null) {
                lo.parent.expiresAt = lo.expiresAt;
                if (lo.parent.equals(this.root)) {
                    LockedObject rootLo = this.getLockedObjectByPath(transaction, this.root.getPath());
                    rootLo.expiresAt = lo.expiresAt;
                } else if (lo.parent.equals(this.tempRoot)) {
                    LockedObject tempRootLo = this.getTempLockedObjectByPath(transaction, this.tempRoot.getPath());
                    tempRootLo.expiresAt = lo.expiresAt;
                }
            }
            if (lo.addLockedObjectOwner(owner)) {
                return true;
            }
            LOG.trace("Couldn't set owner \"" + owner + "\" to resource at '" + path + "'", new Object[0]);
            return false;
        }
        LOG.trace("Lock resource at " + path + " failed because" + "\na parent or child resource is currently locked", new Object[0]);
        return false;
    }

    @Override
    public synchronized boolean unlock(ITransaction transaction, String id, String owner) {
        if (this.locksByID.containsKey(id)) {
            String path = this.locksByID.get(id).getPath();
            if (this.locks.containsKey(path)) {
                LockedObject lo = this.locks.get(path);
                lo.removeLockedObjectOwner(owner);
                if (lo.children == null && lo.owner == null) {
                    lo.removeLockedObject();
                }
            } else {
                LOG.trace("org.modeshape.web.webdav.locking.ResourceLocks.unlock(): no lock for path " + path, new Object[0]);
                return false;
            }
            if (this.cleanupCounter > 100000) {
                this.cleanupCounter = 0;
                this.cleanLockedObjects(this.root, !this.temporary);
            }
        }
        this.checkTimeouts(transaction, !this.temporary);
        return true;
    }

    @Override
    public synchronized void unlockTemporaryLockedObjects(ITransaction transaction, String path, String owner) {
        if (this.tempLocks.containsKey(path)) {
            LockedObject lo = this.tempLocks.get(path);
            lo.removeLockedObjectOwner(owner);
        } else {
            LOG.trace("org.modeshape.web.webdav.locking.ResourceLocks.unlock(): no lock for path " + path, new Object[0]);
        }
        if (this.cleanupCounter > 100000) {
            this.cleanupCounter = 0;
            this.cleanLockedObjects(this.tempRoot, this.temporary);
        }
        this.checkTimeouts(transaction, this.temporary);
    }

    @Override
    public void checkTimeouts(ITransaction transaction, boolean temporary) {
        if (!temporary) {
            Enumeration<LockedObject> lockedObjects = this.locks.elements();
            while (lockedObjects.hasMoreElements()) {
                LockedObject currentLockedObject = lockedObjects.nextElement();
                if (currentLockedObject.expiresAt >= System.currentTimeMillis()) continue;
                currentLockedObject.removeLockedObject();
            }
        } else {
            Enumeration<LockedObject> lockedObjects = this.tempLocks.elements();
            while (lockedObjects.hasMoreElements()) {
                LockedObject currentLockedObject = lockedObjects.nextElement();
                if (currentLockedObject.expiresAt >= System.currentTimeMillis()) continue;
                currentLockedObject.removeTempLockedObject();
            }
        }
    }

    @Override
    public boolean exclusiveLock(ITransaction transaction, String path, String owner, int depth, int timeout) throws LockFailedException {
        return this.lock(transaction, path, owner, true, depth, timeout, false);
    }

    @Override
    public boolean sharedLock(ITransaction transaction, String path, String owner, int depth, int timeout) throws LockFailedException {
        return this.lock(transaction, path, owner, false, depth, timeout, false);
    }

    @Override
    public LockedObject getLockedObjectByID(ITransaction transaction, String id) {
        if (this.locksByID.containsKey(id)) {
            return this.locksByID.get(id);
        }
        return null;
    }

    @Override
    public LockedObject getLockedObjectByPath(ITransaction transaction, String path) {
        if (this.locks.containsKey(path)) {
            return this.locks.get(path);
        }
        return null;
    }

    @Override
    public LockedObject getTempLockedObjectByID(ITransaction transaction, String id) {
        if (this.tempLocksByID.containsKey(id)) {
            return this.tempLocksByID.get(id);
        }
        return null;
    }

    @Override
    public LockedObject getTempLockedObjectByPath(ITransaction transaction, String path) {
        if (this.tempLocks.containsKey(path)) {
            return this.tempLocks.get(path);
        }
        return null;
    }

    private LockedObject generateLockedObjects(String path) {
        if (!this.locks.containsKey(path)) {
            LockedObject returnObject = new LockedObject(this, path, !this.temporary);
            String parentPath = this.getParentPath(path);
            if (parentPath != null) {
                LockedObject parentLockedObject = this.generateLockedObjects(parentPath);
                parentLockedObject.addChild(returnObject);
                returnObject.parent = parentLockedObject;
            }
            return returnObject;
        }
        return this.locks.get(path);
    }

    private LockedObject generateTempLockedObjects(String path) {
        if (!this.tempLocks.containsKey(path)) {
            LockedObject returnObject = new LockedObject(this, path, this.temporary);
            String parentPath = this.getParentPath(path);
            if (parentPath != null) {
                LockedObject parentLockedObject = this.generateTempLockedObjects(parentPath);
                parentLockedObject.addChild(returnObject);
                returnObject.parent = parentLockedObject;
            }
            return returnObject;
        }
        return this.tempLocks.get(path);
    }

    private boolean cleanLockedObjects(LockedObject lo, boolean temporary) {
        if (lo.children == null) {
            if (lo.owner == null) {
                if (temporary) {
                    lo.removeTempLockedObject();
                } else {
                    lo.removeLockedObject();
                }
                return true;
            }
            return false;
        }
        boolean canDelete = true;
        int limit = lo.children.length;
        for (int i = 0; i < limit; ++i) {
            if (!this.cleanLockedObjects(lo.children[i], temporary)) {
                canDelete = false;
                continue;
            }
            --i;
            --limit;
        }
        if (canDelete) {
            if (lo.owner == null) {
                if (temporary) {
                    lo.removeTempLockedObject();
                } else {
                    lo.removeLockedObject();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private String getParentPath(String path) {
        int slash = path.lastIndexOf(47);
        if (slash == -1) {
            return null;
        }
        if (slash == 0) {
            return "/";
        }
        return path.substring(0, slash);
    }
}

