/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.i18n.TextI18n;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.exceptions.LockFailedException;
import org.modeshape.webdav.locking.IResourceLocks;
import org.modeshape.webdav.locking.LockedObject;
import org.modeshape.webdav.methods.DeterminableMethod;

public class DoUnlock
extends DeterminableMethod {
    private final IWebdavStore store;
    private final IResourceLocks resourceLocks;
    private final boolean readOnly;

    public DoUnlock(IWebdavStore store, IResourceLocks resourceLocks, boolean readOnly) {
        this.store = store;
        this.resourceLocks = resourceLocks;
        this.readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        this.logger.trace("-- " + this.getClass().getName(), new Object[0]);
        if (this.readOnly) {
            resp.sendError(403);
        } else {
            String path = this.getRelativePath(req);
            String tempLockOwner = "doUnlock" + System.currentTimeMillis() + req.toString();
            try {
                if (this.resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) {
                    LockedObject lo;
                    String lockId = this.getLockIdFromLockTokenHeader(req);
                    if (lockId != null && (lo = this.resourceLocks.getLockedObjectByID(transaction, lockId)) != null) {
                        String[] owners = lo.getOwner();
                        String owner = null;
                        if (lo.isShared()) {
                            if (owners != null) {
                                for (int i = 0; i < owners.length; ++i) {
                                    lo.removeLockedObjectOwner(owners[i]);
                                }
                            }
                        } else if (owners != null) {
                            owner = owners[0];
                        }
                        if (this.resourceLocks.unlock(transaction, lockId, owner)) {
                            StoredObject so = this.store.getStoredObject(transaction, path);
                            if (so == null) {
                                resp.setStatus(404);
                            } else {
                                if (so.isNullResource()) {
                                    this.store.removeObject(transaction, path);
                                }
                                resp.setStatus(204);
                            }
                        } else {
                            this.logger.trace("DoUnlock failure at " + lo.getPath(), new Object[0]);
                            resp.sendError(420);
                        }
                    } else {
                        resp.sendError(400);
                    }
                }
            }
            catch (LockFailedException e) {
                this.logger.warn((Throwable)e, (I18nResource)new TextI18n("Cannot unlock resource"), new Object[0]);
            }
            finally {
                this.resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
            }
        }
    }
}

