/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.i18n.TextI18n;
import org.modeshape.webdav.IMimeTyper;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.DeterminableMethod;
import org.modeshape.webdav.methods.DoHead;

public class DoGet
extends DoHead {
    public DoGet(IWebdavStore store, String dftIndexFile, String insteadOf404, ResourceLocks resourceLocks, IMimeTyper mimeTyper, int contentLengthHeader) {
        super(store, dftIndexFile, insteadOf404, resourceLocks, mimeTyper, contentLengthHeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doBody(ITransaction transaction, HttpServletResponse resp, String path) {
        try {
            StoredObject so = this.store.getStoredObject(transaction, path);
            if (so == null) {
                resp.sendError(404);
                return;
            }
            if (so.isNullResource()) {
                String methodsAllowed = DeterminableMethod.determineMethodsAllowed(so);
                resp.addHeader("Allow", methodsAllowed);
                resp.sendError(405);
                return;
            }
            ServletOutputStream out = resp.getOutputStream();
            InputStream in = this.store.getResourceContent(transaction, path);
            try {
                int read = -1;
                byte[] copyBuffer = new byte[BUF_SIZE];
                while ((read = in.read(copyBuffer, 0, copyBuffer.length)) != -1) {
                    out.write(copyBuffer, 0, read);
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception e) {
                    this.logger.warn((Throwable)e, (I18nResource)new TextI18n("Closing InputStream causes Exception!"), new Object[0]);
                }
                try {
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    this.logger.warn((Throwable)e, (I18nResource)new TextI18n("Flushing OutputStream causes Exception!"), new Object[0]);
                }
            }
        }
        catch (Exception e) {
            this.logger.trace(e.toString(), new Object[0]);
        }
    }

    @Override
    protected void folderBody(ITransaction transaction, String path, HttpServletResponse resp, HttpServletRequest req) throws IOException {
        StoredObject so = this.store.getStoredObject(transaction, path);
        if (so == null) {
            resp.sendError(404, req.getRequestURI());
        } else {
            if (so.isNullResource()) {
                String methodsAllowed = DeterminableMethod.determineMethodsAllowed(so);
                resp.addHeader("Allow", methodsAllowed);
                resp.sendError(405);
                return;
            }
            if (so.isFolder()) {
                DateFormat shortDF = this.getDateTimeFormat(req.getLocale());
                resp.setContentType("text/html");
                resp.setCharacterEncoding("UTF-8");
                ServletOutputStream out = resp.getOutputStream();
                Object[] children = this.store.getChildrenNames(transaction, path);
                children = children == null ? new String[]{} : children;
                Arrays.sort(children);
                StringBuilder childrenTemp = new StringBuilder();
                childrenTemp.append("<html><head><title>Content of folder");
                childrenTemp.append(path);
                childrenTemp.append("</title><style type=\"text/css\">");
                childrenTemp.append(this.getCSS());
                childrenTemp.append("</style></head>");
                childrenTemp.append("<body>");
                childrenTemp.append(this.getHeader(transaction, path, resp, req));
                childrenTemp.append("<table>");
                childrenTemp.append("<tr><th>Name</th><th>Size</th><th>Created</th><th>Modified</th></tr>");
                childrenTemp.append("<tr>");
                childrenTemp.append("<td colspan=\"4\"><a href=\"../\">Parent</a></td></tr>");
                boolean isEven = false;
                for (Object child : children) {
                    isEven = !isEven;
                    childrenTemp.append("<tr class=\"");
                    childrenTemp.append(isEven ? "even" : "odd");
                    childrenTemp.append("\">");
                    childrenTemp.append("<td>");
                    childrenTemp.append("<a href=\"");
                    StringBuffer childURL = req.getRequestURL();
                    if (childURL.charAt(childURL.length() - 1) != '/') {
                        childURL.append("/");
                    }
                    childURL.append(URL_ENCODER.encode((String)child));
                    StoredObject obj = this.store.getStoredObject(transaction, path + "/" + (String)child);
                    if (obj == null) {
                        this.logger.error((I18nResource)new TextI18n("Should not return null for " + path + "/" + (String)child), new Object[0]);
                    }
                    if (obj != null && obj.isFolder()) {
                        childURL.append("/");
                    }
                    childrenTemp.append(childURL);
                    childrenTemp.append("\">");
                    childrenTemp.append((String)child);
                    childrenTemp.append("</a></td>");
                    if (obj != null && obj.isFolder()) {
                        childrenTemp.append("<td>Folder</td>");
                    } else {
                        childrenTemp.append("<td>");
                        if (obj != null) {
                            childrenTemp.append(obj.getResourceLength());
                        } else {
                            childrenTemp.append("Unknown");
                        }
                        childrenTemp.append(" Bytes</td>");
                    }
                    if (obj != null && obj.getCreationDate() != null) {
                        childrenTemp.append("<td>");
                        childrenTemp.append(shortDF.format(obj.getCreationDate()));
                        childrenTemp.append("</td>");
                    } else {
                        childrenTemp.append("<td></td>");
                    }
                    if (obj != null && obj.getLastModified() != null) {
                        childrenTemp.append("<td>");
                        childrenTemp.append(shortDF.format(obj.getLastModified()));
                        childrenTemp.append("</td>");
                    } else {
                        childrenTemp.append("<td></td>");
                    }
                    childrenTemp.append("</tr>");
                }
                childrenTemp.append("</table>");
                childrenTemp.append(this.getFooter(transaction, path, resp, req));
                childrenTemp.append("</body></html>");
                String response = childrenTemp.toString();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Sending response {0}", new Object[]{response});
                }
                out.write(response.getBytes("UTF-8"));
            }
        }
    }

    protected String getCSS() {
        String retVal = "body {\n    font-family: Arial, Helvetica, sans-serif;\n}\nh1 {\n    font-size: 1.5em;\n}\nth {\n    background-color: #9DACBF;\n}\ntable {\n    border-top-style: solid;\n    border-right-style: solid;\n    border-bottom-style: solid;\n    border-left-style: solid;\n}\ntd {\n    margin: 0px;\n    padding-top: 2px;\n    padding-right: 5px;\n    padding-bottom: 2px;\n    padding-left: 5px;\n}\ntr.even {\n    background-color: #CCCCCC;\n}\ntr.odd {\n    background-color: #FFFFFF;\n}\n";
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            InputStream iStream = cl.getResourceAsStream("webdav.css");
            if (iStream != null) {
                int n;
                StringBuilder out = new StringBuilder();
                byte[] b = new byte[4096];
                while ((n = iStream.read(b)) != -1) {
                    out.append(new String(b, 0, n));
                }
                retVal = out.toString();
            }
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, (I18nResource)new TextI18n("Error in reading webdav.css"), new Object[0]);
        }
        return retVal;
    }

    protected String getHeader(ITransaction transaction, String path, HttpServletResponse resp, HttpServletRequest req) {
        return "<h1>Content of folder " + path + "</h1>";
    }

    protected String getFooter(ITransaction transaction, String path, HttpServletResponse resp, HttpServletRequest req) {
        return "";
    }

    protected DateFormat getDateTimeFormat(Locale browserLocale) {
        return DateFormat.getDateTimeInstance(3, 2, browserLocale);
    }
}

