/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.exceptions.AccessDeniedException;
import org.modeshape.webdav.exceptions.LockFailedException;
import org.modeshape.webdav.exceptions.WebdavException;
import org.modeshape.webdav.locking.IResourceLocks;
import org.modeshape.webdav.locking.LockedObject;
import org.modeshape.webdav.methods.AbstractMethod;

public class DoPut
extends AbstractMethod {
    private final IWebdavStore store;
    private final IResourceLocks resourceLocks;
    private final boolean readOnly;
    private final boolean lazyFolderCreationOnPut;
    private String userAgent;

    public DoPut(IWebdavStore store, IResourceLocks resLocks, boolean readOnly, boolean lazyFolderCreationOnPut) {
        this.store = store;
        this.resourceLocks = resLocks;
        this.readOnly = readOnly;
        this.lazyFolderCreationOnPut = lazyFolderCreationOnPut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        this.logger.trace("-- " + this.getClass().getName(), new Object[0]);
        if (!this.readOnly) {
            String tempLockOwner;
            String path = this.getRelativePath(req);
            String parentPath = this.getParentPath(path);
            this.userAgent = req.getHeader("User-Agent");
            if (this.isOSXFinder() && req.getContentLength() == 0) {
                this.logger.trace("-- First of multiple OS-X Finder PUT calls at {0}", new Object[]{path});
            }
            Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
            if (!this.isOSXFinder()) {
                if (!this.isUnlocked(transaction, req, this.resourceLocks, parentPath)) {
                    this.logger.trace("-- Locked parent at {0}", new Object[]{path});
                    resp.setStatus(423);
                    return;
                }
                if (!this.isUnlocked(transaction, req, this.resourceLocks, path)) {
                    this.logger.trace("-- Locked resource at {0}", new Object[]{path});
                    resp.setStatus(423);
                    return;
                }
            }
            if (this.resourceLocks.lock(transaction, path, tempLockOwner = "doPut" + System.currentTimeMillis() + req.toString(), false, 0, 10, true)) {
                StoredObject so = null;
                try {
                    StoredObject parentSo = this.store.getStoredObject(transaction, parentPath);
                    if (parentPath != null && parentSo != null && parentSo.isResource()) {
                        resp.sendError(403);
                        return;
                    }
                    if (parentPath != null && parentSo == null && this.lazyFolderCreationOnPut) {
                        this.store.createFolder(transaction, parentPath);
                    } else if (parentPath != null && parentSo == null && !this.lazyFolderCreationOnPut) {
                        errorList.put(parentPath, 404);
                        this.sendReport(req, resp, errorList);
                        return;
                    }
                    this.logger.trace("-- Looking for the stored object at {0}", new Object[]{path});
                    so = this.store.getStoredObject(transaction, path);
                    if (so == null) {
                        this.logger.trace("-- Creating resource in the store at {0}", new Object[]{path});
                        this.store.createResource(transaction, path);
                    } else {
                        this.logger.trace("-- There is already a resource at {0}", new Object[]{path});
                        if (so.isNullResource()) {
                            LockedObject nullResourceLo = this.resourceLocks.getLockedObjectByPath(transaction, path);
                            if (nullResourceLo == null) {
                                this.logger.trace("-- Unable to obtain resource lock object at {0}", new Object[]{path});
                                resp.sendError(500);
                                return;
                            }
                            this.logger.trace("-- Found resource lock object at {0}", new Object[]{path});
                            String nullResourceLockToken = nullResourceLo.getID();
                            String[] lockTokens = this.getLockIdFromIfHeader(req);
                            String lockToken = null;
                            if (lockTokens == null) {
                                this.logger.trace("-- No lock tokens found in resource lock object at {0}", new Object[]{path});
                                resp.sendError(400);
                                return;
                            }
                            lockToken = lockTokens[0];
                            if (lockToken.equals(nullResourceLockToken)) {
                                so.setNullResource(false);
                                so.setFolder(false);
                                String[] nullResourceLockOwners = nullResourceLo.getOwner();
                                String owner = null;
                                if (nullResourceLockOwners != null) {
                                    owner = nullResourceLockOwners[0];
                                }
                                if (!this.resourceLocks.unlock(transaction, lockToken, owner)) {
                                    resp.sendError(500);
                                }
                            } else {
                                errorList.put(path, 423);
                                this.sendReport(req, resp, errorList);
                            }
                        } else {
                            this.logger.trace("-- Found a lock for the (existing) resource at {0}", new Object[]{path});
                        }
                    }
                    this.doUserAgentWorkaround(resp);
                    this.logger.trace("-- Setting resource content at {0}", new Object[]{path});
                    long resourceLength = this.store.setResourceContent(transaction, path, (InputStream)req.getInputStream(), null, null);
                    so = this.store.getStoredObject(transaction, path);
                    if (so == null) {
                        resp.setStatus(404);
                        return;
                    }
                    if (resourceLength == -1L) return;
                    so.setResourceLength(resourceLength);
                    return;
                }
                catch (AccessDeniedException e) {
                    this.logger.trace((Throwable)e, "Access denied when working with {0}", new Object[]{path});
                    resp.sendError(403);
                    return;
                }
                catch (WebdavException e) {
                    this.logger.trace((Throwable)e, "WebDAV exception when working with {0}", new Object[]{path});
                    resp.sendError(500);
                    return;
                }
                finally {
                    this.resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                }
            } else {
                this.logger.trace("Lock was not acquired when working with {0}", new Object[]{path});
                resp.sendError(500);
            }
            return;
        } else {
            this.logger.trace("Readonly={0}", new Object[]{this.readOnly});
            resp.sendError(403);
        }
    }

    private void doUserAgentWorkaround(HttpServletResponse resp) {
        if (this.isOSXFinder()) {
            this.logger.trace("DoPut.execute() : do workaround for user agent '" + this.userAgent + "'", new Object[0]);
            resp.setStatus(201);
        } else if (this.userAgent != null && this.userAgent.contains("Transmit")) {
            this.logger.trace("DoPut.execute() : do workaround for user agent '" + this.userAgent + "'", new Object[0]);
            resp.setStatus(204);
        } else {
            resp.setStatus(201);
        }
    }

    private boolean isOSXFinder() {
        return this.userAgent != null && this.userAgent.contains("WebDAVFS") && !this.userAgent.contains("Transmit");
    }
}

