/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.i18n.TextI18n;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.FileUtil;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.StringUtil;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.exceptions.WebdavException;

public class LocalFileSystemStore
implements IWebdavStore {
    private static Logger LOG = Logger.getLogger(LocalFileSystemStore.class);
    private static int BUF_SIZE = 65536;
    private File root = null;

    public LocalFileSystemStore(File root) {
        this.root = root;
    }

    @Override
    public void destroy() {
    }

    @Override
    public ITransaction begin(Principal principal) throws WebdavException {
        LOG.trace("LocalFileSystemStore.begin()", new Object[0]);
        if (!this.root.exists() && !this.root.mkdirs()) {
            throw new WebdavException("root path: " + this.root.getAbsolutePath() + " does not exist and could not be created");
        }
        return null;
    }

    @Override
    public void checkAuthentication(ITransaction transaction) throws SecurityException {
        LOG.trace("LocalFileSystemStore.checkAuthentication()", new Object[0]);
    }

    @Override
    public void commit(ITransaction transaction) throws WebdavException {
        LOG.trace("LocalFileSystemStore.commit()", new Object[0]);
    }

    @Override
    public void rollback(ITransaction transaction) throws WebdavException {
        LOG.trace("LocalFileSystemStore.rollback()", new Object[0]);
    }

    @Override
    public void createFolder(ITransaction transaction, String uri) throws WebdavException {
        LOG.trace("LocalFileSystemStore.createFolder(" + uri + ")", new Object[0]);
        File file = new File(this.root, uri);
        if (!file.mkdir()) {
            throw new WebdavException("cannot create folder: " + uri);
        }
    }

    @Override
    public void createResource(ITransaction transaction, String uri) throws WebdavException {
        LOG.trace("LocalFileSystemStore.createResource(" + uri + ")", new Object[0]);
        File file = new File(this.root, uri);
        try {
            if (!file.createNewFile()) {
                throw new WebdavException("cannot create file: " + uri);
            }
        }
        catch (IOException e) {
            LOG.error((I18nResource)new TextI18n("LocalFileSystemStore.createResource(" + uri + ") failed"), new Object[0]);
            throw new WebdavException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long setResourceContent(ITransaction transaction, String uri, InputStream is, String contentType, String characterEncoding) throws WebdavException {
        LOG.trace("LocalFileSystemStore.setResourceContent(" + uri + ")", new Object[0]);
        File file = new File(this.root, uri);
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file), BUF_SIZE);
            try {
                int read;
                byte[] copyBuffer = new byte[BUF_SIZE];
                while ((read = is.read(copyBuffer, 0, copyBuffer.length)) != -1) {
                    ((OutputStream)os).write(copyBuffer, 0, read);
                }
            }
            finally {
                try {
                    is.close();
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
        }
        catch (IOException e) {
            LOG.error((I18nResource)new TextI18n("LocalFileSystemStore.setResourceContent(" + uri + ") failed"), new Object[0]);
            throw new WebdavException(e);
        }
        long length = -1L;
        try {
            length = file.length();
        }
        catch (SecurityException e) {
            LOG.error((I18nResource)new TextI18n("LocalFileSystemStore.setResourceContent(" + uri + ") failed" + "\nCan't get file.length"), new Object[0]);
        }
        return length;
    }

    @Override
    public String[] getChildrenNames(ITransaction transaction, String uri) throws WebdavException {
        LOG.trace("LocalFileSystemStore.getChildrenNames(" + uri + ")", new Object[0]);
        File file = new File(this.root, uri);
        String[] childrenNames = null;
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            ArrayList<String> childList = new ArrayList<String>();
            String name = null;
            for (int i = 0; i < children.length; ++i) {
                name = children[i].getName();
                childList.add(name);
                LOG.trace("Child " + i + ": " + name, new Object[0]);
            }
            childrenNames = new String[childList.size()];
            childrenNames = childList.toArray(childrenNames);
        }
        return childrenNames;
    }

    @Override
    public void removeObject(ITransaction transaction, String uri) throws WebdavException {
        File file = new File(this.root, uri);
        boolean success = file.delete();
        LOG.trace("LocalFileSystemStore.removeObject(" + uri + ")=" + success, new Object[0]);
        if (!success) {
            throw new WebdavException("cannot delete object: " + uri);
        }
    }

    @Override
    public InputStream getResourceContent(ITransaction transaction, String uri) throws WebdavException {
        BufferedInputStream in;
        LOG.trace("LocalFileSystemStore.getResourceContent(" + uri + ")", new Object[0]);
        File file = new File(this.root, uri);
        try {
            in = new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            LOG.error((I18nResource)new TextI18n("LocalFileSystemStore.getResourceContent(" + uri + ") failed"), new Object[0]);
            throw new WebdavException(e);
        }
        return in;
    }

    @Override
    public long getResourceLength(ITransaction transaction, String resourceUri) throws WebdavException {
        LOG.trace("LocalFileSystemStore.getResourceLength(" + resourceUri + ")", new Object[0]);
        File file = new File(this.root, resourceUri);
        return file.length();
    }

    @Override
    public StoredObject getStoredObject(ITransaction transaction, String uri) {
        StoredObject so = null;
        File file = new File(this.root, uri);
        if (file.exists()) {
            so = new StoredObject();
            so.setFolder(file.isDirectory());
            so.setLastModified(new Date(file.lastModified()));
            so.setCreationDate(new Date(file.lastModified()));
            so.setResourceLength(this.getResourceLength(transaction, uri));
        }
        return so;
    }

    @Override
    public Map<String, String> setCustomProperties(ITransaction transaction, String resourceUri, Map<String, Object> propertiesToSet, List<String> propertiesToRemove) {
        LOG.trace("LocalFileSystemStore.setCustomProperties(" + resourceUri + ")", new Object[0]);
        File propertiesFile = this.propertiesFileForResource(resourceUri);
        try {
            if (!propertiesFile.exists() && !propertiesToSet.isEmpty()) {
                propertiesFile.createNewFile();
            }
            if (!propertiesFile.exists()) {
                return null;
            }
            Map<String, Object> updatedProperties = this.readExistingProperties(propertiesFile);
            for (String propertyToRemove : propertiesToRemove) {
                updatedProperties.remove(propertyToRemove);
            }
            updatedProperties.putAll(propertiesToSet);
            if (updatedProperties.isEmpty()) {
                FileUtil.delete((File)propertiesFile);
            } else {
                this.writeProperties(propertiesFile, updatedProperties);
            }
        }
        catch (IOException e) {
            throw new WebdavException(e);
        }
        return null;
    }

    private File propertiesFileForResource(String resourceUri) {
        File propertiesFileParent;
        File file = new File(this.root, resourceUri);
        if (!file.exists()) {
            throw new WebdavException(resourceUri + " does not represent an existing file or directory");
        }
        File file2 = propertiesFileParent = file.isFile() ? file.getParentFile() : file;
        if (!propertiesFileParent.canWrite()) {
            throw new WebdavException("Cannot write into the " + propertiesFileParent.getAbsolutePath() + " folder. Make sure that the FS permissions are correct");
        }
        String propertiesFileName = file.getName() + "_webdav.properties";
        return new File(propertiesFileParent, propertiesFileName);
    }

    private Map<String, Object> readExistingProperties(File propertiesFile) throws IOException {
        String[] keyValuePairs;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String fileContent = IoUtil.read((File)propertiesFile);
        if (StringUtil.isBlank((String)fileContent)) {
            return properties;
        }
        for (String keyValuePair : keyValuePairs = fileContent.split(";")) {
            String[] keyValue = keyValuePair.split("=");
            if (keyValue.length != 2) continue;
            properties.put(keyValue[0], this.valueFromString(keyValue[1]));
        }
        return properties;
    }

    private Object valueFromString(String value) {
        if (value.startsWith("[") && value.endsWith("]")) {
            value = value.replaceAll("\\[", "").replaceAll("\\]", "");
            ArrayList<Object> array = new ArrayList<Object>();
            for (String element : value.split(",")) {
                array.add(this.valueFromString(element));
            }
            return array;
        }
        return value;
    }

    private void writeProperties(File propertiesFile, Map<String, Object> properties) throws IOException {
        StringBuilder content = new StringBuilder();
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            content.append(entry.getKey()).append("=").append(this.valueToString(entry.getValue()));
            if (!it.hasNext()) continue;
            content.append(";");
        }
        IoUtil.write((String)content.toString(), (File)propertiesFile);
    }

    private String valueToString(Object value) {
        if (value instanceof List) {
            StringBuilder builder = new StringBuilder("[");
            Iterator it = ((List)value).iterator();
            while (it.hasNext()) {
                builder.append(this.valueToString(it.next()));
                if (!it.hasNext()) continue;
                builder.append(",");
            }
            builder.append("]");
            return builder.toString();
        }
        return value.toString();
    }

    @Override
    public Map<String, Object> getCustomProperties(ITransaction transaction, String resourceUri) {
        LOG.trace("LocalFileSystemStore.getCustomProperties(" + resourceUri + ")", new Object[0]);
        try {
            File propertiesFile = this.propertiesFileForResource(resourceUri);
            if (propertiesFile.exists() && propertiesFile.canRead()) {
                return this.readExistingProperties(propertiesFile);
            }
            return Collections.emptyMap();
        }
        catch (IOException e) {
            throw new WebdavException(e);
        }
    }

    @Override
    public Map<String, String> getCustomNamespaces(ITransaction transaction, String resourceUri) {
        return Collections.emptyMap();
    }
}

