/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.methods.AbstractMethod;

public abstract class DeterminableMethod
extends AbstractMethod {
    private static final String NULL_RESOURCE_METHODS_ALLOWED = "OPTIONS, MKCOL, PUT, PROPFIND, LOCK, UNLOCK";
    private static final String RESOURCE_METHODS_ALLOWED = "OPTIONS, GET, HEAD, POST, DELETE, TRACE, PROPPATCH, COPY, MOVE, LOCK, UNLOCK, PROPFIND";
    private static final String FOLDER_METHOD_ALLOWED = ", PUT";
    private static final String LESS_ALLOWED_METHODS = "OPTIONS, MKCOL, PUT";

    protected static String determineMethodsAllowed(StoredObject so) {
        try {
            if (so != null) {
                if (so.isNullResource()) {
                    return NULL_RESOURCE_METHODS_ALLOWED;
                }
                if (so.isFolder()) {
                    return "OPTIONS, GET, HEAD, POST, DELETE, TRACE, PROPPATCH, COPY, MOVE, LOCK, UNLOCK, PROPFIND, PUT";
                }
                return RESOURCE_METHODS_ALLOWED;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return LESS_ALLOWED_METHODS;
    }
}

