/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.exceptions.AccessDeniedException;
import org.modeshape.webdav.exceptions.LockFailedException;
import org.modeshape.webdav.exceptions.ObjectAlreadyExistsException;
import org.modeshape.webdav.exceptions.ObjectNotFoundException;
import org.modeshape.webdav.exceptions.WebdavException;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.AbstractMethod;

public class DoDelete
extends AbstractMethod {
    private final IWebdavStore store;
    private final ResourceLocks resourceLocks;
    private final boolean readOnly;

    public DoDelete(IWebdavStore store, ResourceLocks resourceLocks, boolean readOnly) {
        this.store = store;
        this.resourceLocks = resourceLocks;
        this.readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        this.logger.trace("-- " + this.getClass().getName(), new Object[0]);
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        String path = this.getRelativePath(req);
        String parentPath = this.getParentPath(this.getCleanPath(path));
        if (!this.isUnlocked(transaction, req, this.resourceLocks, parentPath)) {
            resp.setStatus(423);
            return;
        }
        if (!this.isUnlocked(transaction, req, this.resourceLocks, path)) {
            resp.setStatus(423);
            return;
        }
        String tempLockOwner = "doDelete" + System.currentTimeMillis() + req.toString();
        try {
            if (!this.resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) {
                this.logger.debug("Resource lock failed.", new Object[0]);
                resp.sendError(500);
                return;
            }
            Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
            this.deleteResource(transaction, path, errorList, req, resp);
            if (!errorList.isEmpty()) {
                this.sendReport(req, resp, errorList);
            }
        }
        catch (AccessDeniedException e) {
            this.logger.debug((Throwable)e, "Access denied for " + path, new Object[0]);
            resp.sendError(403);
        }
        catch (ObjectAlreadyExistsException e) {
            this.logger.debug((Throwable)e, "Conflict for " + path, new Object[0]);
            resp.sendError(404, req.getRequestURI());
        }
        catch (WebdavException e) {
            this.logger.debug((Throwable)e, "Error for " + path, new Object[0]);
            resp.sendError(500);
        }
        finally {
            this.resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
        }
    }

    public void deleteResource(ITransaction transaction, String path, Hashtable<String, Integer> errorList, HttpServletRequest req, HttpServletResponse resp) throws IOException, WebdavException {
        resp.setStatus(204);
        if (!this.readOnly) {
            StoredObject so = this.store.getStoredObject(transaction, path);
            if (so != null) {
                if (so.isResource()) {
                    this.store.removeObject(transaction, path);
                } else if (so.isFolder()) {
                    this.deleteFolder(transaction, path, errorList);
                    this.store.removeObject(transaction, path);
                } else {
                    resp.sendError(404);
                }
            } else {
                resp.sendError(404);
            }
        } else {
            resp.sendError(403);
        }
    }

    private void deleteFolder(ITransaction transaction, String path, Hashtable<String, Integer> errorList) throws WebdavException {
        String[] children = this.store.getChildrenNames(transaction, path);
        children = children == null ? new String[]{} : children;
        StoredObject so = null;
        for (int i = children.length - 1; i >= 0; --i) {
            children[i] = "/" + children[i];
            try {
                so = this.store.getStoredObject(transaction, path + children[i]);
                if (so == null) {
                    errorList.put(path + children[i], 404);
                    continue;
                }
                if (so.isResource()) {
                    this.store.removeObject(transaction, path + children[i]);
                    continue;
                }
                this.deleteFolder(transaction, path + children[i], errorList);
                this.store.removeObject(transaction, path + children[i]);
                continue;
            }
            catch (AccessDeniedException e) {
                errorList.put(path + children[i], 403);
                continue;
            }
            catch (ObjectNotFoundException e) {
                errorList.put(path + children[i], 404);
                continue;
            }
            catch (WebdavException e) {
                errorList.put(path + children[i], 500);
            }
        }
    }
}

