/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.i18n.TextI18n;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.exceptions.LockFailedException;
import org.modeshape.webdav.exceptions.WebdavException;
import org.modeshape.webdav.fromcatalina.XMLWriter;
import org.modeshape.webdav.locking.IResourceLocks;
import org.modeshape.webdav.locking.LockedObject;
import org.modeshape.webdav.methods.AbstractMethod;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DoLock
extends AbstractMethod {
    private final IWebdavStore store;
    private final IResourceLocks resourceLocks;
    private final boolean readOnly;
    private boolean macLockRequest = false;
    private boolean exclusive = false;
    private String type = null;
    private String lockOwner = null;
    private String path = null;
    private String parentPath = null;
    private String userAgent = null;

    public DoLock(IWebdavStore store, IResourceLocks resourceLocks, boolean readOnly) {
        this.store = store;
        this.resourceLocks = resourceLocks;
        this.readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        this.logger.trace("-- " + this.getClass().getName(), new Object[0]);
        if (this.readOnly) {
            resp.sendError(403);
        } else {
            String tempLockOwner;
            this.path = this.getRelativePath(req);
            this.parentPath = this.getParentPath(this.getCleanPath(this.path));
            if (!this.isUnlocked(transaction, req, this.resourceLocks, this.path)) {
                resp.setStatus(423);
                return;
            }
            if (!this.isUnlocked(transaction, req, this.resourceLocks, this.parentPath)) {
                resp.setStatus(423);
                return;
            }
            this.userAgent = req.getHeader("User-Agent");
            if (this.userAgent != null && this.userAgent.contains("Darwin")) {
                this.macLockRequest = true;
                String timeString = Long.toString(System.currentTimeMillis());
                this.lockOwner = this.userAgent.concat(timeString);
            }
            if (this.resourceLocks.lock(transaction, this.path, tempLockOwner = "doLock" + System.currentTimeMillis() + req.toString(), false, 0, 10, true)) {
                try {
                    if (req.getHeader("If") != null) {
                        this.doRefreshLock(transaction, req, resp);
                    } else {
                        this.doLock(transaction, req, resp);
                    }
                }
                catch (LockFailedException e) {
                    resp.sendError(423);
                    this.logger.error((Throwable)e, (I18nResource)new TextI18n("Lockfailed exception"), new Object[0]);
                }
                finally {
                    this.resourceLocks.unlockTemporaryLockedObjects(transaction, this.path, tempLockOwner);
                }
            }
        }
    }

    private void doLock(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        StoredObject so = this.store.getStoredObject(transaction, this.path);
        if (so != null) {
            this.doLocking(transaction, req, resp);
        } else {
            this.doNullResourceLock(transaction, req, resp);
        }
        so = null;
        this.exclusive = false;
        this.type = null;
        this.lockOwner = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLocking(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LockedObject lo = this.resourceLocks.getLockedObjectByPath(transaction, this.path);
        if (lo != null && lo.isExclusive()) {
            this.sendLockFailError(req, resp);
            return;
        }
        try {
            this.executeLock(transaction, req, resp);
        }
        catch (ServletException e) {
            resp.sendError(500);
            this.logger.trace(e.toString(), new Object[0]);
        }
        catch (LockFailedException e) {
            this.sendLockFailError(req, resp);
        }
        finally {
            lo = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNullResourceLock(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        StoredObject parentSo;
        StoredObject nullSo = null;
        try {
            parentSo = this.store.getStoredObject(transaction, this.parentPath);
            if (this.parentPath != null && parentSo == null) {
                this.store.createFolder(transaction, this.parentPath);
            } else if (this.parentPath != null && parentSo != null && parentSo.isResource()) {
                resp.sendError(412);
                return;
            }
            nullSo = this.store.getStoredObject(transaction, this.path);
            if (nullSo == null) {
                this.store.createResource(transaction, this.path);
                if (this.userAgent != null && this.userAgent.contains("Transmit")) {
                    this.logger.trace("DoLock.execute() : do workaround for user agent '" + this.userAgent + "'", new Object[0]);
                    resp.setStatus(204);
                } else {
                    resp.setStatus(201);
                }
            } else {
                this.sendLockFailError(req, resp);
                return;
            }
            nullSo = this.store.getStoredObject(transaction, this.path);
            if (nullSo == null) {
                resp.setStatus(404);
            } else {
                nullSo.setNullResource(true);
                this.executeLock(transaction, req, resp);
            }
        }
        catch (LockFailedException e) {
            this.sendLockFailError(req, resp);
        }
        catch (WebdavException e) {
            resp.sendError(500);
            this.logger.error((Throwable)e, (I18nResource)new TextI18n("Webdav exception"), new Object[0]);
        }
        catch (ServletException e) {
            resp.sendError(500);
            this.logger.error((Throwable)e, (I18nResource)new TextI18n("Servlet exception"), new Object[0]);
        }
        finally {
            parentSo = null;
            nullSo = null;
        }
    }

    private void doRefreshLock(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        String[] lockTokens = this.getLockIdFromIfHeader(req);
        String lockToken = null;
        if (lockTokens != null) {
            lockToken = lockTokens[0];
        }
        if (lockToken != null) {
            LockedObject refreshLo = this.resourceLocks.getLockedObjectByID(transaction, lockToken);
            if (refreshLo != null) {
                int timeout = this.getTimeout(req);
                refreshLo.refreshTimeout(timeout);
                this.generateXMLReport(resp, refreshLo);
                refreshLo = null;
            } else {
                resp.sendError(412);
            }
        } else {
            resp.sendError(412);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void executeLock(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws LockFailedException, IOException, ServletException {
        if (this.macLockRequest) {
            this.logger.trace("DoLock.execute() : do workaround for user agent '" + this.userAgent + "'", new Object[0]);
            this.doMacLockRequestWorkaround(transaction, req, resp);
            return;
        }
        if (!this.getLockInformation(req, resp)) {
            resp.setContentType("text/xml; charset=UTF-8");
            resp.sendError(400);
            return;
        }
        int depth = this.getDepth(req);
        int lockDuration = this.getTimeout(req);
        boolean lockSuccess = false;
        lockSuccess = this.exclusive ? this.resourceLocks.exclusiveLock(transaction, this.path, this.lockOwner, depth, lockDuration) : this.resourceLocks.sharedLock(transaction, this.path, this.lockOwner, depth, lockDuration);
        if (!lockSuccess) {
            this.sendLockFailError(req, resp);
            throw new LockFailedException();
        }
        LockedObject lo = this.resourceLocks.getLockedObjectByPath(transaction, this.path);
        if (lo != null) {
            this.generateXMLReport(resp, lo);
            return;
        }
        resp.sendError(500);
    }

    private boolean getLockInformation(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block25: {
            Element lockInfoNode = null;
            DocumentBuilder documentBuilder = null;
            documentBuilder = this.getDocumentBuilder();
            try {
                Document document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
                lockInfoNode = document.getDocumentElement();
                if (lockInfoNode != null) {
                    int i;
                    NodeList childList = lockInfoNode.getChildNodes();
                    Node lockScopeNode = null;
                    Node lockTypeNode = null;
                    Node lockOwnerNode = null;
                    Node currentNode = null;
                    String nodeName = null;
                    for (int i2 = 0; i2 < childList.getLength(); ++i2) {
                        currentNode = childList.item(i2);
                        if (currentNode.getNodeType() == 1 || currentNode.getNodeType() == 3) {
                            nodeName = currentNode.getNodeName();
                            if (nodeName.endsWith("locktype")) {
                                lockTypeNode = currentNode;
                            }
                            if (nodeName.endsWith("lockscope")) {
                                lockScopeNode = currentNode;
                            }
                            if (!nodeName.endsWith("owner")) continue;
                            lockOwnerNode = currentNode;
                            continue;
                        }
                        return false;
                    }
                    if (lockScopeNode != null) {
                        String scope = null;
                        childList = lockScopeNode.getChildNodes();
                        for (int i3 = 0; i3 < childList.getLength(); ++i3) {
                            currentNode = childList.item(i3);
                            if (currentNode.getNodeType() != 1) continue;
                            scope = currentNode.getNodeName();
                            if (scope.endsWith("exclusive")) {
                                this.exclusive = true;
                                continue;
                            }
                            if (!scope.equals("shared")) continue;
                            this.exclusive = false;
                        }
                        if (scope == null) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    if (lockTypeNode != null) {
                        childList = lockTypeNode.getChildNodes();
                        for (i = 0; i < childList.getLength(); ++i) {
                            currentNode = childList.item(i);
                            if (currentNode.getNodeType() != 1) continue;
                            this.type = currentNode.getNodeName();
                            if (this.type.endsWith("write")) {
                                this.type = "write";
                                continue;
                            }
                            if (!this.type.equals("read")) continue;
                            this.type = "read";
                        }
                        if (this.type == null) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    if (lockOwnerNode != null) {
                        childList = lockOwnerNode.getChildNodes();
                        block10: for (i = 0; i < childList.getLength(); ++i) {
                            currentNode = childList.item(i);
                            switch (currentNode.getNodeType()) {
                                case 1: {
                                    this.lockOwner = currentNode.getFirstChild().getNodeValue();
                                    continue block10;
                                }
                                case 3: {
                                    this.lockOwner = currentNode.getNodeValue();
                                }
                            }
                        }
                    }
                    if (this.lockOwner == null) {
                        return false;
                    }
                    break block25;
                }
                return false;
            }
            catch (DOMException e) {
                resp.sendError(500);
                this.logger.error((Throwable)e, (I18nResource)new TextI18n("DOM exception"), new Object[0]);
                return false;
            }
            catch (SAXException e) {
                resp.sendError(500);
                this.logger.error((Throwable)e, (I18nResource)new TextI18n("SAX exception"), new Object[0]);
                return false;
            }
        }
        return true;
    }

    private int getTimeout(HttpServletRequest req) {
        int lockDuration = 3600;
        String lockDurationStr = req.getHeader("Timeout");
        if (lockDurationStr == null) {
            lockDuration = 3600;
        } else {
            int commaPos = lockDurationStr.indexOf(44);
            if (commaPos != -1) {
                lockDurationStr = lockDurationStr.substring(0, commaPos);
            }
            if (lockDurationStr.startsWith("Second-")) {
                lockDuration = Integer.valueOf(lockDurationStr.substring(7));
            } else if (lockDurationStr.equalsIgnoreCase("infinity")) {
                lockDuration = 604800;
            } else {
                try {
                    lockDuration = Integer.valueOf(lockDurationStr);
                }
                catch (NumberFormatException e) {
                    lockDuration = 604800;
                }
            }
            if (lockDuration <= 0) {
                lockDuration = 3600;
            }
            if (lockDuration > 604800) {
                lockDuration = 604800;
            }
        }
        return lockDuration;
    }

    private void generateXMLReport(HttpServletResponse resp, LockedObject lockedObject) throws IOException {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("DAV:", "D");
        resp.setStatus(200);
        resp.setContentType("text/xml; charset=UTF-8");
        XMLWriter generatedXML = new XMLWriter(resp.getWriter(), namespaces);
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("DAV::prop", 0);
        generatedXML.writeElement("DAV::lockdiscovery", 0);
        generatedXML.writeElement("DAV::activelock", 0);
        generatedXML.writeElement("DAV::locktype", 0);
        generatedXML.writeProperty("DAV::" + this.type);
        generatedXML.writeElement("DAV::locktype", 1);
        generatedXML.writeElement("DAV::lockscope", 0);
        if (this.exclusive) {
            generatedXML.writeProperty("DAV::exclusive");
        } else {
            generatedXML.writeProperty("DAV::shared");
        }
        generatedXML.writeElement("DAV::lockscope", 1);
        int depth = lockedObject.getLockDepth();
        generatedXML.writeElement("DAV::depth", 0);
        if (depth == 3) {
            generatedXML.writeText("Infinity");
        } else {
            generatedXML.writeText(String.valueOf(depth));
        }
        generatedXML.writeElement("DAV::depth", 1);
        generatedXML.writeElement("DAV::owner", 0);
        generatedXML.writeElement("DAV::href", 0);
        generatedXML.writeText(this.lockOwner);
        generatedXML.writeElement("DAV::href", 1);
        generatedXML.writeElement("DAV::owner", 1);
        long timeout = lockedObject.getTimeoutMillis();
        generatedXML.writeElement("DAV::timeout", 0);
        generatedXML.writeText("Second-" + timeout / 1000L);
        generatedXML.writeElement("DAV::timeout", 1);
        String lockToken = lockedObject.getID();
        generatedXML.writeElement("DAV::locktoken", 0);
        generatedXML.writeElement("DAV::href", 0);
        generatedXML.writeText("opaquelocktoken:" + lockToken);
        generatedXML.writeElement("DAV::href", 1);
        generatedXML.writeElement("DAV::locktoken", 1);
        generatedXML.writeElement("DAV::activelock", 1);
        generatedXML.writeElement("DAV::lockdiscovery", 1);
        generatedXML.writeElement("DAV::prop", 1);
        resp.addHeader("Lock-Token", "<opaquelocktoken:" + lockToken + ">");
        generatedXML.sendData();
    }

    private void doMacLockRequestWorkaround(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws LockFailedException, IOException {
        int depth = this.getDepth(req);
        int lockDuration = this.getTimeout(req);
        if (lockDuration < 0 || lockDuration > 604800) {
            lockDuration = 3600;
        }
        boolean lockSuccess = false;
        lockSuccess = this.resourceLocks.exclusiveLock(transaction, this.path, this.lockOwner, depth, lockDuration);
        if (lockSuccess) {
            LockedObject lo = this.resourceLocks.getLockedObjectByPath(transaction, this.path);
            if (lo != null) {
                this.generateXMLReport(resp, lo);
            } else {
                resp.sendError(500);
            }
        } else {
            this.sendLockFailError(req, resp);
        }
    }

    private void sendLockFailError(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
        errorList.put(this.path, 423);
        this.sendReport(req, resp, errorList);
    }
}

