/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.i18n.TextI18n;
import org.modeshape.common.util.StringUtil;
import org.modeshape.webdav.IMimeTyper;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.WebdavStatus;
import org.modeshape.webdav.exceptions.AccessDeniedException;
import org.modeshape.webdav.exceptions.LockFailedException;
import org.modeshape.webdav.exceptions.WebdavException;
import org.modeshape.webdav.fromcatalina.RequestUtil;
import org.modeshape.webdav.fromcatalina.XMLHelper;
import org.modeshape.webdav.fromcatalina.XMLWriter;
import org.modeshape.webdav.locking.LockedObject;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.AbstractMethod;
import org.xml.sax.InputSource;

public class DoPropfind
extends AbstractMethod {
    private static final int FIND_BY_PROPERTY = 0;
    private static final int FIND_ALL_PROP = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private final IWebdavStore store;
    private final ResourceLocks resourceLocks;
    private final IMimeTyper mimeTyper;
    private int depth;

    public DoPropfind(IWebdavStore store, ResourceLocks resLocks, IMimeTyper mimeTyper) {
        this.store = store;
        this.resourceLocks = resLocks;
        this.mimeTyper = mimeTyper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        this.logger.trace("-- " + this.getClass().getName(), new Object[0]);
        path = this.getCleanPath(this.getRelativePath(req));
        tempLockOwner = "doPropfind" + System.currentTimeMillis() + req.toString();
        userAgent = req.getHeader("User-Agent");
        if (this.ignoreRequest(userAgent, path)) {
            resp.sendError(404);
            return;
        }
        this.depth = this.getDepth(req);
        if (this.resourceLocks.lock(transaction, path, tempLockOwner, false, this.depth, 10, true)) {
            so = null;
            try {
                so = this.store.getStoredObject(transaction, path);
                if (so == null) {
                    resp.setContentType("text/xml; charset=UTF-8");
                    resp.sendError(404, req.getRequestURI());
                    return;
                }
                properties = null;
                path = this.getCleanPath(this.getRelativePath(req));
                propertyFindType = 1;
                propNode = null;
                if (RequestUtil.streamNotConsumed(req)) {
                    documentBuilder = this.getDocumentBuilder();
                    try {
                        document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
                        rootElement = document.getDocumentElement();
                        propNode = XMLHelper.findSubElement(rootElement, "prop");
                        if (propNode != null) {
                            propertyFindType = 0;
                        }
                        if (XMLHelper.findSubElement(rootElement, "propname") != null) {
                            propertyFindType = 2;
                        }
                        if (XMLHelper.findSubElement(rootElement, "allprop") == null) ** GOTO lbl41
                        propertyFindType = 1;
                    }
                    catch (Exception e) {
                        resp.sendError(500);
                        this.resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                        return;
                    }
                } else {
                    propertyFindType = 1;
                }
lbl41:
                // 5 sources

                namespaces = new HashMap<String, String>();
                namespaces.put("DAV:", "D");
                namespaces.putAll(this.store.getCustomNamespaces(transaction, path));
                if (propertyFindType == 0) {
                    propertyFindType = 0;
                    properties = XMLHelper.getPropertiesFromXML(propNode);
                }
                resp.setStatus(207);
                resp.setContentType("text/xml; charset=UTF-8");
                generatedXML = new XMLWriter(resp.getWriter(), namespaces);
                generatedXML.writeXMLHeader();
                generatedXML.writeElement("DAV::multistatus", 0);
                if (this.depth == 0) {
                    this.parseProperties(transaction, req, generatedXML, path, propertyFindType, properties, this.mimeTyper.getMimeType(transaction, path));
                } else {
                    this.recursiveParseProperties(transaction, path, req, generatedXML, propertyFindType, properties, this.depth, this.mimeTyper.getMimeType(transaction, path));
                }
                generatedXML.writeElement("DAV::multistatus", 1);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Sending response: {0}", new Object[]{generatedXML.toString()});
                }
                generatedXML.sendData();
            }
            catch (AccessDeniedException e) {
                resp.sendError(403);
            }
            catch (WebdavException e) {
                this.logger.warn((Throwable)e, (I18nResource)new TextI18n("Sending internal error!"), new Object[0]);
                resp.sendError(500);
            }
            catch (ServletException e) {
                this.logger.error((Throwable)e, (I18nResource)new TextI18n("Cannot create the xml document builder"), new Object[0]);
            }
            finally {
                this.resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
            }
        } else {
            errorList = new Hashtable<String, Integer>();
            errorList.put(path, 423);
            this.sendReport(req, resp, errorList);
        }
    }

    private void recursiveParseProperties(ITransaction transaction, String currentPath, HttpServletRequest req, XMLWriter generatedXML, int propertyFindType, Vector<String> properties, int depth, String mimeType) throws WebdavException {
        this.parseProperties(transaction, req, generatedXML, currentPath, propertyFindType, properties, mimeType);
        if (depth > 0) {
            String[] names = this.store.getChildrenNames(transaction, currentPath);
            names = names == null ? new String[]{} : names;
            String newPath = null;
            for (String name : names) {
                newPath = currentPath;
                if (!newPath.endsWith("/")) {
                    newPath = newPath + "/";
                }
                newPath = newPath + name;
                this.recursiveParseProperties(transaction, newPath, req, generatedXML, propertyFindType, properties, depth - 1, mimeType);
            }
        }
    }

    private void parseProperties(ITransaction transaction, HttpServletRequest req, XMLWriter generatedXML, String path, int type, Vector<String> propertiesVector, String mimeType) throws WebdavException {
        StoredObject so = this.store.getStoredObject(transaction, path);
        if (so == null) {
            return;
        }
        boolean isFolder = so.isFolder();
        String creationdate = DoPropfind.creationDateFormat(so.getCreationDate());
        String lastModified = DoPropfind.lastModifiedDateFormat(so.getLastModified());
        String resourceLength = String.valueOf(so.getResourceLength());
        generatedXML.writeElement("DAV::response", 0);
        String status = "HTTP/1.1 200 " + WebdavStatus.getStatusText(200);
        generatedXML.writeElement("DAV::href", 0);
        String href = req.getContextPath();
        String servletPath = req.getServletPath();
        if (servletPath != null) {
            href = href.endsWith("/") && servletPath.startsWith("/") ? href + servletPath.substring(1) : href + servletPath;
        }
        href = href.endsWith("/") && path.startsWith("/") ? href + path.substring(1) : href + path;
        if (isFolder && !href.endsWith("/")) {
            href = href + "/";
        }
        generatedXML.writeText(this.rewriteUrl(href));
        generatedXML.writeElement("DAV::href", 1);
        String resourceName = path;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash != -1) {
            resourceName = resourceName.substring(lastSlash + 1);
        }
        switch (type) {
            case 1: {
                generatedXML.writeElement("DAV::propstat", 0);
                generatedXML.writeElement("DAV::prop", 0);
                this.writeCustomProperties(transaction, generatedXML, path, true, propertiesVector);
                generatedXML.writeProperty("DAV::creationdate", creationdate);
                generatedXML.writeElement("DAV::displayname", 0);
                generatedXML.writeData(resourceName);
                generatedXML.writeElement("DAV::displayname", 1);
                if (!isFolder) {
                    generatedXML.writeProperty("DAV::getlastmodified", lastModified);
                    generatedXML.writeProperty("DAV::getcontentlength", resourceLength);
                    if (mimeType != null) {
                        generatedXML.writeProperty("DAV::getcontenttype", mimeType);
                    }
                    generatedXML.writeProperty("DAV::getetag", this.getETag(so));
                    generatedXML.writeElement("DAV::resourcetype", 2);
                } else {
                    generatedXML.writeElement("DAV::resourcetype", 0);
                    generatedXML.writeElement("DAV::collection", 2);
                    generatedXML.writeElement("DAV::resourcetype", 1);
                }
                this.writeSupportedLockElements(transaction, generatedXML, path);
                this.writeLockDiscoveryElements(transaction, generatedXML, path);
                generatedXML.writeProperty("DAV::source", "");
                generatedXML.writeElement("DAV::prop", 1);
                generatedXML.writeElement("DAV::status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("DAV::status", 1);
                generatedXML.writeElement("DAV::propstat", 1);
                break;
            }
            case 2: {
                generatedXML.writeElement("DAV::propstat", 0);
                generatedXML.writeElement("DAV::prop", 0);
                this.writeCustomProperties(transaction, generatedXML, path, false, propertiesVector);
                generatedXML.writeElement("DAV::creationdate", 2);
                generatedXML.writeElement("DAV::displayname", 2);
                if (!isFolder) {
                    generatedXML.writeElement("DAV::getcontentlanguage", 2);
                    generatedXML.writeElement("DAV::getcontentlength", 2);
                    generatedXML.writeElement("DAV::getcontenttype", 2);
                    generatedXML.writeElement("DAV::getetag", 2);
                    generatedXML.writeElement("DAV::getlastmodified", 2);
                }
                generatedXML.writeElement("DAV::resourcetype", 2);
                generatedXML.writeElement("DAV::supportedlock", 2);
                generatedXML.writeElement("DAV::source", 2);
                generatedXML.writeElement("DAV::prop", 1);
                generatedXML.writeElement("DAV::status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("DAV::status", 1);
                generatedXML.writeElement("DAV::propstat", 1);
                break;
            }
            case 0: {
                Vector<String> propertiesNotFound = new Vector<String>();
                generatedXML.writeElement("DAV::propstat", 0);
                generatedXML.writeElement("DAV::prop", 0);
                this.writeCustomProperties(transaction, generatedXML, path, true, propertiesVector);
                Enumeration<String> properties = propertiesVector.elements();
                while (properties.hasMoreElements()) {
                    String property = properties.nextElement();
                    if (property.equals("DAV::creationdate")) {
                        generatedXML.writeProperty("DAV::creationdate", creationdate);
                        continue;
                    }
                    if (property.equals("DAV::displayname")) {
                        generatedXML.writeElement("DAV::displayname", 0);
                        generatedXML.writeData(resourceName);
                        generatedXML.writeElement("DAV::displayname", 1);
                        continue;
                    }
                    if (property.equals("DAV::getcontentlanguage")) {
                        if (isFolder) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeElement("DAV::getcontentlanguage", 2);
                        continue;
                    }
                    if (property.equals("DAV::getcontentlength")) {
                        if (isFolder) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty("DAV::getcontentlength", resourceLength);
                        continue;
                    }
                    if (property.equals("DAV::getcontenttype")) {
                        if (isFolder) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty("DAV::getcontenttype", mimeType);
                        continue;
                    }
                    if (property.equals("DAV::getetag")) {
                        if (isFolder || so.isNullResource()) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty("DAV::getetag", this.getETag(so));
                        continue;
                    }
                    if (property.equals("DAV::getlastmodified")) {
                        if (isFolder) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty("DAV::getlastmodified", lastModified);
                        continue;
                    }
                    if (property.equals("DAV::resourcetype")) {
                        if (isFolder) {
                            generatedXML.writeElement("DAV::resourcetype", 0);
                            generatedXML.writeElement("DAV::collection", 2);
                            generatedXML.writeElement("DAV::resourcetype", 1);
                            continue;
                        }
                        generatedXML.writeElement("DAV::resourcetype", 2);
                        continue;
                    }
                    if (property.equals("DAV::source")) {
                        generatedXML.writeProperty("DAV::source", "");
                        continue;
                    }
                    if (property.equals("DAV::supportedlock")) {
                        this.writeSupportedLockElements(transaction, generatedXML, path);
                        continue;
                    }
                    if (property.equals("DAV::lockdiscovery")) {
                        this.writeLockDiscoveryElements(transaction, generatedXML, path);
                        continue;
                    }
                    propertiesNotFound.addElement(property);
                }
                generatedXML.writeElement("DAV::prop", 1);
                generatedXML.writeElement("DAV::status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("DAV::status", 1);
                generatedXML.writeElement("DAV::propstat", 1);
                Enumeration propertiesNotFoundList = propertiesNotFound.elements();
                if (!propertiesNotFoundList.hasMoreElements()) break;
                status = "HTTP/1.1 404 " + WebdavStatus.getStatusText(404);
                generatedXML.writeElement("DAV::propstat", 0);
                generatedXML.writeElement("DAV::prop", 0);
                while (propertiesNotFoundList.hasMoreElements()) {
                    generatedXML.writeElement((String)propertiesNotFoundList.nextElement(), 2);
                }
                generatedXML.writeElement("DAV::prop", 1);
                generatedXML.writeElement("DAV::status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("DAV::status", 1);
                generatedXML.writeElement("DAV::propstat", 1);
            }
        }
        generatedXML.writeElement("DAV::response", 1);
        so = null;
    }

    private void writeSupportedLockElements(ITransaction transaction, XMLWriter generatedXML, String path) {
        LockedObject lo = this.resourceLocks.getLockedObjectByPath(transaction, path);
        generatedXML.writeElement("DAV::supportedlock", 0);
        if (lo == null) {
            generatedXML.writeElement("DAV::lockentry", 0);
            generatedXML.writeElement("DAV::lockscope", 0);
            generatedXML.writeElement("DAV::exclusive", 2);
            generatedXML.writeElement("DAV::lockscope", 1);
            generatedXML.writeElement("DAV::locktype", 0);
            generatedXML.writeElement("DAV::write", 2);
            generatedXML.writeElement("DAV::locktype", 1);
            generatedXML.writeElement("DAV::lockentry", 1);
            generatedXML.writeElement("DAV::lockentry", 0);
            generatedXML.writeElement("DAV::lockscope", 0);
            generatedXML.writeElement("DAV::shared", 2);
            generatedXML.writeElement("DAV::lockscope", 1);
            generatedXML.writeElement("DAV::locktype", 0);
            generatedXML.writeElement("DAV::write", 2);
            generatedXML.writeElement("DAV::locktype", 1);
            generatedXML.writeElement("DAV::lockentry", 1);
        } else if (lo.isShared()) {
            generatedXML.writeElement("DAV::lockentry", 0);
            generatedXML.writeElement("DAV::lockscope", 0);
            generatedXML.writeElement("DAV::shared", 2);
            generatedXML.writeElement("DAV::lockscope", 1);
            generatedXML.writeElement("DAV::locktype", 0);
            generatedXML.writeElement("DAV::" + lo.getType(), 2);
            generatedXML.writeElement("DAV::locktype", 1);
            generatedXML.writeElement("DAV::lockentry", 1);
        }
        generatedXML.writeElement("DAV::supportedlock", 1);
        lo = null;
    }

    private void writeLockDiscoveryElements(ITransaction transaction, XMLWriter generatedXML, String path) {
        LockedObject lo = this.resourceLocks.getLockedObjectByPath(transaction, path);
        if (lo != null && !lo.hasExpired()) {
            generatedXML.writeElement("DAV::lockdiscovery", 0);
            generatedXML.writeElement("DAV::activelock", 0);
            generatedXML.writeElement("DAV::locktype", 0);
            generatedXML.writeProperty("DAV::" + lo.getType());
            generatedXML.writeElement("DAV::locktype", 1);
            generatedXML.writeElement("DAV::lockscope", 0);
            if (lo.isExclusive()) {
                generatedXML.writeProperty("DAV::exclusive");
            } else {
                generatedXML.writeProperty("DAV::shared");
            }
            generatedXML.writeElement("DAV::lockscope", 1);
            generatedXML.writeElement("DAV::depth", 0);
            if (this.depth == 3) {
                generatedXML.writeText("Infinity");
            } else {
                generatedXML.writeText(String.valueOf(this.depth));
            }
            generatedXML.writeElement("DAV::depth", 1);
            String[] owners = lo.getOwner();
            if (owners != null) {
                for (int i = 0; i < owners.length; ++i) {
                    generatedXML.writeElement("DAV::owner", 0);
                    generatedXML.writeElement("DAV::href", 0);
                    generatedXML.writeText(owners[i]);
                    generatedXML.writeElement("DAV::href", 1);
                    generatedXML.writeElement("DAV::owner", 1);
                }
            } else {
                generatedXML.writeElement("DAV::owner", 2);
            }
            int timeout = (int)(lo.getTimeoutMillis() / 1000L);
            String timeoutStr = Integer.toString(timeout);
            generatedXML.writeElement("DAV::timeout", 0);
            generatedXML.writeText("Second-" + timeoutStr);
            generatedXML.writeElement("DAV::timeout", 1);
            String lockToken = lo.getID();
            generatedXML.writeElement("DAV::locktoken", 0);
            generatedXML.writeElement("DAV::href", 0);
            generatedXML.writeText("opaquelocktoken:" + lockToken);
            generatedXML.writeElement("DAV::href", 1);
            generatedXML.writeElement("DAV::locktoken", 1);
            generatedXML.writeElement("DAV::activelock", 1);
            generatedXML.writeElement("DAV::lockdiscovery", 1);
        } else {
            generatedXML.writeElement("DAV::lockdiscovery", 2);
        }
        lo = null;
    }

    private void writeCustomProperties(ITransaction transaction, XMLWriter generatedXML, String path, boolean includeValue, Vector<String> propertiesFilter) {
        Map<String, Object> customProperties = this.store.getCustomProperties(transaction, path);
        if (customProperties.isEmpty()) {
            return;
        }
        for (String propertyName : customProperties.keySet()) {
            if (propertiesFilter != null && !propertiesFilter.contains(propertyName)) continue;
            if (includeValue) {
                generatedXML.writeElement(propertyName, 0);
                String value = customProperties.get(propertyName).toString();
                generatedXML.writeData(value);
                generatedXML.writeElement(propertyName, 1);
                continue;
            }
            generatedXML.writeElement(propertyName, 2);
        }
    }

    private boolean ignoreRequest(String userAgent, String requestPath) {
        return !StringUtil.isBlank((String)userAgent) && userAgent.toLowerCase().startsWith("microsoft") && (requestPath.endsWith("desktop.ini") || requestPath.endsWith("folder.jpg") || requestPath.endsWith("folder.gif"));
    }
}

