/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ServerAddress;
import com.mongodb.TransactionOptions;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.internal.Publishers;
import com.mongodb.session.ServerSession;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.reactivestreams.Publisher;

class ClientSessionImpl
implements ClientSession {
    private final AsyncClientSession wrapped;
    private final Object originator;

    ClientSessionImpl(AsyncClientSession wrapped, Object originator) {
        this.wrapped = wrapped;
        this.originator = originator;
    }

    @Override
    public boolean hasActiveTransaction() {
        return this.wrapped.hasActiveTransaction();
    }

    @Override
    public TransactionOptions getTransactionOptions() {
        return this.wrapped.getTransactionOptions();
    }

    @Override
    public AsyncClientSession getWrapped() {
        return this.wrapped;
    }

    @Override
    public void startTransaction() {
        this.wrapped.startTransaction();
    }

    @Override
    public void startTransaction(TransactionOptions transactionOptions) {
        this.wrapped.startTransaction(transactionOptions);
    }

    @Override
    public Publisher<Void> commitTransaction() {
        return Publishers.publish(arg_0 -> ((AsyncClientSession)this.wrapped).commitTransaction(arg_0));
    }

    @Override
    public Publisher<Void> abortTransaction() {
        return Publishers.publish(arg_0 -> ((AsyncClientSession)this.wrapped).abortTransaction(arg_0));
    }

    @Override
    public boolean notifyMessageSent() {
        return this.wrapped.notifyMessageSent();
    }

    public ServerAddress getPinnedServerAddress() {
        return this.wrapped.getPinnedServerAddress();
    }

    public void setPinnedServerAddress(ServerAddress serverAddress) {
        this.wrapped.setPinnedServerAddress(serverAddress);
    }

    public BsonDocument getRecoveryToken() {
        return this.wrapped.getRecoveryToken();
    }

    public void setRecoveryToken(BsonDocument bsonDocument) {
        this.wrapped.setRecoveryToken(bsonDocument);
    }

    public ClientSessionOptions getOptions() {
        return this.wrapped.getOptions();
    }

    public boolean isCausallyConsistent() {
        return this.wrapped.isCausallyConsistent();
    }

    public Object getOriginator() {
        return this.originator;
    }

    public ServerSession getServerSession() {
        return this.wrapped.getServerSession();
    }

    public BsonTimestamp getOperationTime() {
        return this.wrapped.getOperationTime();
    }

    public void advanceOperationTime(BsonTimestamp operationTime) {
        this.wrapped.advanceOperationTime(operationTime);
    }

    public void advanceClusterTime(BsonDocument clusterTime) {
        this.wrapped.advanceClusterTime(clusterTime);
    }

    public BsonDocument getClusterTime() {
        return this.wrapped.getClusterTime();
    }

    public void close() {
        this.wrapped.close();
    }
}

