/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.Block;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.reactivestreams.client.internal.AbstractSubscription;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class SingleResultCallbackSubscription<TResult>
extends AbstractSubscription<TResult> {
    private final Block<SingleResultCallback<TResult>> block;
    private boolean completed;

    SingleResultCallbackSubscription(Block<SingleResultCallback<TResult>> block, Subscriber<? super TResult> subscriber) {
        super(subscriber);
        this.block = block;
        subscriber.onSubscribe((Subscription)this);
    }

    @Override
    void requestInitialData() {
        this.block.apply((result, t) -> {
            if (t != null) {
                this.onError(t);
            } else {
                this.addToQueue(result);
                SingleResultCallbackSubscription singleResultCallbackSubscription = this;
                synchronized (singleResultCallbackSubscription) {
                    this.completed = true;
                }
                this.tryProcessResultsQueue();
            }
        });
    }

    @Override
    boolean checkCompleted() {
        return this.completed;
    }
}

