/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jackson.dataformat;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.JsonEOFException;
import com.fasterxml.jackson.core.json.DupDetector;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.msgpack.core.ExtensionTypeHeader;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.ArrayBufferInput;
import org.msgpack.core.buffer.InputStreamBufferInput;
import org.msgpack.core.buffer.MessageBufferInput;
import org.msgpack.jackson.dataformat.ExtensionTypeCustomDeserializers;
import org.msgpack.jackson.dataformat.JavaInfo;
import org.msgpack.jackson.dataformat.MessagePackExtensionType;
import org.msgpack.jackson.dataformat.MessagePackReadContext;
import org.msgpack.jackson.dataformat.Tuple;
import org.msgpack.value.ValueType;

public class MessagePackParser
extends ParserMinimalBase {
    private static final ThreadLocal<Tuple<Object, MessageUnpacker>> messageUnpackerHolder = new ThreadLocal();
    private final MessageUnpacker messageUnpacker;
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private ObjectCodec codec;
    private MessagePackReadContext streamReadContext;
    private boolean isClosed;
    private long tokenPosition;
    private long currentPosition;
    private final IOContext ioContext;
    private ExtensionTypeCustomDeserializers extTypeCustomDesers;
    private final byte[] tempBytes = new byte[64];
    private final char[] tempChars = new char[64];
    private Type type;
    private int intValue;
    private long longValue;
    private double doubleValue;
    private byte[] bytesValue;
    private String stringValue;
    private BigInteger biValue;
    private MessagePackExtensionType extensionTypeValue;

    public MessagePackParser(IOContext iOContext, int n, ObjectCodec objectCodec, InputStream inputStream, boolean bl) throws IOException {
        this(iOContext, n, (MessageBufferInput)new InputStreamBufferInput(inputStream), objectCodec, inputStream, bl);
    }

    public MessagePackParser(IOContext iOContext, int n, ObjectCodec objectCodec, byte[] byArray, boolean bl) throws IOException {
        this(iOContext, n, (MessageBufferInput)new ArrayBufferInput(byArray), objectCodec, byArray, bl);
    }

    private MessagePackParser(IOContext iOContext, int n, MessageBufferInput messageBufferInput, ObjectCodec objectCodec, Object object, boolean bl) throws IOException {
        super(n);
        this.codec = objectCodec;
        this.ioContext = iOContext;
        DupDetector dupDetector = JsonParser.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n) ? DupDetector.rootDetector((JsonParser)this) : null;
        this.streamReadContext = MessagePackReadContext.createRootContext(dupDetector);
        if (!bl) {
            this.messageUnpacker = MessagePack.newDefaultUnpacker((MessageBufferInput)messageBufferInput);
            return;
        }
        Tuple<Object, MessageUnpacker> tuple = messageUnpackerHolder.get();
        if (tuple == null) {
            this.messageUnpacker = MessagePack.newDefaultUnpacker((MessageBufferInput)messageBufferInput);
        } else {
            if (this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE) || tuple.first() != object) {
                tuple.second().reset(messageBufferInput);
            }
            this.messageUnpacker = tuple.second();
        }
        messageUnpackerHolder.set(new Tuple<Object, MessageUnpacker>(object, this.messageUnpacker));
    }

    public void setExtensionTypeCustomDeserializers(ExtensionTypeCustomDeserializers extensionTypeCustomDeserializers) {
        this.extTypeCustomDesers = extensionTypeCustomDeserializers;
    }

    public ObjectCodec getCodec() {
        return this.codec;
    }

    public void setCodec(ObjectCodec objectCodec) {
        this.codec = objectCodec;
    }

    public Version version() {
        return null;
    }

    private String unpackString(MessageUnpacker messageUnpacker) throws IOException {
        int n = messageUnpacker.unpackRawStringHeader();
        if (n <= this.tempBytes.length) {
            messageUnpacker.readPayload(this.tempBytes, 0, n);
            if (JavaInfo.STRING_VALUE_FIELD_IS_CHARS.get().booleanValue()) {
                for (int i = 0; i < n; ++i) {
                    byte by = this.tempBytes[i];
                    if ((0x80 & by) != 0) {
                        return new String(this.tempBytes, 0, n, StandardCharsets.UTF_8);
                    }
                    this.tempChars[i] = (char)by;
                }
                return new String(this.tempChars, 0, n);
            }
            return new String(this.tempBytes, 0, n);
        }
        byte[] byArray = messageUnpacker.readPayload(n);
        return new String(byArray, 0, n, StandardCharsets.UTF_8);
    }

    public JsonToken nextToken() throws IOException {
        JsonToken jsonToken;
        boolean bl;
        this.tokenPosition = this.messageUnpacker.getTotalReadBytes();
        boolean bl2 = bl = this.streamReadContext.inObject() && this._currToken != JsonToken.FIELD_NAME;
        if (bl) {
            if (!this.streamReadContext.expectMoreValues()) {
                this.streamReadContext = this.streamReadContext.getParent();
                return this._updateToken(JsonToken.END_OBJECT);
            }
        } else if (this.streamReadContext.inArray() && !this.streamReadContext.expectMoreValues()) {
            this.streamReadContext = this.streamReadContext.getParent();
            return this._updateToken(JsonToken.END_ARRAY);
        }
        if (!this.messageUnpacker.hasNext()) {
            throw new JsonEOFException((JsonParser)this, null, "Unexpected EOF");
        }
        MessageFormat messageFormat = this.messageUnpacker.getNextFormat();
        ValueType valueType = messageFormat.getValueType();
        switch (valueType) {
            case STRING: {
                this.type = Type.STRING;
                this.stringValue = this.unpackString(this.messageUnpacker);
                if (bl) {
                    this.streamReadContext.setCurrentName(this.stringValue);
                    jsonToken = JsonToken.FIELD_NAME;
                    break;
                }
                jsonToken = JsonToken.VALUE_STRING;
                break;
            }
            case INTEGER: {
                Number number;
                switch (messageFormat) {
                    case UINT64: {
                        BigInteger bigInteger = this.messageUnpacker.unpackBigInteger();
                        if (0 <= bigInteger.compareTo(LONG_MIN) && bigInteger.compareTo(LONG_MAX) <= 0) {
                            this.type = Type.LONG;
                            this.longValue = bigInteger.longValue();
                            number = this.longValue;
                            break;
                        }
                        this.type = Type.BIG_INT;
                        number = this.biValue = bigInteger;
                        break;
                    }
                    default: {
                        long l = this.messageUnpacker.unpackLong();
                        if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
                            this.type = Type.INT;
                            this.intValue = (int)l;
                            number = this.intValue;
                            break;
                        }
                        this.type = Type.LONG;
                        this.longValue = l;
                        number = this.longValue;
                    }
                }
                if (bl) {
                    this.streamReadContext.setCurrentName(String.valueOf(number));
                    jsonToken = JsonToken.FIELD_NAME;
                    break;
                }
                jsonToken = JsonToken.VALUE_NUMBER_INT;
                break;
            }
            case NIL: {
                this.messageUnpacker.unpackNil();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case BOOLEAN: {
                boolean bl3 = this.messageUnpacker.unpackBoolean();
                if (bl) {
                    this.streamReadContext.setCurrentName(Boolean.toString(bl3));
                    jsonToken = JsonToken.FIELD_NAME;
                    break;
                }
                jsonToken = bl3 ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
                break;
            }
            case FLOAT: {
                this.type = Type.DOUBLE;
                this.doubleValue = this.messageUnpacker.unpackDouble();
                if (bl) {
                    this.streamReadContext.setCurrentName(String.valueOf(this.doubleValue));
                    jsonToken = JsonToken.FIELD_NAME;
                    break;
                }
                jsonToken = JsonToken.VALUE_NUMBER_FLOAT;
                break;
            }
            case BINARY: {
                this.type = Type.BYTES;
                int n = this.messageUnpacker.unpackBinaryHeader();
                this.bytesValue = this.messageUnpacker.readPayload(n);
                if (bl) {
                    this.streamReadContext.setCurrentName(new String(this.bytesValue, MessagePack.UTF8));
                    jsonToken = JsonToken.FIELD_NAME;
                    break;
                }
                jsonToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                break;
            }
            case ARRAY: {
                jsonToken = JsonToken.START_ARRAY;
                this.streamReadContext = this.streamReadContext.createChildArrayContext(this.messageUnpacker.unpackArrayHeader());
                break;
            }
            case MAP: {
                jsonToken = JsonToken.START_OBJECT;
                this.streamReadContext = this.streamReadContext.createChildObjectContext(this.messageUnpacker.unpackMapHeader());
                break;
            }
            case EXTENSION: {
                this.type = Type.EXT;
                ExtensionTypeHeader extensionTypeHeader = this.messageUnpacker.unpackExtensionTypeHeader();
                this.extensionTypeValue = new MessagePackExtensionType(extensionTypeHeader.getType(), this.messageUnpacker.readPayload(extensionTypeHeader.getLength()));
                if (bl) {
                    this.streamReadContext.setCurrentName(this.deserializedExtensionTypeValue().toString());
                    jsonToken = JsonToken.FIELD_NAME;
                    break;
                }
                jsonToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                break;
            }
            default: {
                throw new IllegalStateException("Shouldn't reach here");
            }
        }
        this.currentPosition = this.messageUnpacker.getTotalReadBytes();
        this._updateToken(jsonToken);
        return jsonToken;
    }

    protected void _handleEOF() {
    }

    public String getText() throws IOException {
        switch (this.type) {
            case STRING: {
                return this.stringValue;
            }
            case BYTES: {
                return new String(this.bytesValue, MessagePack.UTF8);
            }
            case INT: {
                return String.valueOf(this.intValue);
            }
            case LONG: {
                return String.valueOf(this.longValue);
            }
            case DOUBLE: {
                return String.valueOf(this.doubleValue);
            }
            case BIG_INT: {
                return String.valueOf(this.biValue);
            }
            case EXT: {
                return this.deserializedExtensionTypeValue().toString();
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    public char[] getTextCharacters() throws IOException {
        return this.getText().toCharArray();
    }

    public boolean hasTextCharacters() {
        return false;
    }

    public int getTextLength() throws IOException {
        return this.getText().length();
    }

    public int getTextOffset() {
        return 0;
    }

    public byte[] getBinaryValue(Base64Variant base64Variant) {
        switch (this.type) {
            case BYTES: {
                return this.bytesValue;
            }
            case STRING: {
                return this.stringValue.getBytes(MessagePack.UTF8);
            }
            case EXT: {
                return this.extensionTypeValue.getData();
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    public Number getNumberValue() {
        switch (this.type) {
            case INT: {
                return this.intValue;
            }
            case LONG: {
                return this.longValue;
            }
            case DOUBLE: {
                return this.doubleValue;
            }
            case BIG_INT: {
                return this.biValue;
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    public int getIntValue() {
        switch (this.type) {
            case INT: {
                return this.intValue;
            }
            case LONG: {
                return (int)this.longValue;
            }
            case DOUBLE: {
                return (int)this.doubleValue;
            }
            case BIG_INT: {
                return this.biValue.intValue();
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    public long getLongValue() {
        switch (this.type) {
            case INT: {
                return this.intValue;
            }
            case LONG: {
                return this.longValue;
            }
            case DOUBLE: {
                return (long)this.doubleValue;
            }
            case BIG_INT: {
                return this.biValue.longValue();
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    public BigInteger getBigIntegerValue() {
        switch (this.type) {
            case INT: {
                return BigInteger.valueOf(this.intValue);
            }
            case LONG: {
                return BigInteger.valueOf(this.longValue);
            }
            case DOUBLE: {
                return BigInteger.valueOf((long)this.doubleValue);
            }
            case BIG_INT: {
                return this.biValue;
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    public float getFloatValue() {
        switch (this.type) {
            case INT: {
                return this.intValue;
            }
            case LONG: {
                return this.longValue;
            }
            case DOUBLE: {
                return (float)this.doubleValue;
            }
            case BIG_INT: {
                return this.biValue.floatValue();
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    public double getDoubleValue() {
        switch (this.type) {
            case INT: {
                return this.intValue;
            }
            case LONG: {
                return this.longValue;
            }
            case DOUBLE: {
                return this.doubleValue;
            }
            case BIG_INT: {
                return this.biValue.doubleValue();
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    public BigDecimal getDecimalValue() {
        switch (this.type) {
            case INT: {
                return BigDecimal.valueOf(this.intValue);
            }
            case LONG: {
                return BigDecimal.valueOf(this.longValue);
            }
            case DOUBLE: {
                return BigDecimal.valueOf(this.doubleValue);
            }
            case BIG_INT: {
                return new BigDecimal(this.biValue);
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    private Object deserializedExtensionTypeValue() throws IOException {
        ExtensionTypeCustomDeserializers.Deser deser;
        if (this.extTypeCustomDesers != null && (deser = this.extTypeCustomDesers.getDeser(this.extensionTypeValue.getType())) != null) {
            return deser.deserialize(this.extensionTypeValue.getData());
        }
        return this.extensionTypeValue;
    }

    public Object getEmbeddedObject() throws IOException {
        switch (this.type) {
            case BYTES: {
                return this.bytesValue;
            }
            case EXT: {
                return this.deserializedExtensionTypeValue();
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    public JsonParser.NumberType getNumberType() {
        switch (this.type) {
            case INT: {
                return JsonParser.NumberType.INT;
            }
            case LONG: {
                return JsonParser.NumberType.LONG;
            }
            case DOUBLE: {
                return JsonParser.NumberType.DOUBLE;
            }
            case BIG_INT: {
                return JsonParser.NumberType.BIG_INTEGER;
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    public void close() throws IOException {
        try {
            if (this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this.messageUnpacker.close();
            }
        }
        finally {
            this.isClosed = true;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public JsonStreamContext getParsingContext() {
        return this.streamReadContext;
    }

    public JsonLocation getTokenLocation() {
        return new JsonLocation(this.ioContext.getSourceReference(), this.tokenPosition, -1L, -1, (int)this.tokenPosition);
    }

    public JsonLocation getCurrentLocation() {
        return new JsonLocation(this.ioContext.getSourceReference(), this.currentPosition, -1L, -1, (int)this.currentPosition);
    }

    public void overrideCurrentName(String string) {
        MessagePackReadContext messagePackReadContext = this.streamReadContext;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            messagePackReadContext = messagePackReadContext.getParent();
        }
        try {
            messagePackReadContext.setCurrentName(string);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public String currentName() {
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            MessagePackReadContext messagePackReadContext = this.streamReadContext.getParent();
            return messagePackReadContext.getCurrentName();
        }
        return this.streamReadContext.getCurrentName();
    }

    public String getCurrentName() throws IOException {
        return this.currentName();
    }

    private static enum Type {
        INT,
        LONG,
        DOUBLE,
        STRING,
        BYTES,
        BIG_INT,
        EXT;

    }
}

