/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.concurrent.Immutable;
import org.mutabilitydetector.AnalysisError;
import org.mutabilitydetector.IsImmutable;
import org.mutabilitydetector.MutableReasonDetail;
import org.mutabilitydetector.internal.com.google.common.base.MoreObjects;
import org.mutabilitydetector.internal.com.google.common.base.Objects;
import org.mutabilitydetector.locations.Dotted;

@Immutable
public final class AnalysisResult {
    public final Dotted className;
    public final IsImmutable isImmutable;
    public final Collection<MutableReasonDetail> reasons;
    public final Collection<AnalysisError> errors;
    private final int hashCode;
    @Deprecated
    public final String dottedClassName;

    private AnalysisResult(Dotted className, IsImmutable isImmutable, Collection<MutableReasonDetail> reasons, Collection<AnalysisError> errors) {
        this.className = className;
        this.dottedClassName = className.asString();
        this.isImmutable = isImmutable;
        this.reasons = Collections.unmodifiableList(new ArrayList<MutableReasonDetail>(reasons));
        this.errors = Collections.unmodifiableList(new ArrayList<AnalysisError>(errors));
        this.hashCode = Objects.hashCode(new Object[]{className, isImmutable, reasons, errors});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("class", this.className).add("isImmutable", (Object)this.isImmutable).add("reasons", this.reasons).add("errors", this.errors).toString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalysisResult other = (AnalysisResult)obj;
        return this.className.equals(other.className) && this.isImmutable.equals((Object)other.isImmutable) && this.reasons.equals(other.reasons) && this.errors.equals(other.errors);
    }

    private static void check(IsImmutable isImmutable, Collection<MutableReasonDetail> reasons) {
        if (isImmutable != IsImmutable.IMMUTABLE && reasons.isEmpty()) {
            throw new IllegalArgumentException("Reasons must be given when a class is not " + (Object)((Object)IsImmutable.IMMUTABLE));
        }
    }

    public static AnalysisResult analysisResult(Dotted className, IsImmutable isImmutable, MutableReasonDetail ... reasons) {
        return AnalysisResult.analysisResult(className, isImmutable, Arrays.asList(reasons));
    }

    public static AnalysisResult analysisResult(Dotted className, IsImmutable isImmutable, Collection<MutableReasonDetail> reasons) {
        AnalysisResult.check(isImmutable, reasons);
        return new AnalysisResult(className, isImmutable, reasons, Collections.emptyList());
    }

    public static AnalysisResult analysisResult(Dotted className, IsImmutable isImmutable, Collection<MutableReasonDetail> reasons, Collection<AnalysisError> errors) {
        return new AnalysisResult(className, isImmutable, reasons, errors);
    }

    public static AnalysisResult definitelyImmutable(Dotted className) {
        return AnalysisResult.analysisResult(className, IsImmutable.IMMUTABLE, new MutableReasonDetail[0]);
    }

    public static AnalysisResult definitelyImmutable(String dottedClassName) {
        return AnalysisResult.definitelyImmutable(Dotted.dotted(dottedClassName));
    }

    public static AnalysisResult analysisResult(String dottedClassName, IsImmutable isImmutable) {
        return AnalysisResult.analysisResult(Dotted.dotted(dottedClassName), isImmutable, new MutableReasonDetail[0]);
    }

    public static AnalysisResult analysisResult(String dottedClassName, IsImmutable isImmutable, Collection<MutableReasonDetail> mutableReasonDetails) {
        return AnalysisResult.analysisResult(Dotted.dotted(dottedClassName), isImmutable, mutableReasonDetails);
    }

    public static AnalysisResult analysisResult(String className, IsImmutable isImmutable, MutableReasonDetail ... reasons) {
        return AnalysisResult.analysisResult(className, isImmutable, Arrays.asList(reasons));
    }

    public static AnalysisResult analysisResult(String dottedClassName, IsImmutable isImmutable, MutableReasonDetail reason) {
        return AnalysisResult.analysisResult(dottedClassName, isImmutable, Arrays.asList(reason));
    }
}

