/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.asm.typehierarchy;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mutabilitydetector.asm.typehierarchy.TypeHierarchy;
import org.mutabilitydetector.asm.typehierarchy.TypeHierarchyReader;
import org.mutabilitydetector.internal.org.objectweb.asm.Type;

public class IsAssignableFromCachingTypeHierarchyReader
extends TypeHierarchyReader {
    private final ConcurrentMap<TypeAssignability, Boolean> isAssignableFromCache;
    private final TypeHierarchyReader baseReader;

    public IsAssignableFromCachingTypeHierarchyReader(TypeHierarchyReader baseReader) {
        this.baseReader = baseReader;
        this.isAssignableFromCache = new ConcurrentHashMap<TypeAssignability, Boolean>();
    }

    @Override
    public TypeHierarchy hierarchyOf(Type t) {
        return this.baseReader.hierarchyOf(t);
    }

    @Override
    public Type getSuperClass(Type t) {
        return this.baseReader.getSuperClass(t);
    }

    @Override
    public boolean isInterface(Type t) {
        return this.baseReader.isInterface(t);
    }

    @Override
    public boolean isAssignableFrom(Type t, Type u) {
        TypeAssignability assignability = new TypeAssignability(t, u);
        if (!this.isAssignableFromCache.containsKey(assignability)) {
            this.isAssignableFromCache.put(assignability, this.baseReader.isAssignableFrom(t, u));
        }
        return (Boolean)this.isAssignableFromCache.get(assignability);
    }

    private static class TypeAssignability {
        private final Type toType;
        private final Type fromType;
        private final int hashCode;

        TypeAssignability(Type toType, Type fromType) {
            this.toType = toType;
            this.fromType = fromType;
            this.hashCode = this.calculateHashCode();
        }

        private int calculateHashCode() {
            int result = this.toType.hashCode();
            result = 31 * result + this.fromType.hashCode();
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeAssignability other = (TypeAssignability)obj;
            return this.toType.equals(other.toType) && this.fromType.equals(other.fromType);
        }
    }
}

