/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.asmoverride;

import java.io.IOException;
import org.mutabilitydetector.asm.tree.analysis.NonClassloadingSimpleVerifier;
import org.mutabilitydetector.asm.typehierarchy.ConcurrentMapCachingTypeHierarchyReader;
import org.mutabilitydetector.asm.typehierarchy.IsAssignableFromCachingTypeHierarchyReader;
import org.mutabilitydetector.asm.typehierarchy.TypeHierarchyReader;
import org.mutabilitydetector.asmoverride.AsmVerifierFactory;
import org.mutabilitydetector.internal.com.google.classpath.ClassPath;
import org.mutabilitydetector.internal.org.objectweb.asm.ClassReader;
import org.mutabilitydetector.internal.org.objectweb.asm.Type;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.analysis.BasicValue;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.analysis.Interpreter;
import org.mutabilitydetector.locations.Dotted;

public class NonClassLoadingVerifierFactory
implements AsmVerifierFactory {
    private final FromConfiguredClassPathTypeHierarchyReader typeHierarchyReader;

    public NonClassLoadingVerifierFactory(ClassPath classPath) {
        this.typeHierarchyReader = new FromConfiguredClassPathTypeHierarchyReader(classPath);
    }

    @Override
    public Interpreter<BasicValue> interpreter() {
        return new NonClassloadingSimpleVerifier(new IsAssignableFromCachingTypeHierarchyReader(new ConcurrentMapCachingTypeHierarchyReader(this.typeHierarchyReader)));
    }

    private static final class FromConfiguredClassPathTypeHierarchyReader
    extends TypeHierarchyReader {
        private final ClassPath classPath;

        public FromConfiguredClassPathTypeHierarchyReader(ClassPath classPath) {
            this.classPath = classPath;
        }

        @Override
        protected ClassReader reader(Type t) throws IOException {
            return new ClassReader(this.classPath.getResourceAsStream(Dotted.fromType(t).asResource()));
        }
    }
}

