/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers;

import org.mutabilitydetector.MutabilityReason;
import org.mutabilitydetector.checkers.AccessModifierQuery;
import org.mutabilitydetector.checkers.AsmMutabilityChecker;
import org.mutabilitydetector.checkers.MethodIs;
import org.mutabilitydetector.internal.org.objectweb.asm.MethodVisitor;
import org.mutabilitydetector.locations.CodeLocation;

public final class CanSubclassChecker
extends AsmMutabilityChecker {
    private boolean isFinal = true;
    private boolean hasOnlyPrivateConstructors = true;

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        if (AccessModifierQuery.type(access).isNotFinal()) {
            this.isFinal = false;
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (MethodIs.aConstructor(name) && AccessModifierQuery.method(access).isNotPrivate() && AccessModifierQuery.method(access).isNotSynthetic()) {
            this.hasOnlyPrivateConstructors = false;
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        if (!this.isFinal && !this.hasOnlyPrivateConstructors) {
            this.setResult("Can be subclassed, therefore parameters declared to be this type could be mutable subclasses at runtime.", CodeLocation.ClassLocation.fromInternalName(this.ownerClass), MutabilityReason.CAN_BE_SUBCLASSED);
        }
    }
}

