/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers;

import java.util.ArrayList;
import java.util.List;
import org.mutabilitydetector.asmoverride.AsmVerifierFactory;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MethodNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.analysis.Analyzer;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.analysis.BasicValue;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.analysis.Frame;

public abstract class FieldAssignmentVisitor
extends MethodNode {
    protected List<FieldInsnNode> fieldAssignments = new ArrayList<FieldInsnNode>();
    protected final String owner;
    private final AsmVerifierFactory verifierFactory;

    public FieldAssignmentVisitor(String owner, int access, String name, String desc, String signature, String[] exceptions, AsmVerifierFactory verifierFactory) {
        super(458752, access, name, desc, signature, exceptions);
        this.owner = owner;
        this.verifierFactory = verifierFactory;
    }

    @Override
    public void visitFieldInsn(int opcode, String fieldsOwner, String fieldName, String fieldDesc) {
        super.visitFieldInsn(opcode, fieldsOwner, fieldName, fieldDesc);
        if (opcode == 181) {
            this.fieldAssignments.add((FieldInsnNode)this.instructions.getLast());
        }
    }

    protected abstract void visitFieldAssignmentFrame(Frame<BasicValue> var1, FieldInsnNode var2, BasicValue var3);

    @Override
    public void visitEnd() {
        super.visitEnd();
        if (this.fieldAssignments.isEmpty()) {
            return;
        }
        Analyzer<BasicValue> a = new Analyzer<BasicValue>(this.verifierFactory.interpreter());
        try {
            Frame<BasicValue>[] frames = a.analyze(this.owner, this);
            for (FieldInsnNode fieldInsnNode : this.fieldAssignments) {
                Frame<BasicValue> assignmentFrame = frames[this.instructions.indexOf(fieldInsnNode)];
                int stackSlot = assignmentFrame.getStackSize() - 1;
                BasicValue stackValue = assignmentFrame.getStack(stackSlot);
                this.visitFieldAssignmentFrame(assignmentFrame, fieldInsnNode, stackValue);
            }
        }
        catch (AnalyzerException forwarded) {
            throw new RuntimeException(forwarded);
        }
    }

    protected boolean isInvalidStackValue(BasicValue stackValue) {
        return stackValue == null || "Lnull;".equals(stackValue.getType().toString());
    }

    protected BasicValue getStackValue(Frame<BasicValue> assignmentFrame) {
        int stackSlot = assignmentFrame.getStackSize() - 1;
        return assignmentFrame.getStack(stackSlot);
    }
}

