/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers;

import org.mutabilitydetector.MutabilityReason;
import org.mutabilitydetector.asmoverride.AsmVerifierFactory;
import org.mutabilitydetector.checkers.AccessModifierQuery;
import org.mutabilitydetector.checkers.AsmMutabilityChecker;
import org.mutabilitydetector.checkers.FieldAssignmentVisitor;
import org.mutabilitydetector.checkers.MethodIs;
import org.mutabilitydetector.checkers.VarStack;
import org.mutabilitydetector.checkers.info.MethodIdentifier;
import org.mutabilitydetector.checkers.info.PrivateMethodInvocationInformation;
import org.mutabilitydetector.internal.org.objectweb.asm.MethodVisitor;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.analysis.BasicValue;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.analysis.Frame;
import org.mutabilitydetector.locations.CodeLocation;
import org.mutabilitydetector.locations.Dotted;
import org.mutabilitydetector.locations.Slashed;

public final class OldSetterMethodChecker
extends AsmMutabilityChecker {
    private final PrivateMethodInvocationInformation privateMethodInvocationInfo;
    private final AsmVerifierFactory verifierFactory;

    private OldSetterMethodChecker(PrivateMethodInvocationInformation privateMethodInvocationInfo, AsmVerifierFactory verifierFactory) {
        this.privateMethodInvocationInfo = privateMethodInvocationInfo;
        this.verifierFactory = verifierFactory;
    }

    public static OldSetterMethodChecker newSetterMethodChecker(PrivateMethodInvocationInformation privateMethodInvocationInfo, AsmVerifierFactory verifierFactory) {
        return new OldSetterMethodChecker(privateMethodInvocationInfo, verifierFactory);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return new SetterAssignmentVisitor(this.ownerClass, access, name, desc, signature, exceptions, this.verifierFactory);
    }

    class SetterAssignmentVisitor
    extends FieldAssignmentVisitor {
        private final VarStack varStack;

        public SetterAssignmentVisitor(String ownerName, int access, String name, String desc, String signature, String[] exceptions, AsmVerifierFactory verifierFactory) {
            super(ownerName, access, name, desc, signature, exceptions, verifierFactory);
            this.varStack = new VarStack();
        }

        @Override
        protected void visitFieldAssignmentFrame(Frame<BasicValue> assignmentFrame, FieldInsnNode fieldInsnNode, BasicValue stackValue) {
            if (MethodIs.aConstructor(this.name) || this.isInvalidStackValue(stackValue)) {
                return;
            }
            if (AccessModifierQuery.method(this.access).isStatic()) {
                this.detectInStaticMethod(fieldInsnNode);
            } else {
                this.detectInInstanceMethod(fieldInsnNode);
            }
        }

        private boolean isOnlyCalledFromConstructor() {
            MethodIdentifier methodId = MethodIdentifier.forMethod(Slashed.slashed(this.owner), this.name + ":" + this.desc);
            return OldSetterMethodChecker.this.privateMethodInvocationInfo.isOnlyCalledFromConstructor(methodId);
        }

        private void detectInStaticMethod(FieldInsnNode fieldInsnNode) {
            String ownerOfReassignedField = fieldInsnNode.owner;
            if (this.reassignedIsThisType(ownerOfReassignedField) && this.assignmentIsNotOnAParameter(fieldInsnNode)) {
                this.setIsImmutableResult(fieldInsnNode.name, Dotted.fromFieldInsnNode(fieldInsnNode));
            }
        }

        private boolean assignmentIsNotOnAParameter(FieldInsnNode fieldInsnNode) {
            return this.desc.contains(fieldInsnNode.owner);
        }

        private boolean reassignedIsThisType(String ownerOfReassignedField) {
            return this.owner.compareTo(ownerOfReassignedField) == 0;
        }

        private void detectInInstanceMethod(FieldInsnNode fieldInsnNode) {
            if (this.isOnlyCalledFromConstructor()) {
                return;
            }
            VarStack.VarStackSnapshot varStackSnapshot = this.varStack.next();
            if (varStackSnapshot.thisObjectWasAddedToStack()) {
                this.setIsImmutableResult(fieldInsnNode.name, Dotted.fromFieldInsnNode(fieldInsnNode));
            }
        }

        @Override
        public void visitFieldInsn(int opcode, String fieldsOwner, String fieldName, String fieldDesc) {
            super.visitFieldInsn(opcode, fieldsOwner, fieldName, fieldDesc);
            if (opcode == 181) {
                this.varStack.takeSnapshotOfVarsAtPutfield();
            }
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            super.visitVarInsn(opcode, var);
            this.varStack.visitVarInsn(var);
        }

        private void setIsImmutableResult(String fieldName, Dotted fieldType) {
            OldSetterMethodChecker.this.setResult(String.format("Field [%s] can be reassigned within method [%s]", fieldName, this.name), CodeLocation.FieldLocation.fieldLocation(fieldName, CodeLocation.ClassLocation.fromInternalName(this.owner), fieldType), MutabilityReason.FIELD_CAN_BE_REASSIGNED);
        }
    }
}

