/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.hint;

import java.util.AbstractCollection;
import java.util.Collection;
import org.mutabilitydetector.checkers.CollectionField;
import org.mutabilitydetector.checkers.ImmutableCollectionChecker;
import org.mutabilitydetector.checkers.hint.WrappingHint;
import org.mutabilitydetector.checkers.hint.exceptions.WrappingHintGenerationException;
import org.mutabilitydetector.checkers.info.CopyMethod;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableCollection;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableMultimap;
import org.mutabilitydetector.internal.com.google.common.collect.Multimap;
import org.mutabilitydetector.internal.org.objectweb.asm.Type;
import org.mutabilitydetector.locations.ClassNameConverter;

public final class WrappingHintGenerator {
    private ImmutableCollectionChecker.Configuration configuration;
    private String typeSignature;
    private String typeAssignedToField;
    private Multimap<String, CopyMethod> userDefinedCopyMethods;
    private static final ClassNameConverter CLASS_NAME_CONVERTER = new ClassNameConverter();

    public WrappingHintGenerator(ImmutableCollectionChecker.Configuration configuration, String typeSignature, Type fieldType, Multimap<String, CopyMethod> userDefinedCopyMethods) {
        this.configuration = configuration;
        this.typeSignature = typeSignature;
        this.typeAssignedToField = WrappingHintGenerator.typeToString(fieldType);
        this.userDefinedCopyMethods = userDefinedCopyMethods;
    }

    public WrappingHint generate() {
        try {
            WrappingHint.Builder builder = WrappingHint.builder();
            this.generateWrappingPart(builder);
            this.generateCopyingPart(builder);
            return builder.build();
        }
        catch (WrappingHintGenerationException e) {
            return WrappingHint.NO_HINT;
        }
    }

    private void generateCopyingPart(WrappingHint.Builder builder) {
        Collection copyMethods = ImmutableMultimap.builder().putAll(this.configuration.FIELD_TYPE_TO_COPY_METHODS).putAll(this.userDefinedCopyMethods).build().get((Object)this.typeAssignedToField);
        if (((AbstractCollection)copyMethods).isEmpty()) {
            throw new WrappingHintGenerationException();
        }
        CopyMethod firstSuitable = (CopyMethod)((ImmutableCollection)copyMethods).iterator().next();
        builder.setCopyMethodOwnerName(firstSuitable.owner.toString()).setCopyMethodName(firstSuitable.name);
        if (firstSuitable.isGeneric && this.typeSignature != null) {
            CollectionField withRemovedWildcards = CollectionField.from(this.typeAssignedToField, this.typeSignature).transformGenericTree(CollectionField.GenericType::withoutWildcard);
            builder.setCopyTypeParameterName(WrappingHintGenerator.formatTypeParameter(withRemovedWildcards.asSimpleString()));
        }
    }

    private void generateWrappingPart(WrappingHint.Builder builder) {
        builder.setWrappingMethodOwnerName(this.configuration.UNMODIFIABLE_METHOD_OWNER).setWrappingMethodName(this.configuration.FIELD_TYPE_TO_UNMODIFIABLE_METHOD.get(this.typeAssignedToField));
    }

    private static String formatTypeParameter(String typeParameter) {
        return typeParameter.substring(typeParameter.indexOf(60), typeParameter.lastIndexOf(62) + 1);
    }

    private static String typeToString(Type type) {
        return CLASS_NAME_CONVERTER.dotted(type.getInternalName());
    }
}

