/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.info;

import java.util.HashMap;
import java.util.Map;
import org.mutabilitydetector.checkers.info.AnalysisInformation;
import org.mutabilitydetector.checkers.info.InformationRetrievalRunner;
import org.mutabilitydetector.checkers.util.TypeStructureInformationAnalyser;
import org.mutabilitydetector.locations.ClassIdentifier;
import org.mutabilitydetector.locations.Dotted;

public final class TypeStructureInformation
implements AnalysisInformation {
    private final InformationRetrievalRunner sessionCheckerRunner;
    private final Map<Dotted, Boolean> isAbstractMap = new HashMap<Dotted, Boolean>();
    private final Map<Dotted, Boolean> isInterfaceMap = new HashMap<Dotted, Boolean>();

    public TypeStructureInformation(InformationRetrievalRunner sessionCheckerRunner) {
        this.sessionCheckerRunner = sessionCheckerRunner;
    }

    private void runCheckerAndPopulateResultMaps(Dotted className) {
        TypeStructureInformationAnalyser analyser = TypeStructureInformationAnalyser.newAnalyser(className);
        this.sessionCheckerRunner.run(analyser, ClassIdentifier.forClass(className));
        this.isAbstractMap.put(className, analyser.isAbstract());
        this.isInterfaceMap.put(className, analyser.isInterface());
    }

    private Boolean getResultFrom(Dotted className, Map<Dotted, Boolean> resultMap) {
        if (!resultMap.containsKey(className)) {
            this.runCheckerAndPopulateResultMaps(className);
        }
        return resultMap.get(className);
    }

    public boolean isTypeAbstract(Dotted className) {
        return this.getResultFrom(className, this.isAbstractMap);
    }

    public boolean isTypeInterface(Dotted className) {
        return this.getResultFrom(className, this.isInterfaceMap);
    }
}

