/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.settermethod;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.mutabilitydetector.checkers.settermethod.JumpInsn;
import org.mutabilitydetector.checkers.settermethod.Opcode;
import org.mutabilitydetector.internal.com.google.common.base.Preconditions;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.AbstractInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FrameNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.IincInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.InsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.IntInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.JumpInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.LabelNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.LdcInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.LineNumberNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MethodInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.TypeInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.VarInsnNode;

final class AssignmentGuard
implements JumpInsn {
    private final JumpInsn delegationTarget;
    private final List<AbstractInsnNode> predecessorInstructions;

    private AssignmentGuard(JumpInsn theDelegationTarget, List<AbstractInsnNode> thePredecessorInstructions) {
        this.delegationTarget = theDelegationTarget;
        this.predecessorInstructions = thePredecessorInstructions;
    }

    public static AssignmentGuard newInstance(JumpInsn delegationTarget, List<AbstractInsnNode> predecessorInstructions) {
        AssignmentGuard.validateArguments(delegationTarget, predecessorInstructions);
        return new AssignmentGuard(delegationTarget, predecessorInstructions);
    }

    private static void validateArguments(JumpInsn delegationTarget, List<AbstractInsnNode> predecessorInstructions) {
        String msg = "Argument '%s' must not be %s!";
        Preconditions.checkNotNull(delegationTarget, "Argument '%s' must not be %s!", (Object)"delegationTarget", (Object)"null");
        Preconditions.checkNotNull(predecessorInstructions, "Argument '%s' must not be %s!", (Object)"predecessorInstructions", (Object)"null");
        Preconditions.checkArgument(!predecessorInstructions.isEmpty(), "Argument '%s' must not be %s!", (Object)"predecessorInstructions", (Object)"empty");
    }

    @Override
    public JumpInsnNode getJumpInsnNode() {
        return this.delegationTarget.getJumpInsnNode();
    }

    @Override
    public int getIndexWithinBlock() {
        return this.delegationTarget.getIndexWithinBlock();
    }

    @Override
    public int getIndexWithinMethod() {
        return this.delegationTarget.getIndexWithinMethod();
    }

    @Override
    public Opcode getOpcode() {
        return this.delegationTarget.getOpcode();
    }

    @Override
    public boolean isAssignmentGuard() {
        return true;
    }

    @Override
    public int compareTo(JumpInsn o) {
        return this.delegationTarget.compareTo(o);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        JumpInsnNode jumpInsnNode = this.getJumpInsnNode();
        result = 31 * result + jumpInsnNode.getOpcode();
        InstructionNodesHashCodeCalculator hcc = new InstructionNodesHashCodeCalculator(31);
        for (AbstractInsnNode predecessor : this.predecessorInstructions) {
            int hashCodeOfPredecessor = hcc.hashCode(predecessor);
            result = 31 * result + hashCodeOfPredecessor;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignmentGuard)) {
            return false;
        }
        AssignmentGuard other = (AssignmentGuard)obj;
        JumpInsnNode jumpInsnNodeThis = this.delegationTarget.getJumpInsnNode();
        JumpInsnNode jumpInsnNodeOther = other.getJumpInsnNode();
        if (jumpInsnNodeThis.getOpcode() != jumpInsnNodeOther.getOpcode()) {
            return false;
        }
        if (this.predecessorInstructions.size() != other.predecessorInstructions.size()) {
            return false;
        }
        InstructionNodesComparator inc = new InstructionNodesComparator();
        for (int i = 0; i < this.predecessorInstructions.size(); ++i) {
            AbstractInsnNode insnsThis = this.predecessorInstructions.get(i);
            AbstractInsnNode insnsOther = other.predecessorInstructions.get(i);
            if (insnsThis.getOpcode() != insnsOther.getOpcode()) {
                return false;
            }
            if (!AssignmentGuard.instructionsAreUnequal(insnsThis, insnsOther, inc)) continue;
            return false;
        }
        return true;
    }

    private static boolean instructionsAreUnequal(AbstractInsnNode insnThis, AbstractInsnNode insnOther, InstructionNodesComparator inc) {
        int nodeType = insnThis.getType();
        boolean result = 4 == nodeType ? inc.equals((FieldInsnNode)insnThis, (FieldInsnNode)insnOther) : (2 == nodeType ? inc.equals((VarInsnNode)insnThis, (VarInsnNode)insnOther) : (0 == nodeType ? inc.equals((InsnNode)insnThis, (InsnNode)insnOther) : (1 == nodeType ? inc.equals((IntInsnNode)insnThis, (IntInsnNode)insnOther) : (6 == nodeType ? inc.equals((InvokeDynamicInsnNode)insnThis, (InvokeDynamicInsnNode)insnOther) : (7 == nodeType ? inc.equals((JumpInsnNode)insnThis, (JumpInsnNode)insnOther) : (8 == nodeType ? inc.equals((LabelNode)insnThis, (LabelNode)insnOther) : (9 == nodeType ? inc.equals((LdcInsnNode)insnThis, (LdcInsnNode)insnOther) : (15 == nodeType ? inc.equals((LineNumberNode)insnThis, (LineNumberNode)insnOther) : (5 == nodeType ? inc.equals((MethodInsnNode)insnThis, (MethodInsnNode)insnOther) : (10 == nodeType ? inc.equals((IincInsnNode)insnThis, (IincInsnNode)insnOther) : (12 == nodeType ? inc.equals((LookupSwitchInsnNode)insnThis, (LookupSwitchInsnNode)insnOther) : (14 == nodeType ? inc.equals((FrameNode)insnThis, (FrameNode)insnOther) : (3 == nodeType ? inc.equals((TypeInsnNode)insnThis, (TypeInsnNode)insnOther) : (13 == nodeType ? inc.equals((MultiANewArrayInsnNode)insnThis, (MultiANewArrayInsnNode)insnOther) : (11 == nodeType ? inc.equals((TableSwitchInsnNode)insnThis, (TableSwitchInsnNode)insnOther) : false)))))))))))))));
        return !result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName()).append(" [delegationTarget=").append(this.delegationTarget);
        b.append(", predecessorInstructions=").append(this.predecessorInstructions).append(']');
        return b.toString();
    }

    @Immutable
    private static final class InstructionNodesComparator {
        private InstructionNodesComparator() {
        }

        public boolean equals(FieldInsnNode f1, FieldInsnNode f2) {
            return f1.desc.equals(f2.desc) && f1.name.equals(f2.name) && f1.owner.equals(f2.owner);
        }

        public boolean equals(VarInsnNode insnThis, VarInsnNode insnOther) {
            return insnThis.var == insnOther.var;
        }

        public boolean equals(InsnNode insnThis, InsnNode insnOther) {
            return true;
        }

        public boolean equals(IntInsnNode insnThis, IntInsnNode insnOther) {
            return insnThis.operand == insnOther.operand;
        }

        public boolean equals(InvokeDynamicInsnNode i1, InvokeDynamicInsnNode i2) {
            return i1.name.equals(i2.name) && i1.desc.equals(i2.desc) && i1.bsm.equals(i2.bsm) && Arrays.equals(i1.bsmArgs, i2.bsmArgs);
        }

        public boolean equals(JumpInsnNode insnThis, JumpInsnNode insnOther) {
            return true;
        }

        public boolean equals(LabelNode insnThis, LabelNode insnOther) {
            return true;
        }

        public boolean equals(LdcInsnNode insnThis, LdcInsnNode insnOther) {
            return insnThis.cst.equals(insnOther.cst);
        }

        public boolean equals(LineNumberNode insnThis, LineNumberNode insnOther) {
            return true;
        }

        public boolean equals(MethodInsnNode m1, MethodInsnNode m2) {
            return m1.desc.equals(m2.name) && m1.name.equals(m2.name) && m1.owner.equals(m2.owner);
        }

        public boolean equals(IincInsnNode i1, IincInsnNode i2) {
            return i1.var == i2.var && i1.incr == i2.incr;
        }

        public boolean equals(LookupSwitchInsnNode l1, LookupSwitchInsnNode l2) {
            return l1.keys.equals(l2.keys);
        }

        public boolean equals(FrameNode f1, FrameNode f2) {
            return f1.local.equals(f2.local) && f1.stack.equals(f2.stack);
        }

        public boolean equals(TypeInsnNode t1, TypeInsnNode t2) {
            return t1.desc.equals(t2.desc);
        }

        public boolean equals(MultiANewArrayInsnNode m1, MultiANewArrayInsnNode m2) {
            return m1.desc.equals(m2.desc) && m1.dims == m2.dims;
        }

        public boolean equals(TableSwitchInsnNode t1, TableSwitchInsnNode t2) {
            return t1.min == t2.min && t1.max == t2.max;
        }
    }

    @Immutable
    private static final class InstructionNodesHashCodeCalculator {
        private static final byte INITIAL_RESULT = 1;
        private final int prime;

        public InstructionNodesHashCodeCalculator(int thePrime) {
            this.prime = thePrime;
        }

        public int hashCode(AbstractInsnNode insn) {
            int nodeType = insn.getType();
            int result = 4 == nodeType ? this.hashCode((FieldInsnNode)insn) : (2 == nodeType ? this.hashCode((VarInsnNode)insn) : (0 == nodeType ? this.hashCode((InsnNode)insn) : (1 == nodeType ? this.hashCode((IntInsnNode)insn) : (6 == nodeType ? this.hashCode((InvokeDynamicInsnNode)insn) : (7 == nodeType ? this.hashCode((JumpInsnNode)insn) : (8 == nodeType ? this.hashCode((LabelNode)insn) : (9 == nodeType ? this.hashCode((LdcInsnNode)insn) : (15 == nodeType ? this.hashCode((LineNumberNode)insn) : (5 == nodeType ? this.hashCode((MethodInsnNode)insn) : (10 == nodeType ? this.hashCode((IincInsnNode)insn) : (12 == nodeType ? this.hashCode((LookupSwitchInsnNode)insn) : (14 == nodeType ? this.hashCode((FrameNode)insn) : (3 == nodeType ? this.hashCode((TypeInsnNode)insn) : (13 == nodeType ? this.hashCode((MultiANewArrayInsnNode)insn) : (11 == nodeType ? this.hashCode((TableSwitchInsnNode)insn) : insn.hashCode())))))))))))))));
            return this.hashCode(result, insn.getOpcode());
        }

        private int hashCode(FieldInsnNode insn) {
            int result = 1;
            result = this.hashCode(result, insn.desc.hashCode());
            result = this.hashCode(result, insn.name.hashCode());
            result = this.hashCode(result, insn.owner.hashCode());
            return result;
        }

        private final int hashCode(int preliminaryResult, int hashCode) {
            return this.prime * preliminaryResult + hashCode;
        }

        private int hashCode(VarInsnNode insn) {
            return this.hashCode(1, insn.var);
        }

        private int hashCode(InsnNode insn) {
            return this.hashCode(1, insn.hashCode());
        }

        private int hashCode(IntInsnNode insn) {
            return this.hashCode(1, insn.operand);
        }

        private int hashCode(InvokeDynamicInsnNode insn) {
            int result = 1;
            result = this.hashCode(result, insn.name.hashCode());
            result = this.hashCode(result, insn.desc.hashCode());
            result = this.hashCode(result, insn.bsm.hashCode());
            result = this.hashCode(result, insn.hashCode());
            return result;
        }

        private int hashCode(JumpInsnNode insn) {
            return this.hashCode(1, 0);
        }

        private int hashCode(LabelNode insn) {
            return this.hashCode(1, 0);
        }

        private int hashCode(LdcInsnNode insn) {
            return this.hashCode(1, insn.cst.hashCode());
        }

        private int hashCode(LineNumberNode insn) {
            return this.hashCode(1, 0);
        }

        private int hashCode(MethodInsnNode insn) {
            int result = 1;
            result = this.hashCode(result, insn.desc.hashCode());
            result = this.hashCode(result, insn.name.hashCode());
            result = this.hashCode(result, insn.owner.hashCode());
            return result;
        }

        private int hashCode(IincInsnNode insn) {
            int result = 1;
            result = this.hashCode(result, insn.var);
            result = this.hashCode(result, insn.incr);
            return result;
        }

        private int hashCode(LookupSwitchInsnNode insn) {
            return this.hashCode(1, insn.keys.hashCode());
        }

        private int hashCode(FrameNode insn) {
            int result = 1;
            result = this.hashCode(result, insn.local.hashCode());
            result = this.hashCode(result, insn.stack.hashCode());
            return result;
        }

        private int hashCode(TypeInsnNode insn) {
            return this.hashCode(1, insn.desc.hashCode());
        }

        private int hashCode(MultiANewArrayInsnNode insn) {
            int result = 1;
            result = this.hashCode(result, insn.dims);
            result = this.hashCode(result, insn.desc.hashCode());
            return result;
        }

        private int hashCode(TableSwitchInsnNode insn) {
            int result = 1;
            result = this.hashCode(result, insn.min);
            result = this.hashCode(result, insn.max);
            return result;
        }
    }

    @NotThreadSafe
    public static final class Builder {
        private final JumpInsn jumpInstruction;
        private final ArrayList<AbstractInsnNode> predecessorInstructions;

        public Builder(JumpInsn theJumpInstruction) {
            this.jumpInstruction = theJumpInstruction;
            this.predecessorInstructions = new ArrayList();
        }

        public void addPredecessorInstruction(AbstractInsnNode predecessor) {
            this.predecessorInstructions.add(predecessor);
        }

        public AssignmentGuard build() {
            this.predecessorInstructions.trimToSize();
            return AssignmentGuard.newInstance(this.jumpInstruction, this.predecessorInstructions);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.getDeclaringClassPrefix()).append(this.getClass().getSimpleName());
            b.append(" [jumpInstruction=").append(this.jumpInstruction);
            b.append(", predecessorInstructions=").append(this.predecessorInstructions).append(']');
            return b.toString();
        }

        private String getDeclaringClassPrefix() {
            String result;
            Class<?> superclass = this.getClass().getDeclaringClass();
            if (null != superclass) {
                StringBuilder b = new StringBuilder();
                b.append(superclass.getSimpleName()).append('.');
                result = b.toString();
            } else {
                result = "";
            }
            return result;
        }
    }
}

