/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.settermethod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.mutabilitydetector.checkers.settermethod.Alias;
import org.mutabilitydetector.checkers.settermethod.AliasFinder;
import org.mutabilitydetector.checkers.settermethod.AssignmentGuard;
import org.mutabilitydetector.checkers.settermethod.ControlFlowBlock;
import org.mutabilitydetector.checkers.settermethod.DefaultJumpInsn;
import org.mutabilitydetector.checkers.settermethod.Finder;
import org.mutabilitydetector.checkers.settermethod.JumpInsn;
import org.mutabilitydetector.checkers.settermethod.NullJumpInsn;
import org.mutabilitydetector.internal.com.google.common.base.Preconditions;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.AbstractInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.JumpInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MethodInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.VarInsnNode;

@Immutable
final class AssignmentGuardFinder
implements Finder<JumpInsn> {
    private final String candidateName;
    private final ControlFlowBlock controlFlowBlock;

    private AssignmentGuardFinder(String theCandidateName, ControlFlowBlock theControlFlowBlock) {
        this.candidateName = theCandidateName;
        this.controlFlowBlock = theControlFlowBlock;
    }

    public static AssignmentGuardFinder newInstance(String candidateName, ControlFlowBlock controlFlowBlock) {
        Preconditions.checkArgument(!candidateName.isEmpty());
        return new AssignmentGuardFinder(candidateName, Preconditions.checkNotNull(controlFlowBlock));
    }

    @Override
    public JumpInsn find() {
        Collection<JumpInsn> supposedAssignmentGuards = this.collectSupposedAssignmentGuards();
        if (1 < supposedAssignmentGuards.size()) {
            throw new IllegalStateException("There exists more than one assignment guard in this block.");
        }
        Iterator<JumpInsn> iterator = supposedAssignmentGuards.iterator();
        if (iterator.hasNext()) {
            JumpInsn jumpInsn = iterator.next();
            return jumpInsn;
        }
        return NullJumpInsn.getInstance();
    }

    private Collection<JumpInsn> collectSupposedAssignmentGuards() {
        HashSet<JumpInsn> result = new HashSet<JumpInsn>();
        for (JumpInsn jumpInsn : this.collectAllConditionCheckInstructionsOfBlock()) {
            AssignmentGuard.Builder builder = new AssignmentGuard.Builder(jumpInsn);
            JumpInsn possibleAssignmentGuard = this.getAssignmentGuard(jumpInsn.getIndexWithinBlock(), builder);
            if (!possibleAssignmentGuard.isAssignmentGuard()) continue;
            result.add(possibleAssignmentGuard);
        }
        return result;
    }

    private Collection<JumpInsn> collectAllConditionCheckInstructionsOfBlock() {
        ArrayList<JumpInsn> result = new ArrayList<JumpInsn>();
        int indexWithinBlock = 0;
        for (AbstractInsnNode insn : this.controlFlowBlock.getBlockInstructions()) {
            if (AssignmentGuardFinder.isConditionCheckInstruction(insn)) {
                JumpInsnNode jumpInsnNode = (JumpInsnNode)insn;
                int indexWithinMethod = this.controlFlowBlock.getIndexWithinMethod(indexWithinBlock);
                result.add(DefaultJumpInsn.newInstance(jumpInsnNode, indexWithinBlock, indexWithinMethod));
            }
            ++indexWithinBlock;
        }
        result.trimToSize();
        return result;
    }

    private static boolean isConditionCheckInstruction(AbstractInsnNode insn) {
        int opcode = insn.getOpcode();
        return 7 == insn.getType() && opcode != 167 && opcode != 168 && opcode != 169;
    }

    private JumpInsn getAssignmentGuard(int indexOfInstructionToAnalyse, AssignmentGuard.Builder builder) {
        List<AbstractInsnNode> blockInstructions = this.controlFlowBlock.getBlockInstructions();
        int indexOfPredecessorInstruction = indexOfInstructionToAnalyse - 1;
        AbstractInsnNode predecessorInstruction = blockInstructions.get(indexOfPredecessorInstruction);
        builder.addPredecessorInstruction(predecessorInstruction);
        JumpInsn result = this.isGetfieldOrGetstaticForCandidate(predecessorInstruction) ? builder.build() : (this.isLoadInstructionForAlias(predecessorInstruction) ? builder.build() : (AssignmentGuardFinder.isEqualsInstruction(predecessorInstruction) ? NullJumpInsn.getInstance() : (AssignmentGuardFinder.isPushNullOntoStackInstruction(predecessorInstruction) ? this.getAssignmentGuard(indexOfPredecessorInstruction, builder) : (AssignmentGuardFinder.isComparisonInstruction(predecessorInstruction) ? this.getAssignmentGuard(indexOfPredecessorInstruction, builder) : NullJumpInsn.getInstance()))));
        return result;
    }

    private boolean isGetfieldOrGetstaticForCandidate(AbstractInsnNode insn) {
        boolean result = false;
        if (180 == insn.getOpcode() || 178 == insn.getOpcode()) {
            FieldInsnNode getInstruction = (FieldInsnNode)insn;
            result = this.candidateName.equals(getInstruction.name);
        }
        return result;
    }

    private boolean isLoadInstructionForAlias(AbstractInsnNode insn) {
        AliasFinder f = AliasFinder.newInstance(this.candidateName, this.controlFlowBlock);
        Alias alias = (Alias)f.find();
        return alias.doesExist && AssignmentGuardFinder.isLoadInstructionForAlias(insn, alias);
    }

    private static boolean isLoadInstructionForAlias(AbstractInsnNode insn, Alias alias) {
        boolean result = false;
        if (2 == insn.getType()) {
            VarInsnNode loadInstruction = (VarInsnNode)insn;
            result = loadInstruction.var == alias.localVariable;
        }
        return result;
    }

    private static boolean isEqualsInstruction(AbstractInsnNode insn) {
        boolean result;
        if (5 == insn.getType()) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)insn;
            result = methodInsnNode.name.equals("equals");
        } else {
            result = false;
        }
        return result;
    }

    private static boolean isPushNullOntoStackInstruction(AbstractInsnNode insn) {
        return 1 == insn.getOpcode();
    }

    private static boolean isComparisonInstruction(AbstractInsnNode insn) {
        switch (insn.getOpcode()) {
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName()).append(" [candidateName=").append(this.candidateName);
        b.append(", controlFlowBlock=").append(this.controlFlowBlock).append(']');
        return b.toString();
    }
}

