/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.settermethod;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.mutabilitydetector.checkers.settermethod.ControlFlowBlock;
import org.mutabilitydetector.internal.com.google.common.base.Preconditions;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MethodNode;

@ThreadSafe
final class ControlFlowBlockCache {
    private final String owner;
    @GuardedBy(value="this")
    private final Map<String, MethodNode> methodNodes;
    @GuardedBy(value="this")
    private final Map<String, List<ControlFlowBlock>> controlFlowBlocks;

    private ControlFlowBlockCache(String theOwner) {
        this.owner = theOwner;
        this.methodNodes = new HashMap<String, MethodNode>();
        this.controlFlowBlocks = new HashMap<String, List<ControlFlowBlock>>();
    }

    public static ControlFlowBlockCache newInstance(String owner) {
        Preconditions.checkArgument(!owner.isEmpty());
        return new ControlFlowBlockCache(owner);
    }

    public List<ControlFlowBlock> getControlFlowBlocksForMethod(MethodNode methodNode) {
        String mapKey;
        List<ControlFlowBlock> result = null == methodNode ? Collections.emptyList() : (this.controlFlowBlocks.containsKey(mapKey = ControlFlowBlockCache.toMapKey(methodNode)) ? this.controlFlowBlocks.get(mapKey) : this.createAndAddToCache(mapKey, methodNode));
        return result;
    }

    private static String toMapKey(MethodNode methodNode) {
        String keyTemplate = "%s:%s";
        return String.format("%s:%s", methodNode.name, methodNode.desc);
    }

    private synchronized List<ControlFlowBlock> createAndAddToCache(String mapKey, MethodNode methodNode) {
        this.methodNodes.put(mapKey, methodNode);
        ControlFlowBlock.ControlFlowBlockFactory f = ControlFlowBlock.ControlFlowBlockFactory.newInstance(this.owner, methodNode);
        List<ControlFlowBlock> allControlFlowBlocksForMethod = f.getAllControlFlowBlocksForMethod();
        List<ControlFlowBlock> result = Collections.unmodifiableList(allControlFlowBlocksForMethod);
        this.controlFlowBlocks.put(mapKey, result);
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName()).append(" owner=").append(this.owner);
        b.append(", controlFlowBlocks=").append(this.controlFlowBlocks).append(']');
        return b.toString();
    }
}

