/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.settermethod;

import javax.annotation.concurrent.NotThreadSafe;
import org.mutabilitydetector.checkers.settermethod.AssignmentInsn;
import org.mutabilitydetector.checkers.settermethod.ControlFlowBlock;
import org.mutabilitydetector.checkers.settermethod.Opcode;
import org.mutabilitydetector.internal.com.google.common.base.Preconditions;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldInsnNode;

@NotThreadSafe
final class DefaultAssignmentInsn
implements AssignmentInsn {
    private final ControlFlowBlock surroundingControlFlowBlock;
    private final int indexWithinMethod;
    private final FieldInsnNode assignmentInsnNode;

    private DefaultAssignmentInsn(ControlFlowBlock theSurroundingControlFlowBlock, int theIndexWithinMethod, FieldInsnNode theAssignmentInsnNode) {
        this.surroundingControlFlowBlock = theSurroundingControlFlowBlock;
        this.indexWithinMethod = theIndexWithinMethod;
        this.assignmentInsnNode = theAssignmentInsnNode;
    }

    public static AssignmentInsn newInstance(ControlFlowBlock surroundingControlFlowBlock, int indexWithinMethod, FieldInsnNode assignmentInsnNode) {
        return new DefaultAssignmentInsn(Preconditions.checkNotNull(surroundingControlFlowBlock), indexWithinMethod, Preconditions.checkNotNull(assignmentInsnNode));
    }

    @Override
    public int getIndexWithinMethod() {
        return this.indexWithinMethod;
    }

    @Override
    public String getNameOfAssignedVariable() {
        return this.assignmentInsnNode.name;
    }

    @Override
    public ControlFlowBlock getSurroundingControlFlowBlock() {
        return this.surroundingControlFlowBlock;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.surroundingControlFlowBlock.hashCode();
        result = 31 * result + this.assignmentInsnNode.hashCode();
        result = 31 * result + this.indexWithinMethod;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultAssignmentInsn)) {
            return false;
        }
        DefaultAssignmentInsn other = (DefaultAssignmentInsn)obj;
        if (!this.surroundingControlFlowBlock.equals(other.surroundingControlFlowBlock)) {
            return false;
        }
        if (this.assignmentInsnNode == null ? other.assignmentInsnNode != null : !this.assignmentInsnNode.equals(other.assignmentInsnNode)) {
            return false;
        }
        return this.indexWithinMethod == other.indexWithinMethod;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" [surroundingControlFlowBlock=").append(this.surroundingControlFlowBlock);
        builder.append(", indexWithinMethod=").append(this.indexWithinMethod);
        builder.append(", assignmentInstructionNode=");
        Opcode opcode = Opcode.forInt(this.assignmentInsnNode.getOpcode());
        builder.append(opcode.name()).append(' ').append(this.assignmentInsnNode.name).append(']');
        return builder.toString();
    }
}

