/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.settermethod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.mutabilitydetector.MutabilityReason;
import org.mutabilitydetector.checkers.AsmMutabilityChecker;
import org.mutabilitydetector.checkers.info.MethodIdentifier;
import org.mutabilitydetector.checkers.info.PrivateMethodInvocationInformation;
import org.mutabilitydetector.checkers.settermethod.AbstractSetterMethodChecker;
import org.mutabilitydetector.checkers.settermethod.AssignmentGuardFinder;
import org.mutabilitydetector.checkers.settermethod.AssignmentGuardVerifier;
import org.mutabilitydetector.checkers.settermethod.AssignmentInsn;
import org.mutabilitydetector.checkers.settermethod.CandidatesInitialisersMapping;
import org.mutabilitydetector.checkers.settermethod.ControlFlowBlock;
import org.mutabilitydetector.checkers.settermethod.EffectiveAssignmentInsnFinder;
import org.mutabilitydetector.checkers.settermethod.EffectiveAssignmentInsnVerifier;
import org.mutabilitydetector.checkers.settermethod.EnhancedClassNode;
import org.mutabilitydetector.checkers.settermethod.InitialValueFinder;
import org.mutabilitydetector.checkers.settermethod.InitialisersFinder;
import org.mutabilitydetector.checkers.settermethod.JumpInsn;
import org.mutabilitydetector.checkers.settermethod.UnknownTypeValue;
import org.mutabilitydetector.internal.com.google.common.base.Preconditions;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MethodNode;
import org.mutabilitydetector.locations.Dotted;
import org.mutabilitydetector.locations.Slashed;

@NotThreadSafe
public final class SetterMethodChecker
extends AbstractSetterMethodChecker {
    private final PrivateMethodInvocationInformation privateMethodInvocationInfo;
    private final Map<FieldNode, Collection<UnknownTypeValue>> initialValues;
    private final Map<FieldNode, Collection<JumpInsn>> assignmentGuards;
    private final Map<FieldNode, AssignmentInsn> effectiveAssignmentInstructions;

    private SetterMethodChecker(PrivateMethodInvocationInformation thePrivateMethodInvocationInfo) {
        this.privateMethodInvocationInfo = thePrivateMethodInvocationInfo;
        this.initialValues = new HashMap<FieldNode, Collection<UnknownTypeValue>>();
        this.assignmentGuards = new HashMap<FieldNode, Collection<JumpInsn>>();
        this.effectiveAssignmentInstructions = new HashMap<FieldNode, AssignmentInsn>();
    }

    public static AsmMutabilityChecker newInstance() {
        return new SetterMethodChecker(null);
    }

    public static AsmMutabilityChecker newInstance(PrivateMethodInvocationInformation privateMethodInvocationInfo) {
        return new SetterMethodChecker(Preconditions.checkNotNull(privateMethodInvocationInfo));
    }

    @Override
    protected void collectInitialisers() {
        List<MethodNode> methodsOfAnalysedClass = this.getEnhancedClassNode().getMethods();
        InitialisersFinder f = InitialisersFinder.newInstance(methodsOfAnalysedClass, this.candidatesInitialisersMapping);
        this.candidatesInitialisersMapping = (CandidatesInitialisersMapping)f.find();
    }

    @Override
    protected void verifyCandidates() {
        Collection<FieldNode> unassociatedVariables = this.candidatesInitialisersMapping.removeAndGetCandidatesWithoutInitialisingMethod();
        for (FieldNode unassociatedVariable : unassociatedVariables) {
            this.setNonFinalFieldResult(unassociatedVariable.name, Dotted.fromFieldNode(unassociatedVariable));
        }
    }

    @Override
    protected void verifyInitialisers() {
        for (CandidatesInitialisersMapping.Entry entry : this.candidatesInitialisersMapping) {
            this.verifyInitialisersFor(entry.getCandidate(), entry.getInitialisers());
        }
        this.verifyVisibleSetterMethods();
    }

    private void verifyInitialisersFor(FieldNode candidate, CandidatesInitialisersMapping.Initialisers allInitialisersForCandidate) {
        List<MethodNode> initialisingMethods = allInitialisersForCandidate.getMethods();
        if (SetterMethodChecker.containsMoreThanOne(initialisingMethods)) {
            this.setFieldCanBeReassignedResultForEachMethodInitialiser(candidate.name, initialisingMethods);
        } else if (this.hasPrivateMethodInvocationInfo()) {
            for (MethodNode initialisingMethod : initialisingMethods) {
                this.removeCandidateIfInitialisingMethodIsOnlyCalledFromContructor(initialisingMethod);
            }
        }
    }

    private void verifyVisibleSetterMethods() {
        Map<String, Set<MethodNode>> allVisibleSetterMethods = this.candidatesInitialisersMapping.getAllVisibleSetterMethods();
        for (Map.Entry<String, Set<MethodNode>> e : allVisibleSetterMethods.entrySet()) {
            String variableName = e.getKey();
            for (MethodNode visibleSetterMethod : e.getValue()) {
                this.setFieldCanBeReassignedResult(variableName, visibleSetterMethod.name);
            }
        }
    }

    private static boolean containsMoreThanOne(Collection<?> aCollection) {
        return 1 < aCollection.size();
    }

    private void setFieldCanBeReassignedResultForEachMethodInitialiser(String candidateName, Collection<MethodNode> methodInitialisers) {
        for (MethodNode methodInitialiser : methodInitialisers) {
            this.setFieldCanBeReassignedResult(candidateName, methodInitialiser.name);
        }
    }

    private boolean hasPrivateMethodInvocationInfo() {
        return null != this.privateMethodInvocationInfo;
    }

    private void removeCandidateIfInitialisingMethodIsOnlyCalledFromContructor(MethodNode initialisingMethod) {
        if (this.isOnlyCalledFromConstructor(initialisingMethod)) {
            this.candidatesInitialisersMapping.removeAndGetCandidateForInitialisingMethod(initialisingMethod);
        }
    }

    private boolean isOnlyCalledFromConstructor(MethodNode initialisingMethod) {
        MethodIdentifierFactory factory = new MethodIdentifierFactory(initialisingMethod);
        MethodIdentifier methodId = factory.getMethodIdentifier();
        return this.privateMethodInvocationInfo.isOnlyCalledFromConstructor(methodId);
    }

    @Override
    protected void collectPossibleInitialValues() {
        for (CandidatesInitialisersMapping.Entry entry : this.candidatesInitialisersMapping) {
            FieldNode candidate = entry.getCandidate();
            CandidatesInitialisersMapping.Initialisers initialisers = entry.getInitialisers();
            InitialValueFinder f = InitialValueFinder.newInstance(candidate, initialisers, this.getEnhancedClassNode());
            Set possibleInitialValues = (Set)f.find();
            this.initialValues.put(candidate, possibleInitialValues);
        }
    }

    @Override
    protected void verifyPossibleInitialValues() {
        if (this.hasAnyVariableMoreThanOneInitialValue()) {
            this.setFieldCanBeReassignedResultForEachInitialValue();
        }
    }

    private boolean hasAnyVariableMoreThanOneInitialValue() {
        for (Map.Entry<FieldNode, Collection<UnknownTypeValue>> e : this.initialValues.entrySet()) {
            Collection<UnknownTypeValue> initialValuesForVariable = e.getValue();
            if (1 >= initialValuesForVariable.size()) continue;
            return true;
        }
        return false;
    }

    private void setFieldCanBeReassignedResultForEachInitialValue() {
        for (Map.Entry<FieldNode, Collection<UnknownTypeValue>> e : this.initialValues.entrySet()) {
            Collection<UnknownTypeValue> initialValuesForCandidate = e.getValue();
            String msgTmpl = "Field [%s] has too many possible initial values for lazy initialisation: [%s]";
            String candidateName = e.getKey().name;
            String initialValues = SetterMethodChecker.initialValuesToString(initialValuesForCandidate);
            String msg = String.format("Field [%s] has too many possible initial values for lazy initialisation: [%s]", candidateName, initialValues);
            this.setResultForClass(msg, MutabilityReason.FIELD_CAN_BE_REASSIGNED);
        }
    }

    private static String initialValuesToString(Collection<UnknownTypeValue> initialValuesForCandidate) {
        StringBuilder result = new StringBuilder();
        String separatorValue = ", ";
        String separator = "";
        for (UnknownTypeValue initialValue : initialValuesForCandidate) {
            result.append(separator).append(initialValue);
            separator = ", ";
        }
        return result.toString();
    }

    @Override
    protected void collectEffectiveAssignmentInstructions() {
        for (CandidatesInitialisersMapping.Entry e : this.candidatesInitialisersMapping) {
            FieldNode candidate = e.getCandidate();
            MethodNode initialisingMethod = this.getSoleInitialisingMethod(e.getInitialisers());
            this.addEffectiveAssignmentInstructionForCandidateIfPossible(candidate, initialisingMethod);
        }
    }

    private MethodNode getSoleInitialisingMethod(CandidatesInitialisersMapping.Initialisers initialisers) {
        List<MethodNode> initialisingMethods = initialisers.getMethods();
        MethodNode result = !initialisingMethods.isEmpty() ? initialisingMethods.get(0) : null;
        return result;
    }

    private void addEffectiveAssignmentInstructionForCandidateIfPossible(FieldNode candidate, MethodNode initialisingMethod) {
        if (null != initialisingMethod) {
            EnhancedClassNode cn = this.getEnhancedClassNode();
            List<ControlFlowBlock> blocks = cn.getControlFlowBlocksForMethod(initialisingMethod);
            EffectiveAssignmentInsnFinder f = EffectiveAssignmentInsnFinder.newInstance(candidate, blocks);
            this.effectiveAssignmentInstructions.put(candidate, (AssignmentInsn)f.find());
        }
    }

    @Override
    protected void verifyEffectiveAssignmentInstructions() {
        for (Map.Entry<FieldNode, AssignmentInsn> e : this.effectiveAssignmentInstructions.entrySet()) {
            EffectiveAssignmentInsnVerifier v = EffectiveAssignmentInsnVerifier.newInstance(e.getValue(), e.getKey(), this);
            v.verify();
        }
    }

    @Override
    protected void collectAssignmentGuards() {
        for (CandidatesInitialisersMapping.Entry e : this.candidatesInitialisersMapping) {
            CandidatesInitialisersMapping.Initialisers initialisers = e.getInitialisers();
            this.collectAssignmentGuardsForEachInitialisingMethod(e.getCandidate(), initialisers.getMethods());
        }
    }

    private void collectAssignmentGuardsForEachInitialisingMethod(FieldNode candidate, Collection<MethodNode> initialisingMethods) {
        for (MethodNode initialisingMethod : initialisingMethods) {
            EnhancedClassNode cn = this.getEnhancedClassNode();
            List<ControlFlowBlock> blocks = cn.getControlFlowBlocksForMethod(initialisingMethod);
            this.collectAssignmentGuardsForEachControlFlowBlock(candidate, blocks);
        }
    }

    private void collectAssignmentGuardsForEachControlFlowBlock(FieldNode candidate, Collection<ControlFlowBlock> controlFlowBlocks) {
        for (ControlFlowBlock controlFlowBlock : controlFlowBlocks) {
            AssignmentGuardFinder f = AssignmentGuardFinder.newInstance(candidate.name, controlFlowBlock);
            JumpInsn supposedAssignmentGuard = (JumpInsn)f.find();
            this.addToAssignmentGuards(candidate, supposedAssignmentGuard);
        }
    }

    private void addToAssignmentGuards(FieldNode candidate, JumpInsn supposedAssignmentGuard) {
        if (supposedAssignmentGuard.isAssignmentGuard()) {
            Collection<JumpInsn> assignmentGuardsForCandidate;
            if (this.assignmentGuards.containsKey(candidate)) {
                assignmentGuardsForCandidate = this.assignmentGuards.get(candidate);
            } else {
                int expectedMaximum = 3;
                assignmentGuardsForCandidate = new ArrayList<JumpInsn>(3);
                this.assignmentGuards.put(candidate, assignmentGuardsForCandidate);
            }
            assignmentGuardsForCandidate.add(supposedAssignmentGuard);
        }
    }

    @Override
    protected void verifyAssignmentGuards() {
        AssignmentGuardVerifier v = AssignmentGuardVerifier.newInstance(this.initialValues, this.assignmentGuards, this.candidatesInitialisersMapping, this);
        v.verify();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [initialValues=" + this.initialValues + ", assignmentGuards=" + this.assignmentGuards + ", effectiveAssignmentInstructions=" + this.effectiveAssignmentInstructions + ", candidatesInitialisersMapping=" + this.candidatesInitialisersMapping + "]";
    }

    private final class MethodIdentifierFactory {
        private final MethodNode method;

        public MethodIdentifierFactory(MethodNode theMethod) {
            this.method = Preconditions.checkNotNull(theMethod);
        }

        public MethodIdentifier getMethodIdentifier() {
            Slashed className = this.getSlashedClassName();
            String methodDescriptor = this.getMethodDescriptor();
            return MethodIdentifier.forMethod(className, methodDescriptor);
        }

        private Slashed getSlashedClassName() {
            String owner = SetterMethodChecker.this.getEnhancedClassNode().getName();
            return Slashed.slashed(owner);
        }

        private String getMethodDescriptor() {
            String methodName = this.method.name;
            String methodDesc = this.method.desc;
            return String.format("%s:%s", methodName, methodDesc);
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [method=" + this.method + "]";
        }
    }
}

