/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.mutabilitydetector.cli.ClassListException;
import org.mutabilitydetector.cli.ClassListToReportCollector;
import org.mutabilitydetector.cli.PlainTextClassListToReportReader;

public class ClassListReaderFactory {
    private final File classListFile;

    public ClassListReaderFactory(File classListFile) {
        this.classListFile = classListFile;
    }

    public ClassListToReportCollector createReader() {
        String fileName = this.classListFile.getName();
        if (fileName.endsWith(".txt")) {
            return this.constructPlainTextReader();
        }
        return this.constructPlainTextReader();
    }

    private ClassListToReportCollector constructPlainTextReader() {
        BufferedReader br;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.classListFile), Charset.forName("UTF-8")));
        }
        catch (FileNotFoundException e) {
            throw new ClassListException("Could not read class names from given file (" + this.classListFile.getAbsolutePath() + ")", e);
        }
        return new PlainTextClassListToReportReader(br);
    }
}

