/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.cli;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.mutabilitydetector.AnalysisError;
import org.mutabilitydetector.AnalysisResult;
import org.mutabilitydetector.IsImmutable;
import org.mutabilitydetector.MutableReasonDetail;
import org.mutabilitydetector.cli.BatchAnalysisOptions;
import org.mutabilitydetector.cli.ClassListReaderFactory;
import org.mutabilitydetector.cli.CommandLineOptions;
import org.mutabilitydetector.internal.com.google.common.collect.Ordering;
import org.mutabilitydetector.locations.Dotted;
import org.mutabilitydetector.misc.TimingUtil;

@Immutable
public final class SessionResultsFormatter {
    private final boolean verbose;
    private final boolean showSummary;
    private final CommandLineOptions.ReportMode reportMode;
    private final Collection<Dotted> classesToReport;
    private final BatchAnalysisOptions options;
    private final TimingUtil timingUtil;

    public SessionResultsFormatter(BatchAnalysisOptions options, ClassListReaderFactory readerFactory, TimingUtil timingUtil) {
        this.options = options;
        this.verbose = options.verbose();
        this.showSummary = options.showSummary();
        this.reportMode = options.reportMode();
        this.classesToReport = this.getClassesToReport(options.isUsingClassList(), readerFactory);
        this.timingUtil = timingUtil;
    }

    public StringBuilder format(Iterable<AnalysisResult> results, Iterable<AnalysisError> errors) {
        StringBuilder output = new StringBuilder();
        this.appendErrors(errors, output);
        this.appendAnalysisResults(results, output);
        return output;
    }

    private Collection<Dotted> getClassesToReport(boolean isUsingClassList, ClassListReaderFactory readerFactory) {
        return isUsingClassList ? readerFactory.createReader().classListToReport() : Collections.emptySet();
    }

    private void appendErrors(Iterable<AnalysisError> errors, StringBuilder output) {
        if (!this.options.reportErrors()) {
            return;
        }
        for (AnalysisError error : errors) {
            String message = String.format("Error while running %s on class %s.%n", error.checkerName, error.onClass);
            output.append(message);
            if (!this.verbose) continue;
            String description = String.format("\t%s%n", error.description);
            output.append(description);
        }
    }

    private void appendAnalysisResults(Iterable<AnalysisResult> results, StringBuilder output) {
        List<AnalysisResult> sortedList = this.sortByClassname(results);
        int total = 0;
        int totalNotImmutable = 0;
        for (AnalysisResult result : sortedList) {
            IsImmutable isImmutable = result.isImmutable;
            if (isImmutable.equals((Object)IsImmutable.NOT_IMMUTABLE)) {
                ++totalNotImmutable;
            }
            ++total;
            this.addResultForClass(output, result, isImmutable);
        }
        if (this.showSummary) {
            int totalImmutable = total - totalNotImmutable;
            this.appendSummaryOfResults(output, total, totalImmutable, totalNotImmutable);
        }
    }

    private void appendSummaryOfResults(StringBuilder output, int total, int totalImmutable, int totalMutable) {
        output.append(String.format("%n\t%d %s%n", total, "Total number of classes scanned."));
        output.append(String.format("\t%d %s%n", totalImmutable, "IMMUTABLE class(es)."));
        output.append(String.format("\t%d %s%n", totalMutable, "NOT_IMMUTABLE class(es)."));
        long processRuntime = this.timingUtil.getCurrentTimeMillis() - this.timingUtil.getVMStartTimeMillis();
        output.append(String.format("\t%d %s%n", processRuntime / 1000L, "seconds runtime."));
    }

    private List<AnalysisResult> sortByClassname(Iterable<AnalysisResult> sessionResults) {
        return Ordering.from(new ClassnameComparator()).sortedCopy(sessionResults);
    }

    private void addResultForClass(StringBuilder output, AnalysisResult result, IsImmutable isImmutable) {
        if (this.options.isUsingClassList() && !this.classesToReport.contains(result.className)) {
            return;
        }
        if (this.reportMode.equals((Object)CommandLineOptions.ReportMode.ALL)) {
            this.appendClassResult(output, result, isImmutable);
        } else if (this.reportMode.equals((Object)CommandLineOptions.ReportMode.IMMUTABLE)) {
            if (result.isImmutable.equals((Object)IsImmutable.IMMUTABLE)) {
                this.appendClassResult(output, result, isImmutable);
            }
        } else if (this.reportMode.equals((Object)CommandLineOptions.ReportMode.MUTABLE) && result.isImmutable.equals((Object)IsImmutable.NOT_IMMUTABLE)) {
            this.appendClassResult(output, result, isImmutable);
        }
    }

    private void appendClassResult(StringBuilder output, AnalysisResult result, IsImmutable isImmutable) {
        output.append(String.format("%s is %s%n", result.className, isImmutable.name()));
        if (!result.isImmutable.equals((Object)IsImmutable.IMMUTABLE)) {
            this.addReasons(result, output);
        }
    }

    private void addReasons(AnalysisResult result, StringBuilder output) {
        if (!this.verbose) {
            return;
        }
        for (MutableReasonDetail reasonDetail : result.reasons) {
            output.append(String.format("\t%10s %s%n", reasonDetail.message(), reasonDetail.codeLocation().prettyPrint()));
        }
    }

    private static final class ClassnameComparator
    implements Comparator<AnalysisResult>,
    Serializable {
        private static final long serialVersionUID = 1865374158214841422L;

        private ClassnameComparator() {
        }

        @Override
        public int compare(AnalysisResult first, AnalysisResult second) {
            return first.className.asString().compareToIgnoreCase(second.className.asString());
        }
    }
}

