/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.internal.org.reflections.scanners;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.mutabilitydetector.internal.javassist.bytecode.ClassFile;
import org.mutabilitydetector.internal.javassist.bytecode.CodeAttribute;
import org.mutabilitydetector.internal.javassist.bytecode.LocalVariableAttribute;
import org.mutabilitydetector.internal.javassist.bytecode.MethodInfo;
import org.mutabilitydetector.internal.org.reflections.scanners.Scanner;
import org.mutabilitydetector.internal.org.reflections.util.JavassistHelper;

public class MethodParameterNamesScanner
implements Scanner {
    @Override
    public List<Map.Entry<String, String>> scan(ClassFile classFile) {
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>();
        for (MethodInfo method : classFile.getMethods()) {
            String key = JavassistHelper.methodName(classFile, method);
            String value = this.getString(method);
            if (value.isEmpty()) continue;
            entries.add(this.entry(key, value));
        }
        return entries;
    }

    private String getString(MethodInfo method) {
        CodeAttribute codeAttribute = method.getCodeAttribute();
        LocalVariableAttribute table = codeAttribute != null ? (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable") : null;
        int length = JavassistHelper.getParameters(method).size();
        if (length > 0) {
            int shift = Modifier.isStatic(method.getAccessFlags()) ? 0 : 1;
            return IntStream.range(shift, length + shift).mapToObj(i -> method.getConstPool().getUtf8Info(table.nameIndex(i))).filter(name -> !name.startsWith("this$")).collect(Collectors.joining(", "));
        }
        return "";
    }
}

