/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.locations;

import javax.annotation.concurrent.Immutable;
import org.mutabilitydetector.locations.ClassNameConverter;
import org.mutabilitydetector.locations.Dotted;
import org.mutabilitydetector.locations.Slashed;

@Immutable
public final class ClassIdentifier {
    private final Dotted dotted;

    private ClassIdentifier(Dotted className) {
        this.dotted = className;
    }

    public Dotted asDotted() {
        return this.dotted;
    }

    public static ClassIdentifier forClass(Dotted className) {
        return new ClassIdentifier(className);
    }

    public static ClassIdentifier forClass(Slashed className) {
        String slashed = className.asString();
        String dottedString = new ClassNameConverter().dotted(slashed);
        return ClassIdentifier.forClass(Dotted.dotted(dottedString));
    }
}

