/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.listeners.debugging;

import org.nd4j.autodiff.listeners.At;
import org.nd4j.autodiff.listeners.BaseListener;
import org.nd4j.autodiff.listeners.Operation;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.internal.SameDiffOp;
import org.nd4j.common.primitives.Counter;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Enter;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Exit;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.LoopCond;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Merge;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.NextIteration;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Switch;
import org.nd4j.linalg.dataset.api.MultiDataSet;

public class ControlflowListener
extends BaseListener {
    private Counter<String> entersExecuted = new Counter();
    private Counter<String> exitsExecuted = new Counter();
    private Counter<String> mergesExecuted = new Counter();
    private Counter<String> nextIterationExecuted = new Counter();
    private Counter<String> switchesExecuted = new Counter();
    private Counter<String> loopCondExecuted = new Counter();

    @Override
    public boolean isActive(Operation operation) {
        return true;
    }

    @Override
    public void operationStart(SameDiff sd, Operation op) {
        super.operationStart(sd, op);
    }

    @Override
    public void operationEnd(SameDiff sd, Operation op) {
        super.operationEnd(sd, op);
    }

    @Override
    public void preOpExecution(SameDiff sd, At at, SameDiffOp op, OpContext opContext) {
        super.preOpExecution(sd, at, op, opContext);
    }

    @Override
    public void opExecution(SameDiff sd, At at, MultiDataSet batch, SameDiffOp op, OpContext opContext, INDArray[] outputs) {
        super.opExecution(sd, at, batch, op, opContext, outputs);
        if (op.getOp() instanceof Enter) {
            this.entersExecuted.incrementCount((Object)op.getName(), 1.0);
        } else if (op.getOp() instanceof Exit) {
            this.exitsExecuted.incrementCount((Object)op.getName(), 1.0);
        } else if (op.getOp() instanceof NextIteration) {
            this.nextIterationExecuted.incrementCount((Object)op.getName(), 1.0);
        } else if (op.getOp() instanceof Switch) {
            this.switchesExecuted.incrementCount((Object)op.getName(), 1.0);
        } else if (op.getOp() instanceof Merge) {
            this.mergesExecuted.incrementCount((Object)op.getName(), 1.0);
        } else if (op.getOp() instanceof LoopCond) {
            this.loopCondExecuted.incrementCount((Object)op.getName(), 1.0);
        }
    }
}

