/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.imports.converters.DifferentialFunctionClassHolder;
import org.nd4j.imports.descriptors.properties.AttributeAdapter;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.descriptors.properties.adapters.ConditionalFieldValueIntIndexArrayAdapter;
import org.nd4j.imports.descriptors.properties.adapters.NDArrayShapeAdapter;
import org.nd4j.imports.descriptors.properties.adapters.SizeThresholdIntArrayIntIndexAdapter;
import org.nd4j.imports.descriptors.properties.adapters.StringEqualsAdapter;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv2DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class DeConv2DTF
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(DeConv2DTF.class);
    protected DeConv2DConfig config;

    public DeConv2DTF(SameDiff sameDiff, SDVariable[] inputs, DeConv2DConfig config) {
        super(sameDiff, inputs);
        this.config = config;
        this.addArgs();
    }

    public DeConv2DTF(INDArray[] inputs, INDArray[] outputs, DeConv2DConfig config) {
        super(inputs, outputs);
        this.config = config;
        this.addArgs();
    }

    @Override
    public long[] iArgs() {
        if (this.iArguments.size() == 0) {
            this.addArgs();
        }
        return super.iArgs();
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        if (this.config == null && !this.iArguments.isEmpty()) {
            this.config = DeConv2DConfig.builder().kH((Long)this.iArguments.get(0)).kW((Long)this.iArguments.get(1)).sH((Long)this.iArguments.get(2)).sW((Long)this.iArguments.get(3)).pH((Long)this.iArguments.get(4)).pW((Long)this.iArguments.get(5)).dH((Long)this.iArguments.get(6)).dW((Long)this.iArguments.get(7)).isSameMode((Long)this.iArguments.get(8) == 1L).dataFormat((Long)this.iArguments.get(9) == 1L ? "NHWC" : "NCHW").build();
        }
        return this.config.toProperties();
    }

    private void addArgs() {
        this.addIArgument(this.config.getKH());
        this.addIArgument(this.config.getKW());
        this.addIArgument(this.config.getSH());
        this.addIArgument(this.config.getSW());
        this.addIArgument(this.config.getPH());
        this.addIArgument(this.config.getPW());
        this.addIArgument(this.config.getDH());
        this.addIArgument(this.config.getDW());
        this.addIArgument(ArrayUtil.fromBoolean((boolean)this.config.isSameMode()));
        this.addIArgument(this.config.getDataFormat().equalsIgnoreCase("NCHW") ? 0 : 1);
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public Object getValue(Field property) {
        if (this.config == null) {
            this.config = DeConv2DConfig.builder().build();
        }
        return this.config.getValue(property);
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping strideMapping = PropertyMapping.builder().tfAttrName("strides").onnxAttrName("strides").propertyNames(new String[]{"sH", "sW"}).build();
        PropertyMapping kernelMapping = PropertyMapping.builder().propertyNames(new String[]{"kH", "kW"}).tfInputPosition(1).onnxAttrName("kernel_shape").build();
        PropertyMapping dilationMapping = PropertyMapping.builder().onnxAttrName("dilations").propertyNames(new String[]{"dW", "dH"}).tfAttrName("rates").build();
        PropertyMapping sameMode = PropertyMapping.builder().onnxAttrName("auto_pad").propertyNames(new String[]{"isSameMode"}).tfAttrName("padding").build();
        PropertyMapping dataFormat = PropertyMapping.builder().onnxAttrName("data_format").tfAttrName("data_format").propertyNames(new String[]{"dataFormat"}).build();
        map.put("sW", strideMapping);
        map.put("sH", strideMapping);
        map.put("kH", kernelMapping);
        map.put("kW", kernelMapping);
        map.put("dW", dilationMapping);
        map.put("dH", dilationMapping);
        map.put("isSameMode", sameMode);
        map.put("dataFormat", dataFormat);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public Map<String, Map<String, AttributeAdapter>> attributeAdaptersForFunction() {
        HashMap<String, Map<String, AttributeAdapter>> ret = new HashMap<String, Map<String, AttributeAdapter>>();
        LinkedHashMap<String, AttributeAdapter> tfMappings = new LinkedHashMap<String, AttributeAdapter>();
        Map<String, Field> fields = DifferentialFunctionClassHolder.getInstance().getFieldsForFunction(this);
        tfMappings.put("kH", new NDArrayShapeAdapter(0));
        tfMappings.put("kW", new NDArrayShapeAdapter(1));
        tfMappings.put("sH", new ConditionalFieldValueIntIndexArrayAdapter("NCHW", 2, 1, fields.get("dataFormat")));
        tfMappings.put("sW", new ConditionalFieldValueIntIndexArrayAdapter("NCHW", 3, 2, fields.get("dataFormat")));
        tfMappings.put("isSameMode", new StringEqualsAdapter("SAME"));
        tfMappings.put("isNHWC", new StringEqualsAdapter("NHWC"));
        HashMap<String, AttributeAdapter> onnxMappings = new HashMap<String, AttributeAdapter>();
        onnxMappings.put("kH", new SizeThresholdIntArrayIntIndexAdapter(0, 2, 0));
        onnxMappings.put("kW", new SizeThresholdIntArrayIntIndexAdapter(1, 2, 0));
        onnxMappings.put("dH", new SizeThresholdIntArrayIntIndexAdapter(0, 2, 0));
        onnxMappings.put("dW", new SizeThresholdIntArrayIntIndexAdapter(1, 2, 0));
        onnxMappings.put("sH", new SizeThresholdIntArrayIntIndexAdapter(0, 2, 0));
        onnxMappings.put("sW", new SizeThresholdIntArrayIntIndexAdapter(1, 2, 0));
        onnxMappings.put("isSameMode", new StringEqualsAdapter("SAME"));
        onnxMappings.put("isNHWC", new StringEqualsAdapter("NHWC"));
        ret.put(this.tensorflowName(), tfMappings);
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        this.addArgs();
    }

    @Override
    public String opName() {
        return "deconv2d_tf";
    }

    @Override
    public String onnxName() {
        return "ConvTranspose-Absent";
    }

    @Override
    public String tensorflowName() {
        return "Conv2DBackpropInput";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("To be implemented yet");
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == n ? 1 : 0) != 0, (String)"Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        if (!this.dArguments.isEmpty()) {
            return Arrays.asList((DataType)((Object)this.dArguments.get(0)));
        }
        return Collections.singletonList(inputDataTypes.get(2));
    }

    public static DeConv2DTFBuilder sameDiffBuilder() {
        return new DeConv2DTFBuilder();
    }

    public DeConv2DConfig getConfig() {
        return this.config;
    }

    public DeConv2DTF() {
    }

    public static class DeConv2DTFBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputs;
        private DeConv2DConfig config;

        DeConv2DTFBuilder() {
        }

        public DeConv2DTFBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public DeConv2DTFBuilder inputs(SDVariable[] inputs) {
            this.inputs = inputs;
            return this;
        }

        public DeConv2DTFBuilder config(DeConv2DConfig config) {
            this.config = config;
            return this;
        }

        public DeConv2DTF build() {
            return new DeConv2DTF(this.sameDiff, this.inputs, this.config);
        }

        public String toString() {
            return "DeConv2DTF.DeConv2DTFBuilder(sameDiff=" + this.sameDiff + ", inputs=" + Arrays.deepToString(this.inputs) + ", config=" + this.config + ")";
        }
    }
}

