/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.BaseConvolutionConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.PaddingMode;
import org.nd4j.linalg.util.ConvConfigUtil;

public class Pooling2DConfig
extends BaseConvolutionConfig {
    private long kH;
    private long kW;
    private long sH;
    private long sW;
    private long pH;
    private long pW;
    private double extra;
    private Pooling2D.Pooling2DType type;
    private Pooling2D.Divisor divisor;
    private PaddingMode paddingMode;
    private long dH;
    private long dW;
    private boolean isNHWC;

    public Pooling2DConfig(long kH, long kW, long sH, long sW, long pH, long pW, double extra, Pooling2D.Pooling2DType type, Pooling2D.Divisor divisor, PaddingMode paddingMode, long dH, long dW, boolean isNHWC) {
        this.kH = kH;
        this.kW = kW;
        this.sH = sH;
        this.sW = sW;
        this.pH = pH;
        this.pW = pW;
        this.extra = extra;
        this.type = type;
        this.divisor = divisor;
        this.paddingMode = paddingMode;
        this.dH = dH;
        this.dW = dW;
        this.isNHWC = isNHWC;
        this.validate();
    }

    @Override
    public Map<String, Object> toProperties() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("kH", this.kH);
        ret.put("kW", this.kW);
        ret.put("sH", this.sH);
        ret.put("sW", this.sW);
        ret.put("pH", this.pH);
        ret.put("pW", this.pW);
        ret.put("extra", this.extra);
        ret.put("type", this.type.toString());
        ret.put("paddingMode", (Object)this.paddingMode);
        ret.put("dH", this.dH);
        ret.put("dW", this.dW);
        ret.put("isNHWC", this.isNHWC);
        return ret;
    }

    @Override
    protected void validate() {
        ConvConfigUtil.validate2D(this.kH, this.kW, this.sH, this.sW, this.pH, this.pW, this.dH, this.dW);
    }

    private static long $default$kH() {
        return -1L;
    }

    private static long $default$kW() {
        return -1L;
    }

    private static long $default$sH() {
        return 1L;
    }

    private static long $default$sW() {
        return 1L;
    }

    private static long $default$pH() {
        return 0L;
    }

    private static long $default$pW() {
        return 0L;
    }

    private static Pooling2D.Pooling2DType $default$type() {
        return Pooling2D.Pooling2DType.MAX;
    }

    private static Pooling2D.Divisor $default$divisor() {
        return Pooling2D.Divisor.EXCLUDE_PADDING;
    }

    private static PaddingMode $default$paddingMode() {
        return PaddingMode.VALID;
    }

    private static long $default$dH() {
        return 1L;
    }

    private static long $default$dW() {
        return 1L;
    }

    private static boolean $default$isNHWC() {
        return false;
    }

    public static Pooling2DConfigBuilder builder() {
        return new Pooling2DConfigBuilder();
    }

    public long getKH() {
        return this.kH;
    }

    public long getKW() {
        return this.kW;
    }

    public long getSH() {
        return this.sH;
    }

    public long getSW() {
        return this.sW;
    }

    public long getPH() {
        return this.pH;
    }

    public long getPW() {
        return this.pW;
    }

    public double getExtra() {
        return this.extra;
    }

    public Pooling2D.Pooling2DType getType() {
        return this.type;
    }

    public Pooling2D.Divisor getDivisor() {
        return this.divisor;
    }

    public PaddingMode getPaddingMode() {
        return this.paddingMode;
    }

    public long getDH() {
        return this.dH;
    }

    public long getDW() {
        return this.dW;
    }

    public boolean isNHWC() {
        return this.isNHWC;
    }

    public void setKH(long kH) {
        this.kH = kH;
    }

    public void setKW(long kW) {
        this.kW = kW;
    }

    public void setSH(long sH) {
        this.sH = sH;
    }

    public void setSW(long sW) {
        this.sW = sW;
    }

    public void setPH(long pH) {
        this.pH = pH;
    }

    public void setPW(long pW) {
        this.pW = pW;
    }

    public void setExtra(double extra) {
        this.extra = extra;
    }

    public void setType(Pooling2D.Pooling2DType type) {
        this.type = type;
    }

    public void setDivisor(Pooling2D.Divisor divisor) {
        this.divisor = divisor;
    }

    public void setPaddingMode(PaddingMode paddingMode) {
        this.paddingMode = paddingMode;
    }

    public void setDH(long dH) {
        this.dH = dH;
    }

    public void setDW(long dW) {
        this.dW = dW;
    }

    public void setNHWC(boolean isNHWC) {
        this.isNHWC = isNHWC;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pooling2DConfig)) {
            return false;
        }
        Pooling2DConfig other = (Pooling2DConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getKH() != other.getKH()) {
            return false;
        }
        if (this.getKW() != other.getKW()) {
            return false;
        }
        if (this.getSH() != other.getSH()) {
            return false;
        }
        if (this.getSW() != other.getSW()) {
            return false;
        }
        if (this.getPH() != other.getPH()) {
            return false;
        }
        if (this.getPW() != other.getPW()) {
            return false;
        }
        if (Double.compare(this.getExtra(), other.getExtra()) != 0) {
            return false;
        }
        if (this.getDH() != other.getDH()) {
            return false;
        }
        if (this.getDW() != other.getDW()) {
            return false;
        }
        if (this.isNHWC() != other.isNHWC()) {
            return false;
        }
        Pooling2D.Pooling2DType this$type = this.getType();
        Pooling2D.Pooling2DType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Pooling2D.Divisor this$divisor = this.getDivisor();
        Pooling2D.Divisor other$divisor = other.getDivisor();
        if (this$divisor == null ? other$divisor != null : !((Object)((Object)this$divisor)).equals((Object)other$divisor)) {
            return false;
        }
        PaddingMode this$paddingMode = this.getPaddingMode();
        PaddingMode other$paddingMode = other.getPaddingMode();
        return !(this$paddingMode == null ? other$paddingMode != null : !((Object)((Object)this$paddingMode)).equals((Object)other$paddingMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pooling2DConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $kH = this.getKH();
        result = result * 59 + (int)($kH >>> 32 ^ $kH);
        long $kW = this.getKW();
        result = result * 59 + (int)($kW >>> 32 ^ $kW);
        long $sH = this.getSH();
        result = result * 59 + (int)($sH >>> 32 ^ $sH);
        long $sW = this.getSW();
        result = result * 59 + (int)($sW >>> 32 ^ $sW);
        long $pH = this.getPH();
        result = result * 59 + (int)($pH >>> 32 ^ $pH);
        long $pW = this.getPW();
        result = result * 59 + (int)($pW >>> 32 ^ $pW);
        long $extra = Double.doubleToLongBits(this.getExtra());
        result = result * 59 + (int)($extra >>> 32 ^ $extra);
        long $dH = this.getDH();
        result = result * 59 + (int)($dH >>> 32 ^ $dH);
        long $dW = this.getDW();
        result = result * 59 + (int)($dW >>> 32 ^ $dW);
        result = result * 59 + (this.isNHWC() ? 79 : 97);
        Pooling2D.Pooling2DType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Pooling2D.Divisor $divisor = this.getDivisor();
        result = result * 59 + ($divisor == null ? 43 : ((Object)((Object)$divisor)).hashCode());
        PaddingMode $paddingMode = this.getPaddingMode();
        result = result * 59 + ($paddingMode == null ? 43 : ((Object)((Object)$paddingMode)).hashCode());
        return result;
    }

    public String toString() {
        return "Pooling2DConfig(kH=" + this.getKH() + ", kW=" + this.getKW() + ", sH=" + this.getSH() + ", sW=" + this.getSW() + ", pH=" + this.getPH() + ", pW=" + this.getPW() + ", extra=" + this.getExtra() + ", type=" + this.getType() + ", divisor=" + this.getDivisor() + ", paddingMode=" + this.getPaddingMode() + ", dH=" + this.getDH() + ", dW=" + this.getDW() + ", isNHWC=" + this.isNHWC() + ")";
    }

    public Pooling2DConfig() {
        this.kH = Pooling2DConfig.$default$kH();
        this.kW = Pooling2DConfig.$default$kW();
        this.sH = Pooling2DConfig.$default$sH();
        this.sW = Pooling2DConfig.$default$sW();
        this.pH = Pooling2DConfig.$default$pH();
        this.pW = Pooling2DConfig.$default$pW();
        this.type = Pooling2DConfig.$default$type();
        this.divisor = Pooling2DConfig.$default$divisor();
        this.paddingMode = Pooling2DConfig.$default$paddingMode();
        this.dH = Pooling2DConfig.$default$dH();
        this.dW = Pooling2DConfig.$default$dW();
        this.isNHWC = Pooling2DConfig.$default$isNHWC();
    }

    public static class Pooling2DConfigBuilder {
        private boolean kH$set;
        private long kH$value;
        private boolean kW$set;
        private long kW$value;
        private boolean sH$set;
        private long sH$value;
        private boolean sW$set;
        private long sW$value;
        private boolean pH$set;
        private long pH$value;
        private boolean pW$set;
        private long pW$value;
        private double extra;
        private boolean type$set;
        private Pooling2D.Pooling2DType type$value;
        private boolean divisor$set;
        private Pooling2D.Divisor divisor$value;
        private boolean paddingMode$set;
        private PaddingMode paddingMode$value;
        private boolean dH$set;
        private long dH$value;
        private boolean dW$set;
        private long dW$value;
        private boolean isNHWC$set;
        private boolean isNHWC$value;

        Pooling2DConfigBuilder() {
        }

        public Pooling2DConfigBuilder kH(long kH) {
            this.kH$value = kH;
            this.kH$set = true;
            return this;
        }

        public Pooling2DConfigBuilder kW(long kW) {
            this.kW$value = kW;
            this.kW$set = true;
            return this;
        }

        public Pooling2DConfigBuilder sH(long sH) {
            this.sH$value = sH;
            this.sH$set = true;
            return this;
        }

        public Pooling2DConfigBuilder sW(long sW) {
            this.sW$value = sW;
            this.sW$set = true;
            return this;
        }

        public Pooling2DConfigBuilder pH(long pH) {
            this.pH$value = pH;
            this.pH$set = true;
            return this;
        }

        public Pooling2DConfigBuilder pW(long pW) {
            this.pW$value = pW;
            this.pW$set = true;
            return this;
        }

        public Pooling2DConfigBuilder extra(double extra) {
            this.extra = extra;
            return this;
        }

        public Pooling2DConfigBuilder type(Pooling2D.Pooling2DType type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public Pooling2DConfigBuilder divisor(Pooling2D.Divisor divisor) {
            this.divisor$value = divisor;
            this.divisor$set = true;
            return this;
        }

        public Pooling2DConfigBuilder paddingMode(PaddingMode paddingMode) {
            this.paddingMode$value = paddingMode;
            this.paddingMode$set = true;
            return this;
        }

        public Pooling2DConfigBuilder dH(long dH) {
            this.dH$value = dH;
            this.dH$set = true;
            return this;
        }

        public Pooling2DConfigBuilder dW(long dW) {
            this.dW$value = dW;
            this.dW$set = true;
            return this;
        }

        public Pooling2DConfigBuilder isNHWC(boolean isNHWC) {
            this.isNHWC$value = isNHWC;
            this.isNHWC$set = true;
            return this;
        }

        public Pooling2DConfig build() {
            long kH$value = this.kH$value;
            if (!this.kH$set) {
                kH$value = Pooling2DConfig.$default$kH();
            }
            long kW$value = this.kW$value;
            if (!this.kW$set) {
                kW$value = Pooling2DConfig.$default$kW();
            }
            long sH$value = this.sH$value;
            if (!this.sH$set) {
                sH$value = Pooling2DConfig.$default$sH();
            }
            long sW$value = this.sW$value;
            if (!this.sW$set) {
                sW$value = Pooling2DConfig.$default$sW();
            }
            long pH$value = this.pH$value;
            if (!this.pH$set) {
                pH$value = Pooling2DConfig.$default$pH();
            }
            long pW$value = this.pW$value;
            if (!this.pW$set) {
                pW$value = Pooling2DConfig.$default$pW();
            }
            Pooling2D.Pooling2DType type$value = this.type$value;
            if (!this.type$set) {
                type$value = Pooling2DConfig.$default$type();
            }
            Pooling2D.Divisor divisor$value = this.divisor$value;
            if (!this.divisor$set) {
                divisor$value = Pooling2DConfig.$default$divisor();
            }
            PaddingMode paddingMode$value = this.paddingMode$value;
            if (!this.paddingMode$set) {
                paddingMode$value = Pooling2DConfig.$default$paddingMode();
            }
            long dH$value = this.dH$value;
            if (!this.dH$set) {
                dH$value = Pooling2DConfig.$default$dH();
            }
            long dW$value = this.dW$value;
            if (!this.dW$set) {
                dW$value = Pooling2DConfig.$default$dW();
            }
            boolean isNHWC$value = this.isNHWC$value;
            if (!this.isNHWC$set) {
                isNHWC$value = Pooling2DConfig.$default$isNHWC();
            }
            return new Pooling2DConfig(kH$value, kW$value, sH$value, sW$value, pH$value, pW$value, this.extra, type$value, divisor$value, paddingMode$value, dH$value, dW$value, isNHWC$value);
        }

        public String toString() {
            return "Pooling2DConfig.Pooling2DConfigBuilder(kH$value=" + this.kH$value + ", kW$value=" + this.kW$value + ", sH$value=" + this.sH$value + ", sW$value=" + this.sW$value + ", pH$value=" + this.pH$value + ", pW$value=" + this.pW$value + ", extra=" + this.extra + ", type$value=" + this.type$value + ", divisor$value=" + this.divisor$value + ", paddingMode$value=" + this.paddingMode$value + ", dH$value=" + this.dH$value + ", dW$value=" + this.dW$value + ", isNHWC$value=" + this.isNHWC$value + ")";
        }
    }
}

