/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.comparison;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformSameOp;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.indexing.conditions.Conditions;

public class CompareAndSet
extends BaseTransformSameOp {
    private Condition condition;
    private double compare;
    private double set;
    private double eps;
    private Conditions.ConditionMode mode;

    public CompareAndSet(SameDiff sameDiff, SDVariable to, Number set, Condition condition) {
        super(sameDiff, to, false);
        this.condition = condition;
        this.compare = condition.getValue();
        this.set = set.doubleValue();
        this.mode = condition.conditionType();
        this.eps = condition.epsThreshold();
        this.extraArgs = new Object[]{this.compare, set, this.eps, (double)this.mode.index};
    }

    public CompareAndSet() {
    }

    public CompareAndSet(INDArray x, double compare, double set, double eps) {
        this(x, compare, set, eps, null);
    }

    public CompareAndSet(INDArray x, double compare, double set, double eps, Condition condition) {
        super(x);
        this.compare = compare;
        this.set = set;
        this.eps = eps;
        this.mode = condition == null ? Conditions.fromInt(0).conditionType() : condition.conditionType();
        this.extraArgs = new Object[]{compare, set, eps, (double)this.mode.index};
    }

    public CompareAndSet(INDArray x, double set, Condition condition) {
        this(x, x, set, condition);
    }

    public CompareAndSet(INDArray x, INDArray z, double set, Condition condition) {
        super(x, null, z);
        this.compare = condition.getValue();
        this.set = set;
        this.eps = condition.epsThreshold();
        this.mode = condition.conditionType();
        this.extraArgs = new Object[]{this.compare, set, this.eps, (double)this.mode.index};
    }

    public CompareAndSet(INDArray x, INDArray y, Condition condition) {
        this(x, y, x, condition);
    }

    public CompareAndSet(INDArray x, INDArray y, INDArray z, Condition condition) {
        super(x, y, z);
        this.compare = condition.getValue();
        this.set = 0.0;
        this.eps = condition.epsThreshold();
        this.mode = condition.conditionType();
        this.extraArgs = new Object[]{this.compare, this.set, this.eps, (double)this.mode.index};
    }

    public CompareAndSet(INDArray x, INDArray z, double compare, double set, double eps) {
        super(x, z);
        this.compare = compare;
        this.set = set;
        this.eps = eps;
        this.mode = Conditions.fromInt(0, compare).conditionType();
        this.extraArgs = new Object[]{compare, set, eps, (double)this.mode.index};
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("compare", this.compare);
        ret.put("set", this.set);
        ret.put("eps", this.eps);
        ret.put("mode", (Object)this.mode);
        return ret;
    }

    @Override
    public int opNum() {
        if (this.y() == null) {
            return 13;
        }
        return 12;
    }

    @Override
    public String opName() {
        return "cas";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        if (properties.containsKey("mode")) {
            Object mode;
            if (properties.get("mode") instanceof Integer) {
                mode = (Integer)properties.get("mode");
                this.mode = Conditions.ConditionMode.fromNumber((Integer)mode);
                if (!properties.containsKey("compare")) {
                    this.condition = Conditions.fromInt((Integer)mode);
                }
            } else if (properties.get("mode") instanceof Conditions.ConditionMode) {
                mode = (Conditions.ConditionMode)((Object)properties.get("mode"));
                this.mode = mode;
                if (!properties.containsKey("compare")) {
                    this.condition = Conditions.fromInt(((Conditions.ConditionMode)((Object)mode)).index);
                }
            }
        }
        if (properties.containsKey("compare")) {
            Double compare = (Double)properties.get("compare");
            this.compare = compare;
            if (properties.containsKey("mode")) {
                if (properties.get("mode") instanceof String) {
                    Conditions.ConditionMode mode = Conditions.ConditionMode.valueOf(properties.get("mode").toString());
                    this.condition = Conditions.fromInt(mode.index, compare);
                } else {
                    Integer mode2 = (Integer)properties.get("mode");
                    this.condition = Conditions.fromInt(mode2, compare);
                }
            }
        }
        if (properties.containsKey("set")) {
            Double set = (Double)properties.get("set");
            this.set = set;
        }
        if (properties.containsKey("eps")) {
            Double eps = (Double)properties.get("eps");
            this.eps = eps;
        }
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradient) {
        SDVariable maskNotMatched = this.sameDiff.matchCondition(this.arg(), this.condition).castTo(this.arg().dataType()).rsub(1.0);
        SDVariable gradAtIn = gradient.get(0).mul(maskNotMatched);
        SDVariable[] args = this.args();
        if (args.length == 1) {
            return Arrays.asList(gradAtIn);
        }
        return Arrays.asList(gradAtIn, gradAtIn);
    }
}

