/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.iterator;

import java.util.ArrayList;
import java.util.List;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class TestDataSetIterator
implements DataSetIterator {
    private static final long serialVersionUID = -7569201667767185411L;
    private int curr = 0;
    private int batch = 10;
    private List<DataSet> list;
    private DataSetPreProcessor preProcessor;

    public TestDataSetIterator(DataSet dataset, int batch) {
        this(dataset.asList(), batch);
    }

    public TestDataSetIterator(List<DataSet> coll, int batch) {
        this.list = new ArrayList<DataSet>(coll);
        this.batch = batch;
    }

    public TestDataSetIterator(DataSet dataset) {
        this(dataset, 5);
    }

    @Override
    public synchronized boolean hasNext() {
        return this.curr < this.list.size();
    }

    @Override
    public synchronized DataSet next() {
        return this.next(this.batch);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int inputColumns() {
        return this.list.get(0).getFeatures().columns();
    }

    @Override
    public int totalOutcomes() {
        return this.list.get(0).getLabels().columns();
    }

    @Override
    public boolean resetSupported() {
        return true;
    }

    @Override
    public boolean asyncSupported() {
        return false;
    }

    @Override
    public synchronized void reset() {
        this.curr = 0;
    }

    @Override
    public int batch() {
        return this.batch;
    }

    @Override
    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    @Override
    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    @Override
    public List<String> getLabels() {
        return null;
    }

    @Override
    public DataSet next(int num) {
        int end = this.curr + num;
        ArrayList<DataSet> r = new ArrayList<DataSet>();
        if (end >= this.list.size()) {
            end = this.list.size();
        }
        while (this.curr < end) {
            r.add(this.list.get(this.curr));
            ++this.curr;
        }
        DataSet d = DataSet.merge(r);
        if (this.preProcessor != null) {
            this.preProcessor.preProcess(d);
        }
        return d;
    }
}

