/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.preprocessor;

import java.io.File;
import java.io.IOException;
import lombok.NonNull;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.preprocessor.AbstractDataSetNormalizer;
import org.nd4j.linalg.dataset.api.preprocessor.MinMaxStrategy;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.NormalizerType;
import org.nd4j.linalg.dataset.api.preprocessor.stats.MinMaxStats;
import org.nd4j.linalg.dataset.api.preprocessor.stats.NormalizerStats;
import org.nd4j.linalg.factory.Nd4j;

public class NormalizerMinMaxScaler
extends AbstractDataSetNormalizer<MinMaxStats> {
    public NormalizerMinMaxScaler() {
        this(0.0, 1.0);
    }

    public NormalizerMinMaxScaler(double minRange, double maxRange) {
        super(new MinMaxStrategy(minRange, maxRange));
    }

    public void setFeatureStats(@NonNull INDArray featureMin, @NonNull INDArray featureMax) {
        if (featureMin == null) {
            throw new NullPointerException("featureMin is marked non-null but is null");
        }
        if (featureMax == null) {
            throw new NullPointerException("featureMax is marked non-null but is null");
        }
        this.setFeatureStats(new MinMaxStats(featureMin, featureMax));
    }

    public void setLabelStats(@NonNull INDArray labelMin, @NonNull INDArray labelMax) {
        if (labelMin == null) {
            throw new NullPointerException("labelMin is marked non-null but is null");
        }
        if (labelMax == null) {
            throw new NullPointerException("labelMax is marked non-null but is null");
        }
        this.setLabelStats(new MinMaxStats(labelMin, labelMax));
    }

    public double getTargetMin() {
        return ((MinMaxStrategy)this.strategy).getMinRange();
    }

    public double getTargetMax() {
        return ((MinMaxStrategy)this.strategy).getMaxRange();
    }

    public INDArray getMin() {
        return ((MinMaxStats)this.getFeatureStats()).getLower();
    }

    public INDArray getMax() {
        return ((MinMaxStats)this.getFeatureStats()).getUpper();
    }

    public INDArray getLabelMin() {
        return ((MinMaxStats)this.getLabelStats()).getLower();
    }

    public INDArray getLabelMax() {
        return ((MinMaxStats)this.getLabelStats()).getUpper();
    }

    public void load(File ... statistics) throws IOException {
        this.setFeatureStats(new MinMaxStats(Nd4j.readBinary(statistics[0]), Nd4j.readBinary(statistics[1])));
        if (this.isFitLabel()) {
            this.setLabelStats(new MinMaxStats(Nd4j.readBinary(statistics[2]), Nd4j.readBinary(statistics[3])));
        }
    }

    public void save(File ... files) throws IOException {
        Nd4j.saveBinary(this.getMin(), files[0]);
        Nd4j.saveBinary(this.getMax(), files[1]);
        if (this.isFitLabel()) {
            Nd4j.saveBinary(this.getLabelMin(), files[2]);
            Nd4j.saveBinary(this.getLabelMax(), files[3]);
        }
    }

    @Override
    protected NormalizerStats.Builder newBuilder() {
        return new MinMaxStats.Builder();
    }

    @Override
    public NormalizerType getType() {
        return NormalizerType.MIN_MAX;
    }
}

