/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.schedule;

import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.linalg.schedule.ScheduleType;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class PolySchedule
implements ISchedule {
    private final ScheduleType scheduleType;
    private final double initialValue;
    private final double power;
    private final int maxIter;

    public PolySchedule(@JsonProperty(value="scheduleType") ScheduleType scheduleType, @JsonProperty(value="initialValue") double initialValue, @JsonProperty(value="power") double power, @JsonProperty(value="maxIter") int maxIter) {
        this.scheduleType = scheduleType;
        this.initialValue = initialValue;
        this.power = power;
        this.maxIter = maxIter;
    }

    @Override
    public double valueAt(int iteration, int epoch) {
        int i;
        int n = i = this.scheduleType == ScheduleType.ITERATION ? iteration : epoch;
        if (i >= this.maxIter) {
            return 0.0;
        }
        return this.initialValue * Math.pow(1.0 + (double)i / (double)this.maxIter, this.power);
    }

    @Override
    public PolySchedule clone() {
        return new PolySchedule(this.scheduleType, this.initialValue, this.power, this.maxIter);
    }

    public ScheduleType getScheduleType() {
        return this.scheduleType;
    }

    public double getInitialValue() {
        return this.initialValue;
    }

    public double getPower() {
        return this.power;
    }

    public int getMaxIter() {
        return this.maxIter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PolySchedule)) {
            return false;
        }
        PolySchedule other = (PolySchedule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getInitialValue(), other.getInitialValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getPower(), other.getPower()) != 0) {
            return false;
        }
        if (this.getMaxIter() != other.getMaxIter()) {
            return false;
        }
        ScheduleType this$scheduleType = this.getScheduleType();
        ScheduleType other$scheduleType = other.getScheduleType();
        return !(this$scheduleType == null ? other$scheduleType != null : !((Object)((Object)this$scheduleType)).equals((Object)other$scheduleType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PolySchedule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $initialValue = Double.doubleToLongBits(this.getInitialValue());
        result = result * 59 + (int)($initialValue >>> 32 ^ $initialValue);
        long $power = Double.doubleToLongBits(this.getPower());
        result = result * 59 + (int)($power >>> 32 ^ $power);
        result = result * 59 + this.getMaxIter();
        ScheduleType $scheduleType = this.getScheduleType();
        result = result * 59 + ($scheduleType == null ? 43 : ((Object)((Object)$scheduleType)).hashCode());
        return result;
    }

    public String toString() {
        return "PolySchedule(scheduleType=" + this.getScheduleType() + ", initialValue=" + this.getInitialValue() + ", power=" + this.getPower() + ", maxIter=" + this.getMaxIter() + ")";
    }
}

