/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public abstract class DeviceLocal<T> {
    protected Map<Integer, T> backingMap = new ConcurrentHashMap<Integer, T>();
    protected List<ReentrantReadWriteLock> locksMap = new ArrayList<ReentrantReadWriteLock>();
    protected List<AtomicInteger> updatesMap = new ArrayList<AtomicInteger>();
    protected final boolean delayedMode;
    protected volatile INDArray delayedArray;
    protected int lastSettledDevice = -1;

    public DeviceLocal(boolean delayedMode) {
        this.delayedMode = delayedMode;
        int numDevices = Nd4j.getAffinityManager().getNumberOfDevices();
        for (int i = 0; i < numDevices; ++i) {
            this.locksMap.add(new ReentrantReadWriteLock());
            this.updatesMap.add(new AtomicInteger(-1));
        }
    }

    @Nullable
    public T get() {
        return this.get(Nd4j.getAffinityManager().getDeviceForCurrentThread());
    }

    @Nullable
    public T get(int deviceId) {
        try {
            this.locksMap.get(deviceId).readLock().lock();
            T t = this.backingMap.get(deviceId);
            return t;
        }
        finally {
            this.locksMap.get(deviceId).readLock().unlock();
        }
    }

    public void set(int deviceId, T object) {
        try {
            this.locksMap.get(deviceId).writeLock().lock();
            this.backingMap.put(deviceId, object);
        }
        finally {
            this.locksMap.get(deviceId).writeLock().unlock();
        }
    }

    public void set(T object) {
        this.set(Nd4j.getAffinityManager().getDeviceForCurrentThread(), object);
    }

    public void clear() {
        int deviceId = Nd4j.getAffinityManager().getDeviceForCurrentThread();
        try {
            this.locksMap.get(deviceId).writeLock().lock();
            this.backingMap.remove(deviceId);
        }
        finally {
            this.locksMap.get(deviceId).writeLock().unlock();
        }
    }
}

