/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import java.util.Arrays;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class IdentityInitScheme
extends BaseWeightInitScheme {
    public IdentityInitScheme(char order) {
        super(order);
    }

    @Override
    public INDArray doCreate(DataType dataType, long[] shape, INDArray paramsView) {
        if (shape.length != 2 || shape[0] != shape[1]) {
            throw new IllegalStateException("Cannot use IDENTITY init with parameters of shape " + Arrays.toString(shape) + ": weights must be a square matrix for identity");
        }
        if (this.order() == Nd4j.order().charValue()) {
            return Nd4j.eye(shape[0]);
        }
        return Nd4j.createUninitialized(dataType, shape, this.order()).assign(Nd4j.eye(shape[0]));
    }

    @Override
    public WeightInit type() {
        return WeightInit.IDENTITY;
    }

    public static IdentityInitSchemeBuilder builder() {
        return new IdentityInitSchemeBuilder();
    }

    public static class IdentityInitSchemeBuilder {
        private char order;

        IdentityInitSchemeBuilder() {
        }

        public IdentityInitSchemeBuilder order(char order) {
            this.order = order;
            return this;
        }

        public IdentityInitScheme build() {
            return new IdentityInitScheme(this.order);
        }

        public String toString() {
            return "IdentityInitScheme.IdentityInitSchemeBuilder(order=" + this.order + ")";
        }
    }
}

