/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.async.outbound;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.netty.impl.async.connection.BoltProtocolUtil;
import org.neo4j.bolt.connection.netty.impl.async.outbound.ChunkAwareByteBufOutput;
import org.neo4j.bolt.connection.netty.impl.logging.ChannelActivityLogger;
import org.neo4j.bolt.connection.netty.impl.messaging.BoltPatchesListener;
import org.neo4j.bolt.connection.netty.impl.messaging.Message;
import org.neo4j.bolt.connection.netty.impl.messaging.MessageFormat;
import org.neo4j.bolt.connection.values.ValueFactory;

public class OutboundMessageHandler
extends MessageToMessageEncoder<Message>
implements BoltPatchesListener {
    public static final String NAME = OutboundMessageHandler.class.getSimpleName();
    private final ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput();
    private final MessageFormat messageFormat;
    private final LoggingProvider logging;
    private final ValueFactory valueFactory;
    private MessageFormat.Writer writer;
    private System.Logger log;

    public OutboundMessageHandler(MessageFormat messageFormat, LoggingProvider logging, ValueFactory valueFactory) {
        this.messageFormat = messageFormat;
        this.logging = logging;
        this.writer = messageFormat.newWriter(this.output, valueFactory);
        this.valueFactory = Objects.requireNonNull(valueFactory);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.log = new ChannelActivityLogger(ctx.channel(), this.logging, this.getClass());
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.log = null;
    }

    protected void encode(ChannelHandlerContext ctx, Message msg, List<Object> out) {
        this.log.log(System.Logger.Level.DEBUG, "C: %s", msg);
        ByteBuf messageBuf = ctx.alloc().ioBuffer();
        this.output.start(messageBuf);
        try {
            this.writer.write(msg);
            this.output.stop();
        }
        catch (Throwable error) {
            this.output.stop();
            messageBuf.release();
            throw new EncoderException("Failed to write outbound message: " + String.valueOf(msg), error);
        }
        if (this.log.isLoggable(System.Logger.Level.TRACE)) {
            this.log.log(System.Logger.Level.TRACE, "C: %s", ByteBufUtil.hexDump((ByteBuf)messageBuf));
        }
        BoltProtocolUtil.writeMessageBoundary(messageBuf);
        out.add(messageBuf);
    }

    @Override
    public void handle(Set<String> patches) {
        if (patches.contains("utc")) {
            this.messageFormat.enableDateTimeUtc();
            this.writer = this.messageFormat.newWriter(this.output, this.valueFactory);
        }
    }
}

