/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.neo4j.bolt.connection.BoltServerAddress;

public final class ClusterComposition {
    private final Set<BoltServerAddress> readers = new LinkedHashSet<BoltServerAddress>();
    private final Set<BoltServerAddress> writers = new LinkedHashSet<BoltServerAddress>();
    private final Set<BoltServerAddress> routers = new LinkedHashSet<BoltServerAddress>();
    private final long expirationTimestamp;
    private final String databaseName;

    private ClusterComposition(long expirationTimestamp, String databaseName) {
        this.expirationTimestamp = expirationTimestamp;
        this.databaseName = databaseName;
    }

    public ClusterComposition(long expirationTimestamp, Set<BoltServerAddress> readers, Set<BoltServerAddress> writers, Set<BoltServerAddress> routers, String databaseName) {
        this(expirationTimestamp, databaseName);
        this.readers.addAll(readers);
        this.writers.addAll(writers);
        this.routers.addAll(routers);
    }

    public boolean hasWriters() {
        return !this.writers.isEmpty();
    }

    public boolean hasRoutersAndReaders() {
        return !this.routers.isEmpty() && !this.readers.isEmpty();
    }

    public Set<BoltServerAddress> readers() {
        return new LinkedHashSet<BoltServerAddress>(this.readers);
    }

    public Set<BoltServerAddress> writers() {
        return new LinkedHashSet<BoltServerAddress>(this.writers);
    }

    public Set<BoltServerAddress> routers() {
        return new LinkedHashSet<BoltServerAddress>(this.routers);
    }

    public long expirationTimestamp() {
        return this.expirationTimestamp;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterComposition that = (ClusterComposition)o;
        return this.expirationTimestamp == that.expirationTimestamp && Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.readers, that.readers) && Objects.equals(this.writers, that.writers) && Objects.equals(this.routers, that.routers);
    }

    public int hashCode() {
        return Objects.hash(this.readers, this.writers, this.routers, this.expirationTimestamp, this.databaseName);
    }

    public String toString() {
        return "ClusterComposition{readers=" + String.valueOf(this.readers) + ", writers=" + String.valueOf(this.writers) + ", routers=" + String.valueOf(this.routers) + ", expirationTimestamp=" + this.expirationTimestamp + ", databaseName=" + this.databaseName + "}";
    }

    private Set<BoltServerAddress> servers(String role) {
        return switch (role) {
            case "READ" -> this.readers;
            case "WRITE" -> this.writers;
            case "ROUTE" -> this.routers;
            default -> throw new IllegalArgumentException("invalid server role: " + role);
        };
    }
}

