/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.URI;
import java.time.Clock;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.ClientCertificateManager;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.MetricsAdapter;
import org.neo4j.driver.internal.BoltLoggingProvider;
import org.neo4j.driver.internal.IdentityResolver;
import org.neo4j.driver.internal.InternalDriver;
import org.neo4j.driver.internal.InternalServerAddress;
import org.neo4j.driver.internal.RoutingSettings;
import org.neo4j.driver.internal.SecuritySettings;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.SessionFactoryImpl;
import org.neo4j.driver.internal.adaptedbolt.AdaptingDriverBoltConnectionProvider;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnectionProvider;
import org.neo4j.driver.internal.adaptedbolt.ErrorMapper;
import org.neo4j.driver.internal.bolt.api.BoltAgent;
import org.neo4j.driver.internal.bolt.api.BoltConnectionProvider;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.DefaultDomainNameResolver;
import org.neo4j.driver.internal.bolt.api.DomainNameResolver;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.api.MetricsListener;
import org.neo4j.driver.internal.bolt.api.RoutingContext;
import org.neo4j.driver.internal.bolt.basicimpl.BootstrapFactory;
import org.neo4j.driver.internal.bolt.basicimpl.NettyBoltConnectionProvider;
import org.neo4j.driver.internal.bolt.pooledimpl.PooledBoltConnectionProvider;
import org.neo4j.driver.internal.bolt.routedimpl.Rediscovery;
import org.neo4j.driver.internal.bolt.routedimpl.RoutedBoltConnectionProvider;
import org.neo4j.driver.internal.boltlistener.BoltConnectionListener;
import org.neo4j.driver.internal.homedb.HomeDatabaseCache;
import org.neo4j.driver.internal.metrics.DevNullMetricsProvider;
import org.neo4j.driver.internal.metrics.InternalMetricsProvider;
import org.neo4j.driver.internal.metrics.MetricsProvider;
import org.neo4j.driver.internal.metrics.MicrometerMetricsProvider;
import org.neo4j.driver.internal.retry.ExponentialBackoffRetryLogic;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.security.BoltSecurityPlanManager;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.security.SecurityPlans;
import org.neo4j.driver.internal.util.DriverInfoUtil;
import org.neo4j.driver.internal.value.BoltValueFactory;
import org.neo4j.driver.net.ServerAddress;
import org.neo4j.driver.net.ServerAddressResolver;

public class DriverFactory {
    public static final String NO_ROUTING_CONTEXT_ERROR_MESSAGE = "Routing parameters are not supported with scheme 'bolt'. Given URI: ";

    public final Driver newInstance(URI uri, AuthTokenManager authTokenManager, ClientCertificateManager clientCertificateManager, Config config) {
        return this.newInstance(uri, authTokenManager, clientCertificateManager, config, null, null, null);
    }

    public final Driver newInstance(URI uri, AuthTokenManager authTokenManager, ClientCertificateManager clientCertificateManager, Config config, SecurityPlan securityPlan, EventLoopGroup eventLoopGroup, Supplier<Rediscovery> rediscoverySupplier) {
        if (securityPlan == null) {
            SecuritySettings settings = new SecuritySettings(config.encrypted(), config.trustStrategy());
            securityPlan = SecurityPlans.createSecurityPlan(settings, uri.getScheme(), clientCertificateManager, config.logging());
        }
        BoltSecurityPlanManager securityPlanManager = BoltSecurityPlanManager.from(securityPlan);
        return this.newInstance(uri, authTokenManager, config, securityPlanManager, eventLoopGroup, rediscoverySupplier);
    }

    public final Driver newInstance(URI uri, AuthTokenManager authTokenManager, Config config, BoltSecurityPlanManager securityPlanManager, EventLoopGroup eventLoopGroup, Supplier<Rediscovery> rediscoverySupplier) {
        boolean ownsEventLoopGroup;
        Bootstrap bootstrap;
        Objects.requireNonNull(authTokenManager, "authTokenProvider must not be null");
        if (eventLoopGroup == null) {
            bootstrap = this.createBootstrap(config.eventLoopThreads());
            ownsEventLoopGroup = true;
        } else {
            bootstrap = this.createBootstrap(eventLoopGroup);
            ownsEventLoopGroup = false;
        }
        InternalServerAddress address = new InternalServerAddress(uri);
        RoutingSettings routingSettings = new RoutingSettings(config.routingTablePurgeDelayMillis(), new RoutingContext(uri));
        EventLoopGroup eventExecutorGroup = bootstrap.config().group();
        RetryLogic retryLogic = this.createRetryLogic(config.maxTransactionRetryTimeMillis(), (EventExecutorGroup)eventExecutorGroup, config.logging());
        MetricsProvider metricsProvider = DriverFactory.getOrCreateMetricsProvider(config, this.createClock());
        return this.createDriver(uri, securityPlanManager, address, bootstrap.group(), routingSettings, retryLogic, metricsProvider, config, authTokenManager, ownsEventLoopGroup, rediscoverySupplier);
    }

    protected static MetricsProvider getOrCreateMetricsProvider(Config config, Clock clock) {
        MetricsAdapter metricsAdapter = config.metricsAdapter();
        if (metricsAdapter == null) {
            metricsAdapter = config.isMetricsEnabled() ? MetricsAdapter.DEFAULT : MetricsAdapter.DEV_NULL;
        }
        return switch (metricsAdapter) {
            default -> throw new IncompatibleClassChangeError();
            case MetricsAdapter.DEV_NULL -> DevNullMetricsProvider.INSTANCE;
            case MetricsAdapter.DEFAULT -> new InternalMetricsProvider(clock, config.logging());
            case MetricsAdapter.MICROMETER -> MicrometerMetricsProvider.forGlobalRegistry();
        };
    }

    private InternalDriver createDriver(URI uri, BoltSecurityPlanManager securityPlanManager, ServerAddress address, EventLoopGroup eventLoopGroup, RoutingSettings routingSettings, RetryLogic retryLogic, MetricsProvider metricsProvider, Config config, AuthTokenManager authTokenManager, boolean ownsEventLoopGroup, Supplier<Rediscovery> rediscoverySupplier) {
        DriverBoltConnectionProvider boltConnectionProvider = null;
        try {
            HomeDatabaseCache homeDatabaseCache = HomeDatabaseCache.newInstance(uri.getScheme().startsWith("neo4j"));
            boltConnectionProvider = this.createDriverBoltConnectionProvider(uri, config, eventLoopGroup, routingSettings, rediscoverySupplier, homeDatabaseCache, new BoltServerAddress(address.host(), address.port()), new RoutingContext(uri), DriverInfoUtil.boltAgent(), config.userAgent(), config.connectionTimeoutMillis(), metricsProvider.metricsListener());
            SessionFactory sessionFactory = this.createSessionFactory(securityPlanManager, boltConnectionProvider, retryLogic, config, authTokenManager, homeDatabaseCache);
            Supplier<CompletionStage<Void>> shutdownSupplier = ownsEventLoopGroup ? () -> {
                CompletableFuture closeFuture = new CompletableFuture();
                eventLoopGroup.shutdownGracefully(200L, 15000L, TimeUnit.MILLISECONDS).addListener(future -> closeFuture.complete(null));
                return closeFuture;
            } : () -> CompletableFuture.completedStage(null);
            InternalDriver driver = this.createDriver(securityPlanManager, sessionFactory, metricsProvider, shutdownSupplier, config);
            Logger log = config.logging().getLog(this.getClass());
            if (uri.getScheme().startsWith("bolt")) {
                log.info("Direct driver instance %s created for server address %s", driver.hashCode(), address);
            } else {
                log.info("Routing driver instance %s created for server address %s", driver.hashCode(), address);
            }
            return driver;
        }
        catch (Throwable driverError) {
            if (boltConnectionProvider != null) {
                boltConnectionProvider.close().toCompletableFuture().join();
            }
            throw driverError;
        }
    }

    private Function<BoltServerAddress, Set<BoltServerAddress>> createBoltServerAddressResolver(Config config) {
        ServerAddressResolver serverAddressResolver = config.resolver() != null ? config.resolver() : IdentityResolver.IDENTITY_RESOLVER;
        return boltAddress -> serverAddressResolver.resolve(ServerAddress.of(boltAddress.host(), boltAddress.port())).stream().map(serverAddress -> new BoltServerAddress(serverAddress.host(), serverAddress.port())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private DriverBoltConnectionProvider createDriverBoltConnectionProvider(URI uri, Config config, EventLoopGroup eventLoopGroup, RoutingSettings routingSettings, Supplier<Rediscovery> rediscoverySupplier, BoltConnectionListener boltConnectionListener, BoltServerAddress address, RoutingContext routingContext, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, MetricsListener metricsListener) {
        Clock clock = this.createClock();
        BoltConnectionProvider boltConnectionProvider = this.createBoltConnectionProvider(uri, config, eventLoopGroup, routingSettings, rediscoverySupplier, boltConnectionListener, address, routingContext, boltAgent, userAgent, connectTimeoutMillis, metricsListener, clock);
        return new AdaptingDriverBoltConnectionProvider(boltConnectionProvider, ErrorMapper.getInstance(), BoltValueFactory.getInstance(), uri.getScheme().startsWith("neo4j"), address, routingContext, boltAgent, userAgent, connectTimeoutMillis);
    }

    protected BoltConnectionProvider createBoltConnectionProvider(URI uri, Config config, EventLoopGroup eventLoopGroup, RoutingSettings routingSettings, Supplier<Rediscovery> rediscoverySupplier, BoltConnectionListener boltConnectionListener, BoltServerAddress address, RoutingContext routingContext, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, MetricsListener metricsListener, Clock clock) {
        BoltConnectionProvider boltConnectionProvider;
        BoltLoggingProvider loggingProvider = new BoltLoggingProvider(config.logging());
        Function<BoltServerAddress, BoltConnectionProvider> pooledBoltConnectionProviderSupplier = selectedAddress -> this.createPooledBoltConnectionProvider(config, eventLoopGroup, clock, loggingProvider, boltConnectionListener, (BoltServerAddress)selectedAddress, routingContext, boltAgent, userAgent, connectTimeoutMillis, metricsListener);
        if (uri.getScheme().startsWith("neo4j")) {
            boltConnectionProvider = this.createRoutedBoltConnectionProvider(config, pooledBoltConnectionProviderSupplier, routingSettings, rediscoverySupplier, clock, loggingProvider, address, routingContext, boltAgent, userAgent, connectTimeoutMillis, metricsListener);
        } else {
            DriverFactory.assertNoRoutingContext(uri, routingSettings);
            boltConnectionProvider = pooledBoltConnectionProviderSupplier.apply(address);
        }
        return boltConnectionProvider;
    }

    private BoltConnectionProvider createRoutedBoltConnectionProvider(Config config, Function<BoltServerAddress, BoltConnectionProvider> pooledBoltConnectionProviderFunction, RoutingSettings routingSettings, Supplier<Rediscovery> rediscoverySupplier, Clock clock, LoggingProvider loggingProvider, BoltServerAddress address, RoutingContext routingContext, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, MetricsListener metricsListener) {
        Function<BoltServerAddress, Set<BoltServerAddress>> boltServerAddressResolver = this.createBoltServerAddressResolver(config);
        Rediscovery rediscovery = rediscoverySupplier != null ? rediscoverySupplier.get() : null;
        return new RoutedBoltConnectionProvider(pooledBoltConnectionProviderFunction, boltServerAddressResolver, this.getDomainNameResolver(), routingSettings.routingTablePurgeDelayMs(), rediscovery, clock, loggingProvider, address, routingContext, boltAgent, userAgent, connectTimeoutMillis, metricsListener);
    }

    private BoltConnectionProvider createPooledBoltConnectionProvider(Config config, EventLoopGroup eventLoopGroup, Clock clock, LoggingProvider loggingProvider, BoltConnectionListener boltConnectionListener, BoltServerAddress address, RoutingContext routingContext, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, MetricsListener metricsListener) {
        BoltConnectionProvider nettyBoltConnectionProvider = this.createNettyBoltConnectionProvider(eventLoopGroup, clock, loggingProvider);
        nettyBoltConnectionProvider = BoltConnectionListener.listeningBoltConnectionProvider(nettyBoltConnectionProvider, boltConnectionListener);
        return new PooledBoltConnectionProvider(nettyBoltConnectionProvider, config.maxConnectionPoolSize(), config.connectionAcquisitionTimeoutMillis(), config.maxConnectionLifetimeMillis(), config.idleTimeBeforeConnectionTest(), clock, loggingProvider, metricsListener, address, routingContext, boltAgent, userAgent, connectTimeoutMillis);
    }

    private BoltConnectionProvider createNettyBoltConnectionProvider(EventLoopGroup eventLoopGroup, Clock clock, LoggingProvider loggingProvider) {
        return new NettyBoltConnectionProvider(eventLoopGroup, clock, this.getDomainNameResolver(), this.localAddress(), loggingProvider, BoltValueFactory.getInstance(), null);
    }

    protected LocalAddress localAddress() {
        return null;
    }

    protected InternalDriver createDriver(BoltSecurityPlanManager securityPlanManager, SessionFactory sessionFactory, MetricsProvider metricsProvider, Supplier<CompletionStage<Void>> shutdownSupplier, Config config) {
        return new InternalDriver(securityPlanManager, sessionFactory, metricsProvider, config.isTelemetryDisabled(), config.notificationConfig(), shutdownSupplier, config.logging());
    }

    protected Clock createClock() {
        return Clock.systemUTC();
    }

    protected SessionFactory createSessionFactory(BoltSecurityPlanManager securityPlanManager, DriverBoltConnectionProvider connectionProvider, RetryLogic retryLogic, Config config, AuthTokenManager authTokenManager, HomeDatabaseCache homeDatabaseCache) {
        return new SessionFactoryImpl(securityPlanManager, connectionProvider, retryLogic, config, authTokenManager, homeDatabaseCache);
    }

    protected RetryLogic createRetryLogic(long maxTransactionRetryTime, EventExecutorGroup eventExecutorGroup, Logging logging) {
        return new ExponentialBackoffRetryLogic(maxTransactionRetryTime, eventExecutorGroup, this.createClock(), logging);
    }

    protected Bootstrap createBootstrap(int size) {
        return BootstrapFactory.newBootstrap(size);
    }

    protected Bootstrap createBootstrap(EventLoopGroup eventLoopGroup) {
        return BootstrapFactory.newBootstrap(eventLoopGroup);
    }

    protected DomainNameResolver getDomainNameResolver() {
        return DefaultDomainNameResolver.getInstance();
    }

    private static void assertNoRoutingContext(URI uri, RoutingSettings routingSettings) {
        RoutingContext routingContext = routingSettings.routingContext();
        if (routingContext.isDefined()) {
            throw new IllegalArgumentException("Routing parameters are not supported with scheme 'bolt'. Given URI: '" + uri + "'");
        }
    }
}

