/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.messaging.v53;

import io.netty.channel.Channel;
import java.time.Clock;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.bolt.api.BoltAgent;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.NotificationConfig;
import org.neo4j.driver.internal.bolt.api.RoutingContext;
import org.neo4j.driver.internal.bolt.api.exception.BoltException;
import org.neo4j.driver.internal.bolt.api.values.Value;
import org.neo4j.driver.internal.bolt.api.values.ValueFactory;
import org.neo4j.driver.internal.bolt.basicimpl.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.bolt.basicimpl.handlers.HelloV51ResponseHandler;
import org.neo4j.driver.internal.bolt.basicimpl.handlers.LogonResponseHandler;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.BoltProtocol;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.request.HelloMessage;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.request.LogonMessage;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v52.BoltProtocolV52;

public class BoltProtocolV53
extends BoltProtocolV52 {
    public static final BoltProtocolVersion VERSION = new BoltProtocolVersion(5, 3);
    public static final BoltProtocol INSTANCE = new BoltProtocolV53();

    @Override
    public CompletionStage<Channel> initializeChannel(Channel channel, String userAgent, BoltAgent boltAgent, Map<String, Value> authMap, RoutingContext routingContext, NotificationConfig notificationConfig, Clock clock, CompletableFuture<Long> latestAuthMillisFuture, ValueFactory valueFactory) {
        BoltException exception = this.verifyNotificationConfigSupported(notificationConfig);
        if (exception != null) {
            return CompletableFuture.failedStage(exception);
        }
        HelloMessage message = routingContext.isServerRoutingEnabled() ? new HelloMessage(userAgent, boltAgent, Collections.emptyMap(), routingContext.toMap(), false, notificationConfig, this.useLegacyNotifications(), valueFactory) : new HelloMessage(userAgent, boltAgent, Collections.emptyMap(), null, false, notificationConfig, this.useLegacyNotifications(), valueFactory);
        CompletableFuture<String> helloFuture = new CompletableFuture<String>();
        ChannelAttributes.messageDispatcher(channel).enqueue(new HelloV51ResponseHandler(channel, helloFuture));
        channel.write((Object)message, channel.voidPromise());
        CompletableFuture logonFuture = new CompletableFuture();
        LogonMessage logon = new LogonMessage(authMap, valueFactory);
        ChannelAttributes.messageDispatcher(channel).enqueue(new LogonResponseHandler(logonFuture, channel, clock, latestAuthMillisFuture));
        channel.writeAndFlush((Object)logon, channel.voidPromise());
        return ((CompletableFuture)helloFuture.thenCompose(ignored -> logonFuture)).thenApply(ignored -> channel);
    }

    @Override
    public BoltProtocolVersion version() {
        return VERSION;
    }
}

