/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.compress.ZipUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
public abstract class FormatCompatibilityVerifier {
    @Inject
    private TestDirectory globalDir;
    @Inject
    protected FileSystemAbstraction globalFs;

    @Test
    public void shouldDetectFormatChange() throws Throwable {
        Path storeFile = this.globalDir.file(this.storeFileName());
        this.doShouldDetectFormatChange(this.zipName(), storeFile);
    }

    protected abstract String zipName();

    protected abstract String storeFileName();

    protected abstract void createStoreFile(Path var1) throws IOException;

    protected abstract void verifyFormat(Path var1) throws IOException, FormatViolationException;

    protected abstract void verifyContent(Path var1) throws IOException;

    private void doShouldDetectFormatChange(String zipName, Path storeFile) throws Throwable {
        try {
            ZipUtils.unzipResource(this.getClass(), (String)zipName, (Path)storeFile);
        }
        catch (NoSuchFileException e) {
            this.createStoreFile(storeFile);
            ZipUtils.zip((FileSystemAbstraction)this.globalFs, (Path)storeFile, (Path)this.globalDir.file(zipName));
            this.tellDeveloperToCommitThisFormatVersion(zipName);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.globalFs.fileExists(storeFile), (String)(zipName + " seems to be missing from resources directory"));
        try {
            this.verifyFormat(storeFile);
        }
        catch (FormatViolationException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"format version"});
            this.globalFs.deleteFile(storeFile);
            this.createStoreFile(storeFile);
            ZipUtils.zip((FileSystemAbstraction)this.globalFs, (Path)storeFile, (Path)this.globalDir.file(zipName));
            this.tellDeveloperToCommitThisFormatVersion(zipName);
        }
        try {
            this.verifyContent(storeFile);
        }
        catch (Throwable t) {
            throw new AssertionError("If this is the single failing test in this component then this failure is a strong indication that format has changed without also incrementing format version(s). Please make necessary format version changes.", t);
        }
    }

    private void tellDeveloperToCommitThisFormatVersion(String zipName) {
        org.junit.jupiter.api.Assertions.fail((String)String.format("This is merely a notification to developer. Format has changed and its version has also been properly incremented. A store file with this new format has been generated and should be committed. Please move the newly created file to correct resources location using command:%nmv \"%s\" \"%s\"%nreplacing the existing file there", this.globalDir.file(zipName), "<corresponding-module>" + FormatCompatibilityVerifier.pathify(".src.test.resources.") + FormatCompatibilityVerifier.pathify(this.getClass().getPackage().getName() + ".") + zipName));
    }

    private static String pathify(String name) {
        return name.replace('.', File.separatorChar);
    }

    public static class FormatViolationException
    extends Exception {
        public FormatViolationException(Throwable cause) {
            super(cause);
        }

        public FormatViolationException(String message) {
            super(message);
        }
    }
}

